<article <?php post_class(); ?>>
    <?php
    $quote_content = rad_get_meta( "quote_content" );
    $quote_author = rad_get_meta( "quote_author" );
    $quote_color    = rad_get_meta( "quote_color", true );
    $quote_bg_color = rad_get_meta( "quote_bg_color", true );
    $quote_bg_image = wp_get_attachment_url( get_post_thumbnail_id());

    $style = "";
    if ( $quote_bg_image != "" && $quote_bg_color != "") {
        $style .= "background: " . esc_attr($quote_bg_color) ." url(". esc_url($quote_bg_image) . ");";
    }
    elseif ( $quote_bg_image != "") {
        $style .= "background: url(". esc_url($quote_bg_image) . ");";
    }

    if ( $quote_bg_color != "") {
        $style .= "background-color: " . esc_attr($quote_bg_color) . ";";
    }

    if ( $quote_color != "" ) {
        $style .= "color:". esc_attr($quote_color) . ";";
    }

    ?>
    <?php if ( !empty( $quote_content )) { ?>
    <div class="post-media quote-post" style="<?php echo esc_attr($style); ?>">
        <blockquote>
            <p><?php echo esc_html($quote_content); ?></p>
        <?php }
              if ( !empty( $quote_author )) { ?>
            <cite class="quote_author"><?php echo esc_html($quote_author); ?></cite>
        </blockquote>
    </div>
    <?php }?>
    <?php   
    get_template_part( "templates/core/single/post", "meta" ); ?>
    <div class="post-body">
    <?php
    the_content(); 
    wp_link_pages();
    ?>
    </div>
    <?php
    get_template_part( "templates/core/single/post", "share" );
    get_template_part( "templates/core/single/post", "tags" );
    get_template_part( "templates/core/single/post", "author" );
    ?>
</article>