<?php
$post_author_box = rad_get_option( "post-author-box" );

$display_name = get_the_author_meta( "display_name", $post->post_author );
if ( empty( $display_name ) )
{
    $display_name = get_the_author_meta( "nickname", $post->post_author );
}


if ( ! empty( $display_name ) &&  $post_author_box != "0")
{
	// Get author's biographical information or description
	$user_description = get_the_author_meta( "user_description", $post->post_author );
	  
	// Get author's website URL 
	$user_website = get_the_author_meta("url", $post->post_author);
	  
	// Get link to the author archive page
	$user_posts = get_author_posts_url( get_the_author_meta( "ID" , $post->post_author));
	  
	echo "<div class=\"post-author-meta\">";
	
	echo get_avatar( get_the_author_meta("user_email") , 90 );//Get the avatar

    echo "<p class=\"author-name\">" . $display_name;
	echo "<span class=\"author-links\"><a href=\"". $user_posts ."\">". esc_html__("View all posts by","aventa") . " " . $display_name . "</a>";
  
	// Check if author has a website in their profile
	if ( ! empty( $user_website ) ) {
		echo " / <a href=\"" . $user_website ."\" target=\"_blank\" rel=\"nofollow\">" . esc_html__("Website","aventa") . "</a>";
	}
    echo "</span>";
    echo "</p>";
    if ( ! empty( $user_description ) )
	{
	   echo "<p class=\"author-details\">" . wp_kses( nl2br( $user_description ), rad_get_allowed_tags()) . "</p>"; 
	}
	echo "</div>";
} 
?>