<?php
//Parse the content for the first occurrence of video url
$video = rad_extract_video_info(get_post_meta(get_the_ID(), "video-id", true ));

if($video != null)
{
    $w = 500; $h = 280;
    rad_get_video_meta($video);
    if(array_key_exists("width", $video))
    {
        $w = $video["width"];
        $h = $video["height"];
    }

    if($video["type"] == "youtube")
        $src = "//www.youtube.com/embed/" . $video["id"];
    else
        $src = "//player.vimeo.com/video/" . $video["id"] . "?color=ff4c2f";
    ?>
    <div class="post-media video-frame">
    <iframe src="<?php echo esc_url($src); ?>" width="<?php echo esc_attr($w); ?>" height="<?php echo esc_attr($h); ?>" allowFullScreen></iframe>
    </div>
<?php
}
?>
<div class="post-content">
<?php
get_template_part( "templates/core/post/post", "meta" ); 
get_template_part( "templates/core/post/post", "excerpt" );
?>
</div>