<?php
$quote_content  = rad_get_meta( "quote_content", true );
$quote_author   = rad_get_meta( "quote_author", true );
$quote_color    = rad_get_meta( "quote_color", true );
$quote_bg_color = rad_get_meta( "quote_bg_color", true );
$quote_bg_image = wp_get_attachment_url( get_post_thumbnail_id());

$style = "";
if ( $quote_bg_image != "" && $quote_bg_color != "") {
    $style .= "background: " . esc_attr($quote_bg_color) ." url(". esc_url($quote_bg_image) . ");";
}
elseif ( $quote_bg_image != "") {
    $style .= "background: url(". esc_url($quote_bg_image) . ");";
}

if ( $quote_bg_color != "") {
    $style .= "background-color: " . esc_attr($quote_bg_color) . ";";
}

if ( $quote_color != "" ) {
    $style .= "color:". esc_attr($quote_color) . ";";
}

?>
<div class="post-media" style="<?php echo esc_attr($style); ?>">
    <a title="<?php echo esc_attr(get_the_title()); ?>" href="<?php the_permalink(); ?>">
    <?php
    if ( !empty( $quote_content )) { ?>
        <blockquote>
            <h3><?php echo esc_html($quote_content); ?></h3>
        <?php if ( !empty( $quote_author )) { ?>
            <cite class="quote_author"><?php echo esc_html($quote_author); ?></cite>
        <?php }?>
        </blockquote>
    <?php
    }
    else {
        echo get_the_content();
    } ?>
    </a>
</div>