<?php
$slider_type = rad_get_meta("slider-type");
$rad_slider_cat = rad_get_meta("builtin-slider-cat");
$rad_slider_type = rad_get_meta("slide-mode");
$rad_slider_pagination_type = rad_get_meta("slider-pagination-type");
$rad_slider_pagination_align = rad_get_meta("slider-pagination-align");
$rad_slider_pagination_style = rad_get_meta("slider-pagination-style");
$rev_slider = rad_get_meta("rev-slider");
$slider_with = rad_get_meta("slider-width");

if ( $slider_type == "none" || $slider_type == "") {
    return;
}

$slides = array();
if ( $slider_type == "builtin-slider" ) {
    $slides = get_posts(
        array(
          "post_type" => "slider",
          "numberposts" => -1,
          "tax_query" => array(
            array(
              "taxonomy" => "slider_cats",
              "field" => "slug",
              "terms" =>  $rad_slider_cat,
            )
          )
        )
    );

    if(empty($slides)) {
        return;
    }
}

$classes = array($slider_with, $slider_type, $rad_slider_type, $rad_slider_pagination_type . "-pagination", $rad_slider_pagination_align, $rad_slider_pagination_style);

?>
<div id="slider" class="<?php echo esc_attr(implode(" ",array_filter($classes))); ?>">
    <?php
    if ( $slider_type == "builtin-slider") {
        if($slider_with == "boxed") {
            echo "<div class=\"container\">";
        }
        ?>
        <div class="swiper-container unselectable">
            <div class="swiper-wrapper">
            <?php
            foreach ($slides as $slide) {
                $slide_id   = $slide->ID;
                $img = rad_get_image_url(rad_get_meta( "background-image",true,$slide_id ),"full");
                $slider_style = rad_get_meta( "slider-style" ,true, $slide_id);
                ?>
                <div class="swiper-slide unselectable">
                    <div class="sld-img" style="background:url(<?php echo esc_url($img);?>)"></div>  
                    <div class="sld-text <?php echo esc_attr($slider_style); ?>">
                        <?php
                        $title      = nl2br(rad_get_meta( "title-text",true, $slide_id ));
                        $titles     = preg_split("/<br[^>]*>/i", $title);
                        $title      = "";
                        foreach ($titles as $k => $t) {
                            $title .= "<span><span>". $t ."</span></span>";
                        }
                        $t_font     = rad_get_meta( "title-font",true, $slide_id );
                        $t_color    = rad_get_meta( "title-color",true, $slide_id );
                        $t_size     = rad_get_meta( "title-size",true, $slide_id );

                        $subtitle1  = rad_get_meta( "subtitle1-text",true, $slide_id );
                        $s1_font    = rad_get_meta( "subtitle1-font",true, $slide_id );
                        $s1_color   = rad_get_meta( "subtitle1-color",true, $slide_id );
                        $s1_size    = rad_get_meta( "subtitle1-size",true, $slide_id );

                        $subtitle2  = rad_get_meta( "subtitle2-text",true, $slide_id );
                        $s2_font    = rad_get_meta( "subtitle2-font",true, $slide_id );
                        $s2_color   = rad_get_meta( "subtitle2-color",true, $slide_id );
                        $s2_size    = rad_get_meta( "subtitle2-size",true, $slide_id );

                        $title_style      = rad_get_styles($t_font,$t_color,$t_size);
                        $subtitle1_style  = rad_get_styles($s1_font,$s1_color,$s1_size);
                        $subtitle2_style  = rad_get_styles($s2_font,$s2_color,$s2_size);

                        $url               = rad_get_meta( "button-url",true, $slide_id );
                        $text              = rad_get_meta( "button-text",true, $slide_id );
                        $bt_color          = rad_get_meta( "button-text-color",true, $slide_id );
                        $bt_hover_color    = rad_get_meta( "button-text-hover-color",true, $slide_id );
                        $bt_bg_color       = rad_get_meta( "button-background-color",true, $slide_id );
                        $bt_bg_hover_color = rad_get_meta( "button-background-hover-color",true,$slide_id);


                        $button_style  = rad_get_styles("",$bt_color,"", $bt_bg_color );
                        $button_hover_style  = rad_get_styles("",$bt_hover_color,"", $bt_bg_hover_color );

                        if($subtitle1 != "")
                        {
                            echo "<span class=\"text-mask\">";
                        }
                        echo rad_make_container("span", $subtitle1,"", "subtitle1",$subtitle1_style);
                        if($subtitle1 != "")
                        {
                            echo "</span>";
                        }

                        echo rad_make_title("h2", $title, "title",$title_style);

                        if($subtitle2 != "")
                        {
                            echo "<span class=\"text-mask\">";
                        }
                        echo rad_make_container("span", $subtitle2,"", "subtitle2",$subtitle2_style);
                        if($subtitle2 != "")
                        {
                            echo "</span>";
                        }

                        echo "<a class=\"rad-slider-button\" href=\"" . esc_url($url) ."\">";
                        echo "<span class=\"rad-slider-text\" style=\"". esc_attr($button_style)."\">". esc_html($text) . "</span>";
                        echo "<span class=\"rad-slider-text-hover\" style=\"". esc_attr($button_hover_style)."\">". esc_html($text) . "</span>";
                        echo "</a>";
                        ?>
                    </div>          
                </div>
            <?php } ?>
            </div>
            <div class="swiper-pagination"></div>
            <div class="rad-slider-prev unselectable"></div>
            <div class="rad-slider-next unselectable"></div>
        </div>
        <?php
        if($slider_with == "boxed") {
            echo "</div>";
        }
    }
    else if ( $slider_type == "rev-slider" && class_exists("RevSliderFront") && $rev_slider != "no-slider"){
        if($slider_with == "boxed") {
            echo "<div class=\"container\">" .do_shortcode("[rev_slider ". $rev_slider ."]") ."</div>";
        }
        else {
            echo do_shortcode("[rev_slider ". $rev_slider ."]");
        }
    }
    ?>
</div>