<?php
$class = $style = "";
$responsive = rad_get_option("popup-nl-responsive");
$bg = rad_get_option("popup-nl-bg");
$img = rad_get_option("popup-nl-img");
$title = rad_get_option("popup-nl-title");
$subtitle = rad_get_option("popup-nl-subtitle");
$text = rad_get_option("popup-nl-text");
$newsletter = rad_get_option("popup-nl-shortcode");

if ($responsive == "0") {
    $class = "hidden-phone";
}

if($img != "")
{
    $img   = rad_get_image_url($img, "full");
    if($img != "")
    {
        $class = "side-img";
        $img   = "<span class=\"img\" style=\"background:url(" . esc_url($img) .");\"></span>";
    }
}

if($bg != "")
{
    $bg    = rad_get_image_url($bg, "full");
    if($bg != "")
    {
        $style = "background:url(". esc_url($bg) .");";
    }
}
?>
<div id="rad-popup-newsletter" class="<?php echo esc_attr($class) ?>" style="<?php echo esc_attr($style); ?>">
	<?php echo wp_kses($img, array("span" => array("class" => array(),"style"=> array()))); ?>
	<div id="rad-popup-content">
		<h3><?php echo esc_html($title); ?></h3>
		<span class="subtitle"><?php echo esc_html($subtitle); ?></span>
        <p><?php echo esc_html($text); ?></p>
		<div class="rad-newsletter"><?php echo do_shortcode($newsletter); ?></div>
	</div>
</div>