<?php

if (!function_exists("rad_the_posts_navigation")) {
    function rad_the_posts_navigation()
    {
        the_posts_pagination(
            array(
                "mid_size"  => 4,
                "prev_text" => "",
                "next_text" => "",
            )
        );
    }
}

/*---------------------------------
Comments
------------------------------------*/
//Comment styling
function rad_theme_comment($comment, $args, $depth)
{

    $isByAuthor = false;

    if ($comment->comment_author_email == get_the_author_meta("email")) {
        $isByAuthor = true;
    }

    $GLOBALS["comment"] = $comment;?>

    <li>
        <div id="comment-<?php comment_ID()?>" <?php comment_class("clearfix");?> data-id="<?php comment_ID();?>">
            <div class="comment-image">
                <?php echo get_avatar($comment, $size = "64"); ?>
            </div>
            <div class="comment-content">
                <div class="comment-meta">
                    <?php echo "<cite>" . get_comment_author_link() . "</cite>"; ?>
                    <?php if ($isByAuthor) {?><span class="author-tag"><?php esc_html_e("Author", "aventa")?></span><?php }?>
                    <a class="comment-date" href="<?php echo htmlspecialchars(get_comment_link($comment->comment_ID)) ?>"><?php printf(esc_html__('%1$s at %2$s', 'aventa'), get_comment_date("M j, Y,    "), get_comment_time("G:i"));?></a>
                    <?php edit_comment_link(esc_html__("Edit", "aventa"), "  ", "");?>
                </div>
                <div class="comment-text">
                    <?php
                    comment_text();
                    comment_reply_link(array_merge($args, array("depth" => $depth, "max_depth" => $args["max_depth"])));
                    ?>
                </div>
            </div>
        </div>

<?php
}

if (!function_exists("rad_get_languages")) {
    function rad_get_languages()
    {
        $langLink1 = rad_get_option("topbar-language-link-1");
        $lang1     = rad_get_option("topbar-language-1");
        $langLink2 = rad_get_option("topbar-language-link-2");
        $lang2     = rad_get_option("topbar-language-2");
        $langLink3 = rad_get_option("topbar-language-link-3");
        $lang3     = rad_get_option("topbar-language-3");

        if ($langLink1 || $langLink2 || $langLink3) {
            $output = "<div class=\"topbar_lang_flag\">
                        <div class=\"lang-sel\"><a href=\"" . esc_url($langLink1) . "\">" . $lang1 . "</a>";
            $output .= "<ul class=\"lang_link\">";
            if ($langLink1) {
                $output .= "<li class=\"selected language1\"><a href=\"" . esc_url($langLink1) . "\">" . $lang1 . "</a></li>";
            }
            if ($langLink2) {
                $output .= "<li class=\"language2\"><a href=\"" . esc_url($langLink2) . "\">" . $lang2 . "</a></li>";
            }
            if ($langLink3) {
                $output .= "<li class=\"language3\"><a href=\"" . esc_url($langLink3) . "\">" . $lang3 . "</a></li>";
            }
            $output .= "</ul>";
            $output .= "</div></div>";
            return $output;
        }
    }
}

if (!function_exists("rad_is_unknown_page")) {
    function rad_is_unknown_page()
    {
        if (is_single() || is_404() || is_archive() || is_search() || is_home() || is_page() || (rad_is_wc_active() && is_woocommerce())) {
            return false;
        }

        return true;

    }
}

/*-----------------------------------------------------------------*/
// Login/rgister
/*-----------------------------------------------------------------*/
if (!function_exists("rad_load_account_page")) {
    function rad_load_account_page()
    {
        if (!rad_is_wc_active()) {
            return;
        }

        ?>
        <div id="rad-login">
            <?php echo woocommerce_login_form(); ?>
        </div>
        <?php
    }
}

/*-----------------------------------------------------------------*/
// Get post format
/*-----------------------------------------------------------------*/
if (!function_exists("rad_get_post_formats_list")) {
    function rad_get_post_formats_list()
    {
        return array("gallery", "video", "audio", "link", "quote");
    }
}

/*-----------------------------------------------------------------*/
// Get post format
/*-----------------------------------------------------------------*/
if (!function_exists("rad_get_post_format")) {
    function rad_get_post_format($pid)
    {
        $format = "";
        if ( rad_is_elementor_active() && Elementor\Plugin::instance()->db->is_built_with_elementor( $pid ) ){
            // Get the page settings manager
            $post_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

            // Get the settings model for current post
            $post_settings_model = $post_settings_manager->get_model( $pid );
            
            // Retrieve the color we added before
            $format = $post_settings_model->get_settings( "aventa_post_format" );
        }
        else
        {
            $format = get_post_format($pid);
        }

        if ($format == false || $format == "" || !in_array($format, rad_get_post_formats_list())) {
            $format = "standard";
        }
        
        return $format;
    }
}

/*-----------------------------------------------------------------*/
// Check status of header/space/no-space
/*-----------------------------------------------------------------*/
if (!function_exists("rad_header_status")) {
    function rad_header_status()
    {

        if (rad_is_wc_active()) {

            if (is_product_category()) {
                $cat_header_mode = rad_get_option("wc-header-category");
                if ($cat_header_mode != "disable") {
                    return "header";
                } else {
                    return "top-space";
                }
            } elseif (is_product()) {
                $gallery_style = rad_get_option("product-gallery-style");

                if ($gallery_style == "fitgrid") {
                    return "no-space";
                } else {
                    return "top-space";
                }
            }
        }

        $header_mode = rad_get_option("header-mode");

        if (is_page() || is_home() || (function_exists("is_shop") && is_shop())) {
            if (rad_get_meta("page-header-custom") == "custom") {
                $header_mode = rad_get_meta("page-header-mode"); // use page settings
            }

            if ($header_mode == "1") {
                return "header";
            } elseif ($header_mode == "2") {
                return "top-space";
            } elseif ($header_mode == "3") {
                return "no-space";
            } else // when there is no option set for this page
            {
                return "top-space";
            }

        } elseif (is_single()) // single page
        {
            if (is_singular("post")) {
                return "top-space";
            }

            return "no-space";
        } else // 404/archive/search/other unknown pages
        {
            return "top-space";
        }
    }
}
