<?php

if (!rad_is_wc_active()) {
    return;
}

/******************************************************
 * General
 *******************************************************/
add_action("init", "rad_yith_remove_notices");

add_action("init", "rad_size_chart_position");

add_action("wp_footer", "rad_show_wc_error_messages");

add_filter("woocommerce_template_path", "rad_woocommerce_template_path");

add_filter("body_class", "rad_wc_body_classes", 1, 1);

add_filter("loop_shop_columns", "rad_custom_loop_columns", 100);

add_filter("loop_shop_per_page", "rad_loop_shop_per_page", 20, 1);

add_filter("woocommerce_pagination_args", "rad_wc_pagination", 10, 1);

add_filter("woocommerce_product_variation_title_include_attributes", "rad_atts_in_product_name");

add_filter("woocommerce_show_page_title", "rad_woo_hide_page_title");

add_filter("woocommerce_add_to_cart_fragments", "rad_woocommerce_header_add_to_cart_fragment");

add_filter("woocommerce_format_content", "rad_remove_ptags_around_shop_page_content");

add_filter("woocommerce_redirect_single_search_result", "rad_redirect_single_search_result");

add_filter("woocommerce_post_class", "rad_product_scatter_layout_class");

add_action("wp_ajax_load_quick_view", "rad_load_quick_view");
add_action("wp_ajax_nopriv_load_quick_view", "rad_load_quick_view");
add_action("wc_ajax_load_quick_view", "rad_load_quick_view");

// Remove item from card
add_action("wp_ajax_cart_remove_item", "rad_remove_item");
add_action("wp_ajax_nopriv_cart_remove_item", "rad_remove_item");
add_action("wc_ajax_cart_remove_item", "rad_remove_item");

// Get back removed item to cart
add_action("wp_ajax_undo_removed_item", "rad_undo_removed_item");
add_action("wp_ajax_nopriv_undo_removed_item", "rad_undo_removed_item");

add_action("wp", "rad_ajax_add_to_cart_redirect_template", 1000);

add_action("dokan_sidebar_store_after", "rad_dokan_widget_sidebar_end", 10);

add_action("rad_woocommerce_before_account_navigation", "rad_myaccount_customer_avatar");

add_action("init", "rad_get_products_by_sku");

add_action("woocommerce_login_form_end", "rad_add_register_link", 40);

add_filter("woocommerce_catalog_orderby", "rad_change_ordering_labels");

// Quicview
if (function_exists("rad_social_share")) {
    add_action("quick_view_product_summary", "rad_social_share", 32);
}

add_action("wp_footer", "rad_quick_view_cursor");

// Wishlist
add_action("wp_ajax_get_wishlist_quantity", "rad_get_wishlist_quantity");
add_action("wp_ajax_nopriv_get_wishlist_quantity", "rad_get_wishlist_quantity");
add_action("wc_ajax_get_wishlist_quantity", "rad_get_wishlist_quantity");

/******************************************************
 * Shop page
 *******************************************************/
add_action("woocommerce_before_shop_loop", "rad_woocommerce_ajax_wrapper_start", 45);

add_action("woocommerce_after_shop_loop", "rad_woocommerce_ajax_wrapper_end", 10);

add_action("woocommerce_before_shop_loop", "rad_woocommerce_container", 5);
add_action("woocommerce_before_shop_loop", "rad_woocommerce_top_container_close", 41);
add_action("woocommerce_after_shop_loop", "rad_woocommerce_container_close", 40);

add_action("rad_before_header_close", "rad_woocommerce_filter", 38);

add_action("woocommerce_before_shop_loop", "rad_woocommerce_filter_button", 40);

if (rad_get_option("shop-ordering") != 1) {

    remove_action("woocommerce_before_shop_loop", "woocommerce_catalog_ordering", 30);
}

remove_action("woocommerce_before_shop_loop", "woocommerce_result_count", 20);

if (rad_get_option("shop-result-count") == 1) {

    add_action("woocommerce_before_shop_loop", "woocommerce_result_count", 40);
}

add_action("woocommerce_before_shop_loop", "rad_woocommerce_column_switcher", 39);

add_action("woocommerce_before_shop_loop", "rad_shop_categories", 40);

remove_action("woocommerce_archive_description", "woocommerce_taxonomy_archive_description", 10);

/*******************************************************/
/* Product structure
/*******************************************************/

add_action("woocommerce_before_shop_loop_item", "rad_product_loop_productwrap_open", 4);
add_action("woocommerce_before_shop_loop_item", "rad_product_loop_add_to_cart_btn_wrap_open", 5);

remove_action("woocommerce_before_shop_loop_item", "woocommerce_template_loop_product_link_open", 10);
remove_action("woocommerce_after_shop_loop_item", "woocommerce_template_loop_product_link_close", 5);

add_action("woocommerce_before_shop_loop_item_title", "woocommerce_template_loop_product_link_open", 5);
add_action("woocommerce_before_shop_loop_item_title", "woocommerce_template_loop_product_link_close", 6);

remove_action("woocommerce_after_shop_loop_item", "woocommerce_template_loop_add_to_cart", 10);
remove_action("woocommerce_shop_loop_item_title", "woocommerce_template_loop_product_title", 10);

add_action("rad_woocommerce_shop_loop_hover_buttons", "rad_woocommerce_template_loop_add_to_cart", 10);
add_filter("woocommerce_loop_add_to_cart_link", "rad_woocommerce_loop_add_to_cart_icon",10,2);

add_action("rad_woocommerce_shop_loop_hover_buttons", "rad_add_quick_view_button", 15);
add_action("rad_woocommerce_shop_loop_buttons", "rad_add_quick_view_button", 15);

add_action("rad_woocommerce_shop_loop_hover_buttons", "rad_shop_page_wishlist_button", 15);
add_action("rad_woocommerce_shop_loop_buttons", "rad_shop_page_wishlist_button", 11);

remove_action("woocommerce_after_shop_loop_item_title", "woocommerce_template_loop_rating", 5);
add_action("rad_woocommerce_shop_loop_link", "rad_woocommerce_template_loop_rating", 5);

remove_action("woocommerce_after_shop_loop_item_title", "woocommerce_template_loop_price", 10);
add_action("woocommerce_after_shop_loop_item_title", "rad_woocommerce_template_loop_price", 10);

add_action("woocommerce_after_shop_loop_item_title", "rad_product_loop_wrap_after_thumbnail_close", 90);
add_action("woocommerce_after_shop_loop_item_title", "rad_product_loop_productwrap_close", 100);

add_action("woocommerce_before_subcategory", "rad_subcategory_wrapper", 5);
add_action("woocommerce_before_subcategory", "rad_template_loop_category_overlay", 15);
add_action("woocommerce_after_subcategory", "rad_subcategory_wrapper_closing", 15);
remove_action("woocommerce_before_subcategory_title", "woocommerce_subcategory_thumbnail", 10);
add_action("woocommerce_before_subcategory_title", "rad_woocommerce_subcategory_thumbnail", 10);

remove_action("woocommerce_shop_loop_subcategory_title", "woocommerce_template_loop_category_title", 10);
add_action("woocommerce_shop_loop_subcategory_title", "rad_template_loop_category_title", 10);

add_action("woocommerce_before_subcategory_title", "rad_subcategory_thumbnail_open", 5);
add_action("woocommerce_before_subcategory_title", "rad_subcategory_thumbnail_close", 15);

add_filter("woocommerce_sale_flash", "rad_percentage_sale", 10, 3);

add_filter("woocommerce_loop_add_to_cart_link", "rad_woocommerce_loop_add_to_cart_link", 100, 2);

add_action("woocommerce_before_shop_loop_item_title", "rad_product_loop_rad_product_buttons", 10);

remove_action("woocommerce_before_shop_loop_item_title", "woocommerce_template_loop_product_thumbnail", 10);
add_action("woocommerce_before_shop_loop_item_title", "rad_template_loop_product_thumbnail", 6);
add_action("woocommerce_before_shop_loop_item_title", "rad_product_loop_rad_hover_image", 6);

if (rad_get_option("product-badges") == 1) {
    add_action("woocommerce_before_shop_loop_item_title", "rad_product_loop_badges_open", 6);
    add_action("woocommerce_before_shop_loop_item_title", "rad_product_loop_check_is_in_stock", 7);
    remove_action("woocommerce_before_shop_loop_item_title", "woocommerce_show_product_loop_sale_flash", 10);
    add_action("woocommerce_before_shop_loop_item_title", "woocommerce_show_product_loop_sale_flash", 8);
    add_action("woocommerce_before_shop_loop_item_title", "rad_product_loop_badges_close", 9);
} else {
    remove_action("woocommerce_before_shop_loop_item_title", "woocommerce_show_product_loop_sale_flash", 10);
}

remove_action("woocommerce_before_main_content", "woocommerce_breadcrumb", 20);


/******************************************************
 * Single product
 *******************************************************/
add_filter("yikes_woocommerce_custom_repeatable_product_tabs_heading", "rad_remove_yikes_custom_tab_heading");

add_filter("woocommerce_dropdown_variation_attribute_options_html", "rad_new_attribute_typesـoutput", 10, 2);

add_action("woocommerce_before_single_product_summary", "rad_single_product_container", 10);
add_action("woocommerce_after_single_product_summary", "rad_single_product_container_close", 10);

remove_action("woocommerce_before_single_product_summary", "woocommerce_show_product_sale_flash", 10);
add_action("woocommerce_before_single_product_summary", "woocommerce_show_product_sale_flash", 23);

if (function_exists("rad_social_share")) {
    add_action("woocommerce_before_single_product_summary", "rad_social_share", 5);
}

add_action("woocommerce_after_single_product_summary", "rad_single_product_nav", 20);

add_action("woocommerce_before_quantity_input_field", "rad_wc_quantity_input", 10);

remove_action("woocommerce_review_before_comment_meta", "woocommerce_review_display_rating", 10);
add_action("woocommerce_review_meta", "woocommerce_review_display_rating", 10);

add_action("wp_footer", "product_gallery_lightbox", 100);

add_action("woocommerce_product_thumbnails", "rad_woocommerce_product_video", 10);

$product_tab_position = rad_get_option("product-tab-position");

if ($product_tab_position == "before-add-to-cart") {
    remove_action("woocommerce_after_single_product_summary", "woocommerce_output_product_data_tabs", 10);
    add_action("woocommerce_single_product_summary", "rad_woocommerce_output_product_data_tabs", 20);
    add_filter("woocommerce_product_tabs", "rad_wc_unset_review_tabs", 200);
    add_action("woocommerce_after_single_product_summary", "rad_woocommerce_output_product_review_tabs", 10);
} elseif ($product_tab_position == "after-add-to-cart") {
    remove_action("woocommerce_after_single_product_summary", "woocommerce_output_product_data_tabs", 10);
    add_action("woocommerce_single_product_summary", "rad_woocommerce_output_product_data_tabs", 30);
    add_filter("woocommerce_product_tabs", "rad_wc_unset_review_tabs", 200);
    add_action("woocommerce_after_single_product_summary", "rad_woocommerce_output_product_review_tabs", 10);
} else {
    remove_action("woocommerce_after_single_product_summary", "woocommerce_output_product_data_tabs", 10);
    add_action("woocommerce_after_single_product_summary", "rad_woocommerce_output_product_data_tabs", 15);
}

$product_breadcrumb = rad_get_option("product_breadcrumb");
$gallery_style      = rad_get_option("product-gallery-style");

if ($product_breadcrumb == "1") {
    if ($gallery_style == "fitgrid") {
        add_action("woocommerce_single_product_summary", "rad_single_product_breadcrumb", 0);
    } else {
        add_action("woocommerce_before_single_product_summary", "rad_single_product_breadcrumb", 11);
    }
}

/******************************************************
 * General : Change the Woocommerce template path in the theme
 *******************************************************/
function rad_woocommerce_template_path()
{
    return "templates/woocommerce/";
}


/******************************************************
 * Prevent wishlist from clearing WooCommerce notices
 *******************************************************/
if (!function_exists("rad_yith_remove_notices")) {

    function rad_yith_remove_notices()
    {
        if ( class_exists( "YITH_WCWL_Frontend" ) ) {
            remove_action( "yith_wcwl_before_wishlist_title", array( YITH_WCWL_Frontend(), "print_notices" ) );
        }
    }
}



/******************************************************
 * Add size chart button in proper position
 *******************************************************/
if ( !function_exists( "rad_size_chart_position" ) ) {
    function rad_size_chart_position() {
        if ( class_exists( "YITH_WCPSC_Frontend" ) ) {
            $button_position = get_option( 'yith-wcpsc-popup-button-position', 'after_summary' );
            $bp_array        = array( 'action' => 'woocommerce_after_single_product_summary', 'priority' => 9 );
            switch ( $button_position ) {
                case 'before_summary':
                    $bp_array = array( 'action' => 'woocommerce_before_single_product_summary', 'priority' => 25 );
                    break;
                case 'before_description':
                    $bp_array = array( 'action' => 'woocommerce_single_product_summary', 'priority' => 15 );
                    break;
                case 'after_description':
                    $bp_array = array( 'action' => 'woocommerce_single_product_summary', 'priority' => 25 );
                    break;
                case 'after_add_to_cart':
                    $bp_array = array( 'action' => 'woocommerce_single_product_summary', 'priority' => 35 );
                    break;
                case 'after_summary':
                    $bp_array = array( 'action' => 'woocommerce_after_single_product_summary', 'priority' => 9 );
                    break;
            }
            add_action( $bp_array['action'], "rad_size_chart_button", $bp_array['priority'] );
        }
    }
}

/******************************************************
 * Add size chart button
 *******************************************************/
if (!function_exists("rad_size_chart_button")) {
    function rad_size_chart_button() 
    {
        if ( class_exists( "YITH_WCPSC_Frontend" ) ) {
            global $post;

            $charts = YITH_WCPSC_Frontend()->get_charts_from_product_id( $post->ID );
    
            if ( count( $charts ) > 0 ) {
                foreach ( $charts as $chart_id ) {
                ?>
                    <span class="size-chart-button-container">
                        <a class="size-chart-button underline-style init-show" data-chart-id="<?php echo esc_attr( $chart_id ) ?>" href="#">
                            <?php echo esc_html( get_the_title( $chart_id ) ) ?>
                        </a>
                    </span>
                <?php
                }
            }
        }
    }
}

/******************************************************
 * General : Fetch Add To cart fragments in Ajax request
 *******************************************************/
if (!function_exists("rad_ajax_add_to_cart_redirect_template")) {
    function rad_ajax_add_to_cart_redirect_template()
    {
        if (isset($_REQUEST["rad-ajax-add-to-cart"])) {
            wc_get_template("ajax-add-to-cart-fragments.php");
            exit;
        }
    }
}

/******************************************************
 * General : Wishlist quantity
 *******************************************************/
if (!function_exists("rad_get_wishlist_quantity")) {
    function rad_get_wishlist_quantity()
    {
        global $yith_wcwl;

        // check to see if the submitted nonce matches with the generated nonce we created earlier
        check_ajax_referer("ajax-nonce", "security");

        $data = array(
            "wishlist_count_products" => yith_wcwl_count_products(),
        );
        wp_send_json($data);
    }
}

/******************************************************
 * General : Catalog mode
 *******************************************************/
if (!function_exists("rad_catalog_mode_pages_redirect")) {
    function rad_catalog_mode_pages_redirect()
    {

        if (!class_exists("Woocommerce")) {
            return;
        }

        $cart     = is_page(wc_get_page_id("cart"));
        $checkout = is_page(wc_get_page_id("checkout"));

        wp_reset_query();

        if ($cart || $checkout) {

            wp_redirect(home_url());
            exit;
        }

    }
}

if (!function_exists("rad_catalog_mode")) {
    function rad_catalog_mode()
    {
        $catalog_mode       = rad_get_option("catalog_mode");
        $catalog_mode_price = rad_get_option("catalog_mode_price");
        if ($catalog_mode != 0) {

            //Remove add to cart button
            remove_action("rad_woocommerce_shop_loop_buttons", "woocommerce_template_loop_add_to_cart", 10);
            remove_action("quick_view_product_summary", "woocommerce_template_single_add_to_cart", 25);
            remove_action("woocommerce_simple_add_to_cart", "woocommerce_simple_add_to_cart", 30);
            remove_action("woocommerce_grouped_add_to_cart", "woocommerce_grouped_add_to_cart", 30);
            remove_action("woocommerce_external_add_to_cart", "woocommerce_external_add_to_cart", 30);
            remove_action("woocommerce_single_variation", "woocommerce_single_variation_add_to_cart_button", 20);
            remove_action("woocommerce_single_variation", "woocommerce_single_variation", 10);

            //Disable any add to cart link(shortcodes, shop ...)
            add_filter("woocommerce_loop_add_to_cart_link", "__return_empty_string", 10);

            //Disable add to cart functionality
            $priority = has_action("wp_loaded", array("WC_Form_Handler", "add_to_cart_action"));
            remove_action("wp_loaded", array("WC_Form_Handler", "add_to_cart_action"), $priority);

            //Redirect "cart" and "checkout" page
            add_action("wp", "rad_catalog_mode_pages_redirect");

            // hiden price in catalog mode
            if ($catalog_mode_price != 0) {
                add_filter("woocommerce_variable_sale_price_html", "rad_wc_remove_prices", 10, 2);
                add_filter("woocommerce_variable_price_html", "rad_wc_remove_prices", 10, 2);
                add_filter("woocommerce_get_price_html", "rad_wc_remove_prices", 10, 2);

                function rad_wc_remove_prices($price, $product)
                {
                    $price = "";
                    return $price;
                }
                //Remove price from shop page, product details and quick view
                remove_action("woocommerce_single_product_summary", "woocommerce_template_single_price", 10);
                remove_action("quick_view_product_summary", "woocommerce_template_single_price", 15);
                remove_action("woocommerce_after_shop_loop_item_title", "woocommerce_template_loop_price", 10);
            }
        }

    }
}

rad_catalog_mode();

/******************************************************
 * General : percentage Sale
 *******************************************************/

if (!function_exists("rad_percentage_sale")) {

    function rad_percentage_sale($badge, $post, $product)
    {

        $percentage_sale = rad_get_option("percentage_sale");

        if ($percentage_sale == "0") {
            return $badge;
        }

        if (!$product->is_on_sale()) {
            return;
        }

        $maximumper = 0;

        if ($product->is_type("variable")) {
            $maximumper           = 0;
            $available_variations = $product->get_available_variations();

            for ($i = 0; $i < count($available_variations); ++$i) {
                $variation_id  = $available_variations[$i]["variation_id"];
                $variation     = new WC_Product_Variation($variation_id);
                $regular_price = $variation->get_regular_price();
                $sale_price    = $variation->get_sale_price();

                if ($regular_price == 0 || $regular_price == $sale_price || $sale_price == null) {
                    continue;
                }

                $savings = ceil((($regular_price - $sale_price) / $regular_price) * 100);
                if ($savings > $maximumper) {
                    $maximumper = $savings;
                }
            }
        } elseif ($product->is_type("simple") || $product->is_type("external")) {
            $sale_price    = $product->get_sale_price();
            $regular_price = $product->get_regular_price();

            if ($regular_price == 0) {
                return;
            }

            $savings    = ceil((($regular_price - $sale_price) / $regular_price) * 100);
            $maximumper = $savings;
        } elseif ($product->is_type("grouped")) {
            $product_id = $product->get_id();
            $childs_id  = $product->get_children();
            $maximumper = 0;
            for ($i = 0; $i < count($childs_id); ++$i) {
                $product_child_id = $childs_id[$i];
                $simple           = wc_get_product($product_child_id);

                if ($product->is_type("simple")) // Just handle the simple products as child of grouped product
                {
                    $regular_price = $product->get_regular_price();
                    $sale_price    = $product->get_sale_price();
                    $savings       = ceil((($regular_price - $sale_price) / $regular_price) * 100);

                    if ($regular_price == 0) {
                        continue;
                    }

                    if ($savings > $maximumper) {
                        $maximumper = $savings;
                    }
                }
            }
        }

        if ($maximumper == 0) {
            return;
        }

        $sale_flash = "<span class=\"onsale percentage-sale\">" . "-" . $maximumper . "%" . "</span>";
        return $sale_flash;
    }

}

/******************************************************
 * General : Avatar in my account page
 *******************************************************/

if (!function_exists("rad_myaccount_customer_avatar")) {
    function rad_myaccount_customer_avatar()
    {
        $current_user = wp_get_current_user();
        if ($current_user instanceof WP_User) {
            echo "<div class=\"myaccount_avatar\">" . get_avatar($current_user->user_email, 100) . "<h5>" . $current_user->display_name . "</h5></div>";
        }
    }
}

function rad_get_products_by_sku()
{
    global $getProductsBySku;
    $getProductsBySku = array();

    if (!isset($_GET["s"]) || (isset($_POST["action"]) && $_POST["action"] == "rad_ajax_search_action")) {
        return;
    }

    $s = trim(sanitize_text_field($_GET["s"]));

    if (!isset($_GET["cat"])) {
        $cat = "";
    } else {
        $cat = trim(sanitize_text_field($_GET["cat"]));
    }

    $args_sku = array(
        "post_type"        => "product",
        "posts_per_page"   => 20,
        "product_cat"      => $cat,
        "meta_query"       => array(
            array(
                "key"     => "_sku",
                "value"   => $s,
                "compare" => "like",
            ),
        ),
        "suppress_filters" => false,
    );
    $getProductsBySku = get_posts($args_sku);

}

/******************************************************
 * Shop page : Filter
 *******************************************************/
if (!function_exists("rad_woocommerce_filter")) {
    function rad_woocommerce_filter()
    {
        if (!rad_is_wc_active()) {
            return;
        }

        $show_filter = rad_get_option("shop-filter");

        if (!$show_filter && !is_active_sidebar("woocommerce-sidebar")) {
            return;
        }

        echo "<div class=\"toggle-aside shop-filter sidebar widget-area bg\">";
        echo "<span class=\"wc-loading hide\"></span>";
        echo "<div class=\"filters\">";

        //Filters in filter sidebar
        if (is_active_sidebar("woocommerce-filter-sidebar1")) {
            dynamic_sidebar("woocommerce-filter-sidebar1");
        }

        if (is_active_sidebar("woocommerce-filter-sidebar2")) {
            dynamic_sidebar("woocommerce-filter-sidebar2");
        }

        if (is_active_sidebar("woocommerce-filter-sidebar3")) {
            dynamic_sidebar("woocommerce-filter-sidebar3");
        }

        if (is_active_sidebar("woocommerce-filter-sidebar4")) {
            dynamic_sidebar("woocommerce-filter-sidebar4");
        }

        echo "<div class=\"bottom-filters\">";
        echo "<div class=\"special-filter\">";
        $instance = array(
            "title" => "",
        );
        //show on sale filter
        if (rad_get_option("shop-filter-on-sale") && class_exists("Rad_WC_Widget_On_Sale_Filter")) {
            the_widget("Rad_WC_Widget_On_Sale_Filter", $instance);
        }

        //show in stock filter
        if (rad_get_option("shop-filter-in-stock") && class_exists("Rad_WC_Widget_In_Stock_Filter")) {
            the_widget("Rad_WC_Widget_In_Stock_Filter", $instance);
        }

        global $wp;
        $_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes();

        $filterreset = home_url($wp->request);
        $url         = strtok($filterreset, "?");

        // Price
        $min_price = isset($_GET["min_price"]) ? esc_attr($_GET["min_price"]) : 0;
        $max_price = isset($_GET["max_price"]) ? esc_attr($_GET["max_price"]) : 0;

        if (array_key_exists("availability", $_GET) || array_key_exists("status", $_GET) || $_chosen_attributes != null && count($_chosen_attributes) > 0 || $min_price > 0 || $max_price > 0) {
            echo "<a href=\"" . $url . "\" class=\"reset-filter\">" . esc_html__("Clear Filters", "aventa") . "</a>";
        }

        echo "</div>";

        echo "</div>";
        echo "</div>";
        echo "</div>";

    }
}

if (!function_exists("rad_woocommerce_filter_button")) {
    function rad_woocommerce_filter_button()
    {
        // Find the category + category parent, if applicable
        $term                         = get_queried_object();
        $parent_id                    = empty($term->term_id) ? 0 : $term->term_id;
        $display_type_shop_wc_setting = get_option("woocommerce_shop_page_display");
        $display_type_wc_setting      = get_option("woocommerce_category_archive_display");
        $display_type_cat_setting     = get_term_meta($parent_id, "display_type");
        $allowed_filter               = (class_exists("woocommerce") && (is_shop() && $display_type_shop_wc_setting == "subcategories") || (is_product_category() && $display_type_cat_setting == "subcategories" && $product_categories) || (is_product_category() && $display_type_wc_setting == "subcategories" && $display_type_cat_setting == "" && $product_categories)) ? false : true;

        $show_filter = rad_get_option("shop-filter");
        $show_stiky_filter = rad_get_option("shop-filter");

        if (!$allowed_filter) {
            return;
        }

        
        if ($show_stiky_filter) {
            $icon = rad_Icon_Manager::get_icon("sliders-v");
            echo "<span id=\"shop-sticky-filter\">" . $icon . "</span>";
        }


        if ($show_filter) {
            echo "<span id=\"shop-filter-toggle\">" . esc_html__("Filter", "aventa") . "</span>";
        } elseif (is_active_sidebar("woocommerce-sidebar")) {
            echo "<span id=\"shop-filter-toggle\" class=\"hidden-desktop\">" . esc_html__("Filter", "aventa") . "</span>";
        }
    }
}

/******************************************************
 * Shop page : Ordering label
 *******************************************************/
function rad_change_ordering_labels($orderby_options)
{
    if (isset($orderby_options["menu_order"])) {
        $orderby_options["menu_order"] = esc_html__("Order", "aventa");
    }

    return $orderby_options;
}

/******************************************************
 * Shop page : Column switcher
 *******************************************************/
function rad_woocommerce_column_switcher()
{
    $layout  = rad_get_option("shop-layout");
    $columns = (int) rad_get_option("shop-column");

    if ($layout == "sticky" || $layout == "scatter") {
        return;
    }

    $output = "";
    for ($i = 2; $i <= $columns; $i++) {
        if ($i == 2 && $columns == 2) {
            continue;
        }

        if ($columns == $i) {
            $output .= "<a href=\"#\" class=\"current\" data-column=\"" . $i . "\">" . $i . "</a>";
        } else {
            $output .= "<a href=\"#\" data-column=\"" . $i . "\">" . $i . "</a>";
        }
    }

    if ($output != "") {
        $output = "<span class=\"column-switcher hidden-phone\">" . esc_html__("View : ", "aventa") . $output . "</span>";

    }

    echo "" . $output; //sanitized
}

/******************************************************
 * Shop page : Categories
 *******************************************************/
function rad_shop_categories()
{

    $term               = get_queried_object();
    $parent_id          = empty($term->term_id) ? 0 : $term->term_id;
    $enabled_categories = rad_get_option("shop-filter-categories") == 1 ? true : false;
    $categories_style   = rad_get_option("shop-filter-categories-style");

    if ($enabled_categories) {
        echo "<div id=\"rad-shop-cats\" class=\"" . $categories_style . "\"><div class=\"cat-switch\">";
        echo "<span class=\"cat-label\">" . esc_html__("Categories", "aventa") . "</span>";
        echo rad_woocommerce_product_subcategories_simple($parent_id);
        echo "</div></div>";
    }
}

/******************************************************
 * Shop page : Product pagination label
 *******************************************************/
function rad_wc_pagination($settings)
{
    if (rad_get_option("products-pagination") == "load_more") {
        $settings["next_text"] = esc_html__("Load more", "aventa");
    }

    return $settings;
}

/******************************************************
 * Shop page : Product per page
 *******************************************************/
function rad_loop_shop_per_page($cols)
{
    return (rad_get_option("products-per-page") != "" ? rad_get_option("products-per-page") : 12);
}


/******************************************************
 * Product in shop loop : Wrapper around product item
 *******************************************************/
if (!function_exists("rad_product_loop_productwrap_open")) {
    function rad_product_loop_productwrap_open()
    {
        $quickview   = rad_get_option("shop-enable-quickview");
        $wishlist    = rad_get_option("product-wishlist");
        $hover_style = rad_get_option("product-style");

        $space = 0;
        if ($hover_style == "qv-hover" && $wishlist == "1") {
            $space = 1;
        }

        if ($hover_style == "general") {
            if ($wishlist == "1") {
                $space = 1;
            }

            if ($quickview == "1") {
                $space++;
            }
        }

        if ($hover_style == "creative" && $wishlist == "1") {
            $space = 1;
        }

        $classes = $hover_style;
        if ($space > 0) {
            $classes .= " sp-" . $space;
        }

        if ($hover_style == "simple-hover") {
            $classes .= " " . rad_get_option("product-hover-theme");
        }

        if (rad_get_option("shop-layout") == "scatter" && !is_product()) {
            echo "<div class=\"prlx-target\">";
        }

        echo "<div class=\"product-wrap " . esc_attr($classes) . "\">";
    }
}

/******************************************************
 * Scatter style - Add class to products in shop loop
 *******************************************************/
if (!function_exists("rad_product_scatter_layout_class")) {
    function rad_product_scatter_layout_class($classes)
    {
        if (rad_get_option("shop-layout") == "scatter" && !is_product()) {
            $classes[] = "parallax";
        }

        return $classes;
    }
}

/******************************************************
 * Product in shop loop  : Add a wrapper around add-to-cart link
 *******************************************************/

if (!function_exists("rad_woocommerce_loop_add_to_cart_link")) {
    function rad_woocommerce_loop_add_to_cart_link($link, $product)
    {

        //Add some class for compatibility with 3rd-party plugins such as wooZone
        $class = sprintf("class=\"button %s product_type_%s %s\"",
            $product->is_purchasable() && $product->is_in_stock() ? "add_to_cart_button" : "",
            esc_attr($product->get_type()),
            esc_attr($product->get_type() == "simple" && "yes" === get_option("woocommerce_enable_ajax_add_to_cart") ? "ajax_add_to_cart" : "")
        );

        $link = str_replace("class=\"button\"", $class, $link);
        $link = str_replace("class=\"ajax_add_to_cart button\"", $class, $link);

        return "<span class=\"product-button product_type_" . $product->get_type() . "\">" . $link . "</span>";
    }
}

/******************************************************
 * Product in shop loop : Product prices
 *******************************************************/
function rad_woocommerce_template_loop_price()
{
    $product_hover_style = rad_get_option("product-style");
    if ($product_hover_style == "bt-hover" || $product_hover_style == "simple-hover") {
        woocommerce_template_loop_price();
    }
}
/******************************************************
 * Product in shop loop : Add to cart button
 *******************************************************/
function rad_woocommerce_template_loop_add_to_cart()
{
    $hover_style = rad_get_option("product-style");
    if ($hover_style == "bt-hover" || $hover_style == "simple-hover") {
        woocommerce_template_loop_add_to_cart();
    }
}

function rad_woocommerce_loop_add_to_cart_icon($html,$product)
{
    $hover_style = rad_get_option("product-style");
    if ($hover_style == "bt-hover" || $hover_style == "simple-hover") {
        $icon = rad_Icon_Manager::get_icon("shopping-bag");

        if( $product->get_type() == "auction")
        {
            
            $icon = rad_Icon_Manager::get_icon("auction");
        }

        $html = str_replace("</a>", $icon . "</a>", $html);
    }
    return $html;
}

/******************************************************
 * Product in shop loop : Rating in products
 *******************************************************/
function rad_woocommerce_template_loop_rating()
{
    if (rad_get_option("shop-product-rating") == 1) {
        woocommerce_template_loop_rating();
    }
}

/******************************************************
 * Product in shop loop : Wrapper around product image
 *******************************************************/
if (!function_exists("rad_product_loop_add_to_cart_btn_wrap_open")) {
    function rad_product_loop_add_to_cart_btn_wrap_open()
    {
        echo "<div class=\"thumbnail-wrap lazy-load-hover-container\">";
    }
}

/******************************************************
 * Product in shop loop : Wrapper around badges
 *******************************************************/
if (!function_exists("rad_product_loop_badges_open")) {
    function rad_product_loop_badges_open()
    {
        global $product;
        if (!$product->is_in_stock() || $product->is_on_sale()) {
            echo "<span class=\"badges\">";
        }
    }
}

if (!function_exists("rad_product_loop_badges_close")) {
    function rad_product_loop_badges_close()
    {
        global $product;
        if (!$product->is_in_stock() || $product->is_on_sale()) {
            echo "</span>";
        }
    }
}

/******************************************************
 * Product in shop loop : Out of stock badge
 *******************************************************/
if (!function_exists("rad_product_loop_check_is_in_stock")) {
    function rad_product_loop_check_is_in_stock()
    {
        global $product;
        if (!$product->is_in_stock()) {
            echo "<span class=\"out-of-stock-badge\">" . esc_html__("Out of stock", "aventa") . "</span>";
        }
    }
}

/******************************************************
 * Product in shop loop : Add a second image as hover image
 *******************************************************/
if (!function_exists("rad_product_loop_rad_hover_image")) {
    function rad_product_loop_rad_hover_image()
    {
        $product_hover_style = rad_get_option("product-style");
        if ($product_hover_style == "simple-hover") {
            return;
        }

        global $product;
        $attachment_ids = $product->get_gallery_image_ids();
        //Rado codes
        if (rad_get_option("product-hover-image") == 1 && count($attachment_ids) > 0) {
            $first_gallery_img = reset($attachment_ids); //get the first image of gallery

            $img = rad_get_image($first_gallery_img, "", "", "woocommerce_thumbnail", "", "", "", true);

            if ($img != "") {
                printf("<div class=\"hover-image lazy-load lazy-load-hover\">%s</div>", $img);
            }
        }
    }
}

/******************************************************
 * Product in shop loop : Wrapper around buttons
 *******************************************************/

if (!function_exists("rad_product_loop_rad_product_buttons")) {
    function rad_product_loop_rad_product_buttons()
    {
        global $product;
        $product_style  = rad_get_option("product-style");
        $hover_theme    = rad_get_option("product-hover-theme");
        $quickview      = rad_get_option("shop-enable-quickview");

        if ($product_style == "bt-hover" || $product_style == "creative") {
            echo "<div class=\"product-buttons " . $hover_theme . "\">";

            do_action("rad_woocommerce_shop_loop_hover_buttons");

            echo "</div>";
        }

        if ($product_style == "qv-hover" && $quickview == "1") {
            echo "<div class=\"product-buttons " . $hover_theme . "\">";

            do_action("rad_woocommerce_shop_loop_hover_buttons");

            echo "</div>";
        }

        if ($product_style == "simple-hover") {
            echo "<div class=\"product-buttons\">";

            do_action("rad_woocommerce_shop_loop_hover_buttons");

            echo "</div>";
        }

        // <div class="thumbnail-wrap"> close
        echo "</div>";

        // <div class="product-info"> Open
        echo "<div class=\"product-info\">";

        if ($product_style != "bt-hover" && $product_style != "simple-hover") {
            echo "<div class=\"product-buttons\">";
        }

        // TODO - Add after product Btns
        do_action("rad_woocommerce_shop_loop_buttons");

        if ($product_style != "bt-hover" && $product_style != "simple-hover") {
            echo "</div>";
        }

        echo "<a href=\"" . get_the_permalink() . "\"><h3 class=\"woocommerce-loop-product__title\">" . get_the_title() . "</h3></a>";

        do_action("rad_woocommerce_shop_loop_link");

        if ($product_style != "bt-hover" && $product_style != "simple-hover") {
            echo "<div class=\"addtocart-price\">";

            if ($price_html = $product->get_price_html()) {
                echo "<span class=\"price\">" . $price_html . "</span>";

                $button = apply_filters("woocommerce_loop_add_to_cart_link",
                    sprintf('<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="%s product_type_%s %s">%s</a>',
                        esc_url($product->add_to_cart_url()),
                        esc_attr($product->get_id()),
                        esc_attr($product->get_sku()),
                        esc_attr(isset($quantity) ? $quantity : 1),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        esc_attr($product->get_type()),
                        esc_attr($product->get_type() == 'simple' && 'yes' === get_option('woocommerce_enable_ajax_add_to_cart') ? 'ajax_add_to_cart' : ''),
                        ($product->add_to_cart_text())
                    ),
                    $product);

                $button = apply_filters("rad_loop_toggle_addtocart_price_link", $button);
                echo "" . $button;
            } else {

                echo "<span class=\"price\"></span>";
                echo "<div class=\"no_price\">";

                $button = apply_filters("woocommerce_loop_add_to_cart_link",
                    sprintf('<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="%s product_type_%s %s">%s</a>',
                        esc_attr($product->get_type()),
                        esc_url($product->add_to_cart_url()),
                        esc_attr($product->get_id()),
                        esc_attr($product->get_sku()),
                        esc_attr(isset($quantity) ? $quantity : 1),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        esc_attr($product->get_type()),
                        esc_attr($product->get_type() == 'simple' && 'yes' === get_option('woocommerce_enable_ajax_add_to_cart') ? 'ajax_add_to_cart' : ''),
                        $product->add_to_cart_text()
                    ),
                    $product);

                $button = apply_filters("rad_loop_toggle_addtocart_price_link", $button);
                echo "" . $button;

                echo "</div>";
            }
            echo "</div>";
        }
    }
}

/******************************************************
 * Product in shop loop : Image wrapper open
 *******************************************************/

if (!function_exists("rad_template_loop_product_thumbnail")) {

    function rad_template_loop_product_thumbnail()
    {
        $img             = woocommerce_get_product_thumbnail("woocommerce_thumbnail");
        $container_class = "image lazy-load lazy-load-on-load";

        $img = str_replace("src=", "src=\"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==\" data-src=", $img);
        echo "<div class=\"" . esc_attr($container_class) . "\" style=\"padding-top:" . esc_attr(rad_get_height_percentage($img)) . "%;\">" . $img . "</div>";
    }
}

/******************************************************
 * Product in shop loop : Image wrapper close
 *******************************************************/
if (!function_exists("rad_product_loop_wrap_after_thumbnail_close")) {
    function rad_product_loop_wrap_after_thumbnail_close()
    {
        // <div class="product-info"> close
        echo "</div>";
    }
}

/******************************************************
 * ??????????????????????????????????????????????????
 *******************************************************/
if (!function_exists("rad_product_loop_productwrap_close")) {
    function rad_product_loop_productwrap_close()
    {
        if (rad_get_option("shop-layout") == "scatter" && !is_product()) {
            echo "</div>";
        }
        echo "</div>";

    }
}

/******************************************************
 * Product single
 *******************************************************/
function rad_single_product_container()
{
    $gallery_style = rad_get_option("product-gallery-style");
    if ($gallery_style == "carousel" || $gallery_style == "fitgrid") {
        return;
    }

    echo "<div class=\"container\">";
}

function rad_single_product_container_close()
{
    $gallery_style = rad_get_option("product-gallery-style");
    if ($gallery_style == "carousel" || $gallery_style == "fitgrid") {
        return;
    }

    echo "</div>";
}

/******************************************************
 * Product single : Review tab
 *******************************************************/
function rad_woocommerce_output_product_data_tabs()
{
    global $product;
    $wpb_vc_js_status = rad_get_meta("_wpb_vc_js_status", true, $product->get_id());

    if ($wpb_vc_js_status == "false" || $wpb_vc_js_status == "") {
        echo "<div class=\"clear\"></div><div class=\"container\">";
    }
    wc_get_template("single-product/tabs/tabs.php");

    if ($wpb_vc_js_status == "false" || $wpb_vc_js_status == "") {
        echo "</div>";
    }

}

/******************************************************
 * Product single : Review tab
 *******************************************************/
function rad_woocommerce_output_product_review_tabs()
{
    // Reviews tab - shows comments.
    if (function_exists("comments_template") && comments_open()) {
        ob_start();
        comments_template();
        $comments = ob_get_clean();
        echo "<div id=\"main-tab-reviews\">" . $comments . "</div>";
    }
}

function rad_wc_unset_review_tabs($tabs)
{
    if (isset($tabs["reviews"])) {
        $tabs["reviews"]["callback"] = "empty_review_tab";
    }
    return $tabs;
}

function empty_review_tab()
{
    echo "";
}

/******************************************************
 * Product single : Gallery
 *******************************************************/

function product_gallery_lightbox()
{
    $product_gallery_popup = rad_get_option("product_gallery_popup");
    $product_gallery_style = rad_get_option("product_gallery_style");

    $style = "";
    if ($product_gallery_style != 0) {
        $style = " dark";
    }

    if ($product_gallery_popup == 1 && is_product()) {
        echo "<div id=\"p-g-lightbox\" class=\"custom-cursor\" data-cursor=\"#p-g-cursor\"></div><span id=\"p-g-cursor\" class=\"rad-cursor" . $style . "\"><span></span></span>";
    }
}

/******************************************************
 * Product single : Quantity input
 *******************************************************/
function rad_wc_quantity_input()
{
    echo "<div class=\"plus quantity-button\"></div>
    <div class=\"minus quantity-button\"></div>";
}

/******************************************************
 * Product single : Next/Prev buttons
 *******************************************************/
function rad_single_product_nav()
{

    $product_navigation = rad_get_option("product_navigation");
    $output             = "";

    if ($product_navigation != 0) {
        $next = get_next_post_link("%link");
        $prev = get_previous_post_link("%link");
        if ($next) {
            echo "<span id=\"next-product\" class=\"hidden-phone\">" . $next . "</span>";
        }

        if ($prev) {
            echo "<span id=\"prev-product\" class=\"hidden-phone\">" . $prev . "</span>";
        }
    }
}

/******************************************************
 * Product single : Breadcrumbs
 *******************************************************/
function rad_single_product_breadcrumb()
{
    echo woocommerce_breadcrumb(array(
        "delimiter"  => "<span></span>",
        "wrap_after" => "</nav>",
    ));
}

/******************************************************
 * Product single : Video
 *******************************************************/
if (!function_exists("rad_woocommerce_product_video")) {
    function rad_woocommerce_product_video()
    {

        global $product;
        $video_type = rad_get_meta("video_type");
        $attributes = "";

        $attributes = "video_display_type=\"" . esc_attr($video_type) . "\" ";

        if ($video_type == "none" || $video_type == "") {
            return;
        } elseif ($video_type == "local_video_popup") {
            $video_webm = rad_get_meta("video_webm");
            $video_mp4  = rad_get_meta("video_mp4");
            $video_ogv  = rad_get_meta("video_ogv");

            if ($video_webm == "" && $video_mp4 == "" && $video_ogv == "") {
                return;
            }

            $attributes .= "video_webm=\"" . esc_attr($video_webm) . "\" ";
            $attributes .= "video_mp4=\"" . esc_attr($video_mp4) . "\" ";
            $attributes .= "video_ogv=\"" . esc_attr($video_ogv) . "\" ";
        } elseif ($video_type == "embeded_video_vimeo_popup") {
            $vimeo_id = rad_get_meta("video_vimeo_id");
            if ($vimeo_id == "") {
                return;
            }

            $attributes .= "video_vimeo_id=\"" . esc_attr($vimeo_id) . "\" ";
        } else {
            $youtube_id = rad_get_meta("video_youtube_id");
            if ($youtube_id == "") {
                return;
            }

            $attributes .= "video_youtube_id=\"" . esc_attr($youtube_id) . "\" ";
        }

        $video_play_button_color = rad_get_meta("video_play_button_color");
        $attributes .= "video_play_button_color=\"" . esc_attr($video_play_button_color) . "\"";

        echo do_shortcode("[rad_video video_autoplay=\"disable\" " . $attributes . "]");
    }
}

/******************************************************
 * Product single : Related products
 *******************************************************/

if (!function_exists("rad_related_product")) {
    function rad_related_product()
    {
        $related_product = rad_get_option("related_product");
        if ($related_product != 1) {
            remove_action("woocommerce_after_single_product_summary", "woocommerce_output_related_products", 20);
        }
    }
}

rad_related_product();

// used in related.php to remove shop-grid class in carousel mode
if (!function_exists("rad_related_products_remove_grid_class")) {
    function rad_related_products_remove_grid_class($classes)
    {
        if (($key = array_search("shop-grid", $classes)) !== false) {
            unset($classes[$key]);
        }
        return $classes;
    }
}

/******************************************************
 * Product single : Custom tab
 *******************************************************/
if (!function_exists("rad_remove_yikes_custom_tab_heading")) {

    function rad_remove_yikes_custom_tab_heading($heading)
    {
        return "";
    }
}

function rad_subcategory_wrapper($category)
{
    echo "<div class=\"product-wrap\">";
}

function rad_template_loop_category_overlay($category)
{
    $cat_style   = rad_get_option("wc-category-style");
    $hover_color = rad_get_option("wc-category-hover-color");
    $hover_style = ($hover_color != "") ? " style=\"background:linear-gradient(0, " . esc_attr($hover_color) . "90," . esc_attr($hover_color) . "30,transparent, transparent);\"" : "";

    if ($cat_style == 1) {
        echo "<span class=\"overlay\"" . $hover_style . "></span>";
    }
}

function rad_subcategory_wrapper_closing($category)
{
    echo "</div>";
}

function rad_subcategory_thumbnail_open()
{
    echo "<div class=\"img-container\">";
}

function rad_subcategory_thumbnail_close()
{
    echo "</div>";
}

function rad_woocommerce_subcategory_thumbnail($category)
{
    ob_start();
    woocommerce_subcategory_thumbnail($category);
    $img = ob_get_clean();
    $img = str_replace("height=\"\"", "", $img);
    $img = str_replace("height ", "", $img);
    echo "" . $img;
}

function rad_template_loop_category_title($category)
{

    $cat_style           = rad_get_option("wc-category-style");
    $text_color          = rad_get_option("wc-category-text-color");
    $display_number      = rad_get_option("wc-category-number");
    $display_description = rad_get_option("wc-category-description");

    $text_style = ($text_color != "") ? " style=\"color:" . esc_attr($text_color) . ";border-color:" . esc_attr($text_color) . ";\"" : "";

    echo "<div class=\"title\">";
    echo "<h2 class=\"woocommerce-loop-category__title\"" . $text_style . ">";
    echo esc_html($category->name);
    if ($category->count > 0 && $display_number == 1) {
        echo apply_filters("woocommerce_subcategory_count_html", "<mark class=\"count\">" . $category->count . "</mark>", $category); // WPCS: XSS ok.;
    }
    echo "</h2>";

    //hidden in creative style
    if ($category->description != "" && $display_description == 1 && $cat_style != 3) {
        echo "<span class=\"description\"" . $text_style . ">" . esc_html($category->description) . "</span>";
    }
    echo "</div>";
}

/*---------------------------------
WC classes in body
------------------------------------*/
if (!function_exists("rad_wc_body_classes")) {
    function rad_wc_body_classes($classes)
    {

        if (!class_exists("woocommerce")) {
            return $classes;
        }

        $classes[] = "woocommerce";

        if ("yes" === get_option("woocommerce_enable_ajax_add_to_cart")) {
            $classes[] = "ajax-add-to-cart";
        }

        if (is_shop()) {
            $classes[] = "is-woocommerce-shop";
        }

        //Check wishlist
        if (class_exists("YITH_WCWL")) {
            $classes[] = "wishlist-enable";
        }

        //Sticky add to cart
        $sticky_add_to_cart = rad_get_option("sticky_add_to_cart");
        $catalog_mode       = rad_get_option("catalog_mode");

        if ($sticky_add_to_cart == "1" && $catalog_mode == "0" && is_product()) {
            $classes[] = "sticky-addtocart";
        }

        $gallery_style = rad_get_option("product-gallery-style");
        if (is_product()) {
            $classes[] = "product-" . $gallery_style . "-style";
            $classes[] = rad_get_option("attribute_label")? "":"rad_attr_label_hide";
            
        }

        //product styles in shop(main page)
        if ($catalog_mode != 0) {
            $classes[] = "catalog-mode";
        }

        return $classes;
    }
}

/*---------------------------------
WooCommerce columns
------------------------------------*/
if (!function_exists("rad_custom_loop_columns")) {
    function rad_custom_loop_columns()
    {
        $layout  = rad_get_option("shop-layout");
        $columns = (int) rad_get_option("shop-column");
        if ($layout == "scatter" || $layout == "sticky") {
            return 2;
        }

        return $columns;
    }
}

if (!function_exists("rad_add_register_link")) {
    function rad_add_register_link()
    {

        if (get_option("woocommerce_enable_myaccount_registration") === "yes") {
            $register_url = get_permalink(get_option("woocommerce_myaccount_page_id"));
            echo esc_html__("I don't have an account,", "aventa") . " " . "<a class=\"register-link\" href=\"" . $register_url . "\">" . esc_html__("Create it", "aventa") . "</a>";
        }
    }
}

/*---------------------------------
By default WC search redirects user to single product page (when there is just 1 product)
------------------------------------*/
if (!function_exists("rad_redirect_single_search_result")) {
    function rad_redirect_single_search_result()
    {
        return false;
    }
}

/*-----------------------------------
WooCommerce
------------------------------------*/
//remove attribute names from product names(variable product)
if (!function_exists("rad_atts_in_product_name")) {
    function rad_atts_in_product_name()
    {
        return false;
    }
}

if (!function_exists("rad_woo_hide_page_title")) {
    function rad_woo_hide_page_title()
    {
        return false;
    }
}

if (!function_exists("rad_woocommerce_header_add_to_cart_fragment")) {
    function rad_woocommerce_header_add_to_cart_fragment($fragments)
    {

        $fragments[".cart-count"] = "<span class=\"cart-count\">" . WC()->cart->get_cart_contents_count() . "</span>";

        return $fragments;
    }
}

if (!function_exists("rad_remove_ptags_around_shop_page_content")) {
    function rad_remove_ptags_around_shop_page_content($content)
    {
        if (strpos($content, "</div>") !== false) {
            return preg_replace("/<p>(.+)<\/p>$/Uuis", "", $content);
        }

        return $content;
    }
}

if (!function_exists("rad_woocommerce_container")) {
    function rad_woocommerce_container()
    {
        $fullwidth  = rad_get_option("shop-enable-fullwidth");
        $sidebarPos = rad_get_option("shop-sidebar-position");
        if (!is_product()) {

            if (0 == $sidebarPos || !is_active_sidebar("woocommerce-sidebar")) {
                if ($fullwidth != 1) {
                    echo "<div class=\"shop_top_padding container\">";
                } else {
                    echo "<div class=\"shop_top_padding shop-fluid-no-sidebar\">";
                }
                echo "<div class=\"container shop-top-area\">";
            } else {
                if ($fullwidth != 1) {
                    echo "<div class=\"shop_top_padding container\">";
                } else {
                    echo "<div class=\"shop_top_padding shop_fullwidth_sidebar\">";
                }

                $contentClass = "span10 has-wc-sidebar";
                if (1 == $sidebarPos) {
                    $contentClass .= " float-right";
                } elseif (2 == $sidebarPos) {
                    $contentClass .= " float-left";
                }

                echo "<div class=\"" . esc_attr($contentClass) . "\"><div class=\"shop-top-area clearfix\">";

            }

        }
    }
}

if (!function_exists("rad_woocommerce_top_container_close")) {
    function rad_woocommerce_top_container_close()
    {
        echo "</div>";
    }
}

if (!function_exists("rad_woocommerce_container_close")) {
    function rad_woocommerce_container_close()
    {
        if (!is_product()) {
            $sidebarPos = rad_get_option("shop-sidebar-position");
            if ($sidebarPos != 0 && is_active_sidebar("woocommerce-sidebar")) {
                echo "</div>";
                echo "<!-- Sidebar -->";
                ob_start();
                dynamic_sidebar("woocommerce-sidebar");
                $sidebar = ob_get_clean();
                echo "<div id=\"woocommerce-sidebar\" class=\"span2\">" . $sidebar . "</div>";
            }

            echo "</div>";
        }
    }
}

if (!function_exists("rad_woocommerce_ajax_wrapper_start")) {
    function rad_woocommerce_ajax_wrapper_start()
    {
        $shop_pagination = rad_get_option("products-pagination");
        $class           = "pgn-style";
        if ($shop_pagination == "load_more" || $shop_pagination == "infinite_scroll") {
            $class = "ldm-style";
        }
        echo "<div class=\"wc-ajax-wrapper\">
            <span class=\"wc-loading hide\"></span>
            <div class=\"wc-ajax-content " . esc_attr($class) . "\" data-pagination=\"" . esc_attr($shop_pagination) . "\">";
    }
}

if (!function_exists("rad_woocommerce_ajax_wrapper_end")) {
    function rad_woocommerce_ajax_wrapper_end()
    {
        echo "</div></div>";
    }
}

/*-----------------------------------------------------------------*/
/* WooCommerce Quick view button
/*-----------------------------------------------------------------*/
if (!function_exists("rad_add_quick_view_button")) {
    function rad_add_quick_view_button()
    {
        global $product;

        $quick_view          = rad_get_option("shop-enable-quickview");
        $product_hover_style = rad_get_option("product-style");

        $hook_name = current_filter();

        if ($hook_name == "rad_woocommerce_shop_loop_hover_buttons") {
            if ($product_hover_style == "general") {
                return;
            }

        } elseif ($hook_name == "rad_woocommerce_shop_loop_buttons") {
            if ($product_hover_style == "bt-hover" || $product_hover_style == "qv-hover" || $product_hover_style == "creative" || $product_hover_style == "simple-hover") {
                return;
            }
        }

        $classes = "quick-view-button";
        $attrs   = "data-product_id=\""
        . esc_attr($product->get_id()) . "\" title=\"" . esc_attr__("Show in quickview", "aventa") . "\"";

        if ($product_hover_style == "creative") {
            $classes .= " custom-cursor";
            $attrs .= " data-cursor=\"#qv-cursor\"";
        }
        if ($quick_view == "1" && class_exists("Woocommerce")) {

            echo "<span class=\"rad-qv\"><a href=\"#\" class=\"" . esc_attr($classes) . "\" " . $attrs . ">";
            echo rad_Icon_Manager::get_icon("eye");
            echo esc_html__("Quick View", "aventa") . "</a></span>";
        }
    }
}

/*-----------------------------------------------------------------*/
/* WooCommerce Quick view cursor
/*-----------------------------------------------------------------*/
if (!function_exists("rad_quick_view_cursor")) {
    function rad_quick_view_cursor()
    {

        $quick_view   = rad_get_option("shop-enable-quickview");
        $hover_style  = rad_get_option("product-style");
        $cursor_style = rad_get_option("quickview-cursor");
        $color_style  = rad_get_option("product-hover-theme");

        if (class_exists("Woocommerce") && $quick_view == "1" && $hover_style == "creative") {
            if ($cursor_style == "text") {
                echo "<span id=\"qv-cursor\" class=\"rad-cursor " . esc_attr($color_style) . "\"><span>" . esc_html__("Quick View", "aventa") . "</span></span>";
            } else {
                echo "<span id=\"qv-cursor\" class=\"rad-cursor " . esc_attr($color_style) . "\"><span class=\"icon\">" . rad_Icon_Manager::get_icon("eye") . "</span></span>";
            }

        }
    }
}

//Quick view Ajax
if (!function_exists("rad_load_quick_view")) {
    function rad_load_quick_view()
    {

        $args = array(
            "posts_per_page" => 1,
            "post_type"      => "product",
            "post_status"    => "publish",
            "no_found_rows"  => 1,
        );

        if (!isset($_POST["product_id"])) {
            return;
        }

        $args["p"] = absint($_POST["product_id"]);

        $single_product = new WP_Query($args);

        ob_start();

        global $wp_query;

        // Backup query object so following loops think this is a product page.
        $previous_wp_query = $wp_query;
        $wp_query          = $single_product;

        //temporarily disable actions and filters
        if (function_exists("rad_social_share")) {
            remove_action("woocommerce_before_single_product_summary", "rad_social_share", 5);
        }
        remove_action("woocommerce_after_single_product_summary", "woocommerce_output_related_products", 20);
        remove_action("woocommerce_after_single_product_summary", "woocommerce_upsell_display", 15);
        remove_action("woocommerce_after_single_product_summary", "woocommerce_output_product_data_tabs", 10);
        remove_action("woocommerce_after_single_product_summary", "rad_woocommerce_output_product_data_tabs", 15);
        remove_action("woocommerce_single_product_summary", "rad_woocommerce_output_product_data_tabs", 20);
        remove_action("woocommerce_single_product_summary", "rad_woocommerce_output_product_data_tabs", 30);
        remove_action("woocommerce_after_single_product_summary", "rad_woocommerce_output_product_review_tabs", 10);

        remove_action("woocommerce_single_product_summary", "rad_single_product_breadcrumb", 0);
        remove_action("woocommerce_before_single_product_summary", "rad_single_product_breadcrumb", 11);
        remove_action("woocommerce_after_single_product_summary", "rad_single_product_nav", 20);
        remove_action("woocommerce_before_single_product_summary", "rad_single_product_container", 10);
        add_action("woocommerce_single_product_summary", "rad_woocommerce_template_single_title_link_open", 4);
        add_action("woocommerce_single_product_summary", "rad_woocommerce_template_single_title_link_close", 6);

        add_filter("rad_get_option_filter", function ($value, $key) {
            switch ($key) {
                case "product-tab-position":
                    return "default";
                    break;
                case "product-gallery-style":
                    return "carousel";
                    break;
                default:
                    return $value;
                    break;
            }
        }, 100, 2);

        while ($single_product->have_posts()) {
            $single_product->the_post();
            wc_get_template_part("content", "single-product");
        }

        // Restore $previous_wp_query and reset post data.
        $wp_query = $previous_wp_query;
        wp_reset_postdata();

        $output = ob_get_clean();
        echo "" . $output; //sanitized
        exit;
    }
}

//title of quick view product
if (!function_exists("rad_woocommerce_template_single_title_link_open")) {
    function rad_woocommerce_template_single_title_link_open()
    {
        global $product;
        echo "<a  href=\"" . esc_url(get_permalink($product->get_id())) . "\">";
    }
}

//title of quick view product
if (!function_exists("rad_woocommerce_template_single_title_link_close")) {
    function rad_woocommerce_template_single_title_link_close()
    {
        echo "</a>";
    }
}

if (!function_exists("rad_shop_page_wishlist_button")) {
    function rad_shop_page_wishlist_button()
    {
        if (class_exists("YITH_WCWL")) {
            global $product, $yith_wcwl;

            $product_hover_style = rad_get_option("product-style");
            $hook_name           = current_filter();

            if ($hook_name == "rad_woocommerce_shop_loop_hover_buttons") {
                if ($product_hover_style != "bt-hover" && $product_hover_style != "simple-hover") {
                    return;
                }

            } elseif ($hook_name == "rad_woocommerce_shop_loop_buttons") {
                if ($product_hover_style == "bt-hover" || $product_hover_style == "simple-hover") {
                    return;
                }
            }

            $wishlist = rad_get_option("product-wishlist");
            if ($wishlist != "1" && class_exists("Woocommerce")) {
                return;
            }

            $default_wishlists = is_user_logged_in() ? YITH_WCWL()->get_wishlists(array("is_default" => true)) : false;

            if (!empty($default_wishlists)) {
                $default_wishlist = $default_wishlists[0]["ID"];
            } else {
                $default_wishlist = false;
            }

            //We put 2 buttons inside a tag to simplify css codes
            $output = "<span>";
            $output .= "<a href=\"" . esc_url(add_query_arg("add_to_wishlist", $product->get_id())) . "\" rel=\"nofollow\" data-product-id=\"" . esc_attr($product->get_id()) . "\" data-product-type=\"" . esc_attr($product->get_type()) . "\" class=\"add_to_wishlist shop_wishlist_button " . esc_attr(($yith_wcwl->is_product_in_wishlist($product->get_id(), $default_wishlist) == true ? "exist_in_wishlist " : "")) . "\" title=\"" . esc_attr__("Add to wishlist", "aventa") . "\">" . rad_Icon_Manager::get_icon("heart") . "</a>";
            $output .= "<a href=\"" . esc_url($yith_wcwl->get_wishlist_url()) . "\" rel=\"nofollow\" class=\"wishlist-link shop_wishlist_button\" style=\"" . esc_attr(($yith_wcwl->is_product_in_wishlist($product->get_id(), $default_wishlist) == true ? "display:block; " : "")) . "\" title=\"" . esc_attr__("Go to wishlist", "aventa") . "\">" . rad_Icon_Manager::get_icon("heart", "solid") . "</a>";
            $output .= "</span>";

            echo "" . $output; //sanitized
        }
    }
}

/******************************************************
 * Product single page : Remove item from cart
 *******************************************************/

if (!function_exists("rad_remove_item")) {
    function rad_remove_item()
    {

        $item_key = $_POST["item_key"];

        $removed = WC()->cart->remove_cart_item($item_key); // Note: WP 2.3 >

        if ($removed) {
            $data["status"]        = "1";
            $data["cart_count"]    = WC()->cart->get_cart_contents_count();
            $data["cart_subtotal"] = WC()->cart->get_cart_subtotal();
        } else {
            $data["status"] = "0";
        }

        echo json_encode($data);

        exit;

    }
}

if (!function_exists("rad_undo_removed_item")) {
    function rad_undo_removed_item()
    {

        $item_key = $_POST["item_key"];

        $cart      = WC()->instance()->cart;
        $undo_item = $cart->restore_cart_item($item_key);

        if ($undo_item) {
            $data["status"]        = "1";
            $data["cart_count"]    = $cart->get_cart_contents_count();
            $data["cart_subtotal"] = $cart->get_cart_subtotal();
        } else {
            $data["status"] = "0";
        }

        echo json_encode($data);

        exit;

    }
}

/******************************************************
 * Product single page : New attributes frontend
 *******************************************************/

if (!function_exists("rad_new_attribute_typesـoutput")) {
    function rad_new_attribute_typesـoutput($old_html, $args)
    {
        $type = rad_wc_get_Attribute_type($args["attribute"]);
        if ($type != "" && $type == "select") {
            return $old_html;
        }

        // Get selected value.
        if (false === $args["selected"] && $args["attribute"] && $args["product"] instanceof WC_Product) {
            $selected_key     = "attribute_" . sanitize_title($args["attribute"]);
            $args["selected"] = isset($_REQUEST[$selected_key]) ? wc_clean(wp_unslash($_REQUEST[$selected_key])) : $args["product"]->get_variation_default_attribute($args["attribute"]); // WPCS: input var ok, CSRF ok, sanitization ok.
        }

        $options               = $args["options"];
        $product               = $args["product"];
        $attribute             = $args["attribute"];
        $name                  = $args["name"] ? $args["name"] : "attribute_" . sanitize_title($attribute);
        $id                    = $args["id"] ? $args["id"] : sanitize_title($attribute);
        $class                 = $args["class"];
        $show_option_none      = (bool) $args["show_option_none"];
        $show_option_none_text = $args["show_option_none"] ? $args["show_option_none"] : esc_html__("Choose an option", "aventa"); // We'll do our best to hide the placeholder, but we need to show something when resetting options.

        if (empty($options) && !empty($product) && !empty($attribute)) {
            $attributes = $product->get_variation_attributes();
            $options    = $attributes[$attribute];
        }

        $attr_values = get_post_meta(absint($product->get_id()), esc_attr($attribute) . "_extravalue", true);

        echo "<div class=\"attr-container " . $type . "-attr\">";

        if (!empty($options)) {
            if ($product && taxonomy_exists($attribute)) {
                // Get terms if this is a taxonomy - ordered. We need the names too.
                $terms = wc_get_product_terms(
                    $product->get_id(),
                    $attribute,
                    array(
                        "fields" => "all",
                    )
                );

                foreach ($terms as $term) {

                    if (in_array($term->slug, $options, true)) {

                        if ($type == "image") {
                            if (isset($attr_values[$term->slug])) {
                                $selected = sanitize_title($args["selected"]) === $term->slug ? " selected" : "";
                                $attr_image = '';
                                if ($attr_values[$term->slug]) {
                                    $attr_image = rad_get_image($attr_values[$term->slug], "", $term->name, "thumbnail", "", "", "", false);
                                } else {
                                    continue;
                                }

                                echo "<div class=\"attr-item" . esc_attr($selected) . "\" data-value=\"" . esc_attr($term->slug) . "\" title=\"" . esc_attr($term->name) . "\">";
                                echo wp_kses($attr_image, array("img" => array("src" => array(), "class" => array(), "alt" => array())));
                                echo "</div>";
                            }
                        } elseif ($type == "color") {

                            $selected = sanitize_title($args["selected"]) === $term->slug ? " selected" : "";

                            echo "<div class=\"attr-item" . esc_attr($selected) . "\" data-value=\"" . esc_attr($term->slug) . "\" title=\"" . esc_attr($term->name) . "\">";
                            echo "<span style=\"background-color:#" . get_term_meta($term->term_id, "attr_color", true) . "\"></span>";
                            echo "</div>";

                        } elseif ($type == "size") {

                            $selected = sanitize_title($args["selected"]) === $term->slug ? " selected" : "";

                            echo "<div class=\"attr-item" . esc_attr($selected) . "\" data-value=\"" . esc_attr($term->slug) . "\" title=\"" . esc_attr($term->name) . "\">";
                            echo esc_html($term->name);
                            echo "</div>";

                        }

                    }
                }
            }
        }

        echo "" . $old_html; //Echo original attribute as select
        echo "</div>";

    }
}


/******************************************************
 * Show WooCommerce Notices
 *******************************************************/
if ( !function_exists( "rad_show_wc_error_messages" ) ) {

    function rad_show_wc_error_messages() {

        if ( function_exists( 'wc_print_notices' ) ) {

            echo "<div class=\"woocommerce-notices-wrapper\">";
                wc_print_notices();
            echo "</div>";

        }

    }

}
/********************************************************************
 * Change default position of cross-sell products in the cart page
*********************************************************************/
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
add_action( 'woocommerce_after_cart_table', 'woocommerce_cross_sell_display' );