<?php

if (!rad_is_wc_active()) {
    return;
}

/*---------------------------------
Get account/login link
------------------------------------*/
if (!function_exists("rad_get_myaccount_link")) {
    function rad_get_myaccount_link()
    {
        if (!rad_is_wc_active()) {
            return;
        }

        $myaccount_url = get_permalink(get_option("woocommerce_myaccount_page_id"));
        $link_title    = (is_user_logged_in()) ? esc_html__("My Account", "aventa") : esc_html__("Login / Register", "aventa");
        $myaccount_url = (!is_user_logged_in()) ? "#" : $myaccount_url;

        return "<a href=\"" . esc_url($myaccount_url) . "\"><span class=\"hidden-phone hidden-tablet\">" . $link_title . "</span><span class=\"hidden-desktop\">" . rad_Icon_Manager::get_icon("user-alt", "light") . "</span></a>";
    }
}

//display categories and subcategories as text.
if (!function_exists("rad_woocommerce_product_subcategories")) {
    function rad_woocommerce_product_subcategories($category_id, $class, $with_image = false)
    {
        $output = "";
        $args   = array(
            "taxonomy"   => "product_cat",
            "parent"     => false,
            "hide_empty" => false,
            "meta_query" => array(
                "relation" => "OR",
                array(
                    "key"     => "cat-collection",
                    "value"   => "1",
                    "compare" => "!=",
                ),
                array(
                    "key"     => "cat-collection",
                    "compare" => "NOT EXISTS",
                ),
            ),
        );

        $terms = get_terms($args);

        if ($class != "") {
            $class = " " . $class;
        }

        if ($terms) {
            foreach ($terms as $term) {
                if ($term->count > 0) {
                    // prevent to display empty categories
                    $img = "";
                    if ($with_image == true) {
                        $thumbnail_id = get_term_meta($term->term_id, "thumbnail_id", true);
                        $img          = "<div class=\"img\">" . rad_get_wc_image($thumbnail_id, $term->name) . "</div>";
                    }

                    if ($term->term_id == $category_id) {
                        $output .= "<li class=\"swiper-slide current-term\">";
                        $output .= $img;
                        $output .= "<span class=\"underline-style\">" . $term->name . "<span class=\"count\">" . $term->count . "</span></span></li>";
                    } else {
                        $output .= "<li class=\"swiper-slide\">";
                        $output .= "<a href=\"" . esc_url(get_term_link($term)) . "\" class=\"" . $term->slug . "\">";
                        $output .= $img;
                        $output .= "<span class=\"underline-style\">" . $term->name . "<span class=\"count\">" . $term->count . "</span></span></a></li>";
                    }
                }
            }
        }

        if ($output != "") {
            echo "<div id=\"cat-disply\" class=\"swiper-container" . esc_attr($class) . "\"><ul class=\"swiper-wrapper\">" . $output . "</ul></div>";
        }

    }
}

//display categories and subcategories in simple style.
if (!function_exists("rad_woocommerce_product_subcategories_simple")) {
    function rad_woocommerce_product_subcategories_simple($category_id = null)
    {
        $output = "";

        $args = array(
            "taxonomy"   => "product_cat",
            "parent"     => $category_id,
            "hide_empty" => false,
            "meta_query" => array(
                "relation" => "OR",
                array(
                    "key"     => "cat-collection",
                    "value"   => "1",
                    "compare" => "!=",
                ),
                array(
                    "key"     => "cat-collection",
                    "compare" => "NOT EXISTS",
                ),
            ),
        );

        $terms = get_terms($args);

        $current_cat = get_term_by("id", $category_id, "product_cat");

        $page_url = wc_get_page_permalink("shop");
        if ("" === get_option("permalink_structure")) {
            $page_url = get_post_type_archive_link("product");
        }

        if ($terms) {

            $output .= "<li class=\"all-cats\">";
            $output .= "<a href=\"" . esc_url($page_url) . "\" class=\"underline-style\">" . esc_html__("All", "aventa") . "</a>";
            $output .= "</li>";

            if ($current_cat) {
                $output .= "<li class=\"current-cat\">";
                $output .= "<a href=\"" . esc_url(get_term_link($current_cat->term_id)) . "\" class=\"underline-style\">" . $current_cat->name . "</a>";
                $output .= "</li>";
            }

            foreach ($terms as $term) {
                $output .= "<li class=\"current-sub\">";
                $output .= "<a href=\"" . esc_url(get_term_link($term)) . "\" class=\"underline-style " . $term->slug . "\">" . $term->name . "</a>";
                $output .= "</li>";
            }
        } else {
            $output .= "<li>";
            $output .= "<a href=\"" . esc_url($page_url) . "\" class=\"underline-style init-show\">" . esc_html__("Return back to all products", "aventa") . "</a>";
            $output .= "</li>";
        }

        if ($output != "") {
            return "<ul>" . $output . "</ul>";

        }

        return "<ul class=\"no-subcat\"><li>" . esc_html__("There is no subcategories", "aventa") . "</li></ul>";

    }
}

//display categories and subcategories in simple style.
if (!function_exists("rad_woocommerce_product_subcategories_slugs")) {
    function rad_woocommerce_product_subcategories_slugs($category_id = null)
    {
        $output = "";

        if (!rad_is_wc_active()) {
            return;
        }

        $args = array(
            "taxonomy"   => "product_cat",
            "parent"     => $category_id,
            "hide_empty" => false,
            "meta_query" => array(
                "relation" => "OR",
                array(
                    "key"     => "cat-collection",
                    "value"   => "1",
                    "compare" => "!=",
                ),
                array(
                    "key"     => "cat-collection",
                    "compare" => "NOT EXISTS",
                ),
            ),
        );

        $terms = get_terms($args);

        if ($terms) {
            foreach ($terms as $term) {
                $output .= "<li class=\"underline-style\" data-slug=\"" . $term->slug . "\">";
                $output .= $term->name . "</li>";
            }
        }

        if ($output != "") {
            echo "<ul><li class=\"underline-style\" data-slug=\"all\">" . esc_html__("All", "aventa") . "</li>" . $output . "</ul>";

        }

    }
}

function rad_wc_get_Attribute_type($attribute_name)
{

    $attributes = wc_get_attribute_taxonomies();
    foreach ($attributes as $key => $attribute) {
        if ("pa_" . $attribute->attribute_name == $attribute_name) {
            return $attribute->attribute_type;
        }
    }
    return "";
}

/*-----------------------------------------------------------------*/
// Check if current request is an AJAX request */
/*-----------------------------------------------------------------*/
//Check if current request is an AJAX request for main-loop shop */
if (!function_exists("rad_is_shop_ajax_request")) {
    function rad_is_shop_ajax_request()
    {
        if (function_exists("rad_is_ajax_request") && rad_is_ajax_request() == true && isset($_POST["ajax_shop_req"]) && $_POST["ajax_shop_req"] == true) {
            return true;
        }

        return false;
    }
}

//Check if current request is an AJAX request for main-loop shop */
if (!function_exists("rad_is_shop_ajax_add_to_cart")) {
    function rad_is_shop_ajax_add_to_cart()
    {

        if (function_exists("rad_is_ajax_request") && rad_is_ajax_request() == true && ((isset($_GET["wc-ajax"]) && $_GET["wc-ajax"] == "add_to_cart") || (isset($_GET["rad-ajax-add-to-cart"]) && $_GET["rad-ajax-add-to-cart"] == "1"))) {
            return true;
        }

        return false;
    }
}

//Redeclare woocommerce woocommerce_product_archive_description function - Show a shop page description on product archives.
if (!function_exists("woocommerce_product_archive_description")) {
    function woocommerce_product_archive_description()
    {
        // Do not display the description on search results page
        if (is_search() || rad_is_shop_ajax_request()) {
            return;
        }

        if (is_post_type_archive("product") && 0 === absint(get_query_var("paged"))) {
            $shop_page = get_post(wc_get_page_id("shop"));
            if ($shop_page) {
                $description = wc_format_content($shop_page->post_content);

                if ($description) {
                    echo "<div class=\"page-description\">" . $description . "</div>";
                }
            }
        }
    }
}

/*-----------------------------------
Redeclare Original WC functions - cart & checkout buttons in cart
------------------------------------*/
if (!function_exists("woocommerce_widget_shopping_cart_button_view_cart")) {
    function woocommerce_widget_shopping_cart_button_view_cart()
    {
        //add data-hover attribute for checkout and view cart buttons
        echo "<a href=\"" . esc_url(wc_get_cart_url()) . "\" class=\"button wc-forward\">
                <span data-hover=\"" . esc_attr__("View Cart", "aventa") . "\">" . esc_html__("View Cart", "aventa") . "</span>
            </a>";
    }
}

if (!function_exists("woocommerce_widget_shopping_cart_proceed_to_checkout")) {
    function woocommerce_widget_shopping_cart_proceed_to_checkout()
    {
        echo "<a href=\"" . esc_url(wc_get_checkout_url()) . "\" class=\"button checkout wc-forward\" >
                <span data-hover=\"" . esc_attr__("Checkout", "aventa") . "\">" . esc_html__("Checkout", "aventa") . "</span>
            </a>";
    }
}

if (!function_exists("rad_get_wc_image")) {
    function rad_get_wc_image($thumbnail_id, $alt = "", $thumbnail_size = "woocommerce_thumbnail")
    {

        $dimensions = wc_get_image_size($thumbnail_size);

        if ($thumbnail_id) {
            $image        = wp_get_attachment_image_src($thumbnail_id, $thumbnail_size);
            $image        = $image[0];
            $image_srcset = function_exists("wp_get_attachment_image_srcset") ? wp_get_attachment_image_srcset($thumbnail_id, $thumbnail_size) : false;
            $image_sizes  = function_exists("wp_get_attachment_image_sizes") ? wp_get_attachment_image_sizes($thumbnail_id, $thumbnail_size) : false;
        } else {
            $image        = wc_placeholder_img_src();
            $image_srcset = false;
            $image_sizes  = false;
        }

        if ($image) {
            // Prevent esc_url from breaking spaces in urls for image embeds.
            // Ref: https://core.trac.wordpress.org/ticket/23605.
            $image = str_replace(" ", "%20", $image);

            // Add responsive image markup if available.
            if ($image_srcset && $image_sizes) {
                $image = "<img src=\"" . esc_url($image) . "\" alt=\"" . esc_attr($alt) . "\" width=\"" . esc_attr($dimensions["width"]) . "\" height=\"" . esc_attr($dimensions["height"]) . "\" srcset=\"" . esc_attr($image_srcset) . "\" sizes=\"" . esc_attr($image_sizes) . "\" />";
            } else {
                $image = "<img src=\"" . esc_url($image) . "\" alt=\"" . esc_attr($alt) . "\" width=\"" . esc_attr($dimensions["width"]) . "\" height=\"" . esc_attr($dimensions["height"]) . "\" />";
            }
        }
        $image = str_replace("height=\"\"", "", $image);
        return $image;
    }
}

if (!function_exists("rad_get_wc_image_attr")) {
    function rad_get_wc_image_attr($thumbnail_id, $thumbnail_size = "woocommerce_thumbnail")
    {

        $dimensions = wc_get_image_size($thumbnail_size);

        if ($thumbnail_id) {
            $image        = wp_get_attachment_image_src($thumbnail_id, $thumbnail_size);
            $image        = $image[0];
            $image_srcset = function_exists("wp_get_attachment_image_srcset") ? wp_get_attachment_image_srcset($thumbnail_id, $thumbnail_size) : false;
            $image_sizes  = function_exists("wp_get_attachment_image_sizes") ? wp_get_attachment_image_sizes($thumbnail_id, $thumbnail_size) : false;
        } else {
            $image        = wc_placeholder_img_src();
            $image_srcset = false;
            $image_sizes  = false;
        }

        if ($image) {
            // Prevent esc_url from breaking spaces in urls for image embeds.
            // Ref: https://core.trac.wordpress.org/ticket/23605.
            $image = str_replace(" ", "%20", $image);

            // Add responsive image markup if available.
            if ($image_srcset && $image_sizes) {
                return array(
                    "src"    => $image,
                    "width"  => $dimensions["width"],
                    "height" => $dimensions["height"],
                    "srcset" => $image_srcset,
                    "sizes"  => $image_sizes,
                );

            } else {
                return array(
                    "src"    => $image,
                    "width"  => $dimensions["width"],
                    "height" => $dimensions["height"],
                    "srcset" => "",
                    "sizes"  => "",
                );
            }
        }
    }
}


if (!function_exists("rado_collection_output")) {
    function rado_collection_output()
    {
        $output       = "";
        $taxonomy     = "product_cat";//Woocommerce taxanomy name
        $orderby      = "name";  
        $show_count   = 0;      //set 1 for yes, 0 for no
        $pad_counts   = 0;      //set 1 for yes, 0 for no
        $hierarchical = 1;      //set 1 for yes, 0 for no  
        $title        = "";  
        $empty        = 0;

        $args = array(
           "taxonomy"     => $taxonomy,
           "orderby"      => $orderby,
           "show_count"   => $show_count,
           "pad_counts"   => $pad_counts,
           "hierarchical" => $hierarchical,
           "title_li"     => $title,
           "hide_empty"   => $empty,
           "meta_query" => array(
                array(
                   "key"       => "cat-collection",
                   "value"     => "1",
                   "compare"   => "="
                )
            ),
        );

        //get all woocommerce categories on the basis of $args  
        $get_all_categories = get_categories( $args );

        foreach ($get_all_categories as $cat) {
            $category_id = $cat->term_id;


            $thumbnail_id = get_term_meta( $category_id, "thumbnail_id", true );
            $image = wp_get_attachment_image_src( $thumbnail_id, "thumbnail" );
            $img = "";
            if ( is_array($image)) {
                  $img = "<img src=\"" . esc_url($image[0]) . "\" alt=\"" . esc_attr($cat->name) . "\" />";
            }

            $output .= "<li><a href=\"". get_term_link($cat->slug, "product_cat") . "\">" . $img . "<div class=\"cat\"><h4>" . esc_html($cat->name) . "</h4>" . esc_html($cat->description) ."</div></a></li>"; 

        }

        return $output;
    }
}