<?php

function register_all_sidebars()
{
    if (!function_exists("register_sidebar")) {
        return;
    }

    $theme_sidebars = array("Blog Sidebar", "Page Sidebar", "Toggle Sidebar", "WooCommerce Sidebar", "WC Filter first column", "WC Filter 2nd column", "WC Filter 3rd column", "WC Filter 4th column");

    $defaults = array(
        "name"          => esc_html__("Blog Sidebar", "aventa"),
        "before_widget" => '<div id="%1$s" class="widget %2$s">',
        "after_widget"  => '</div>',
        "before_title"  => '<h4 class="widget-title">',
        "after_title"   => '</h4>',
    );

    $footer_type        = rad_get_option("footer-type");
    $footer_widget_bars = 1;
    if ($footer_type == 1) {
        $footer_widget_bars = 3;
    } elseif ($footer_type == 2) {
        $footer_widget_bars = 2;
    } elseif ($footer_type == 5) {
        $footer_widget_bars = 2;
    }

    //Blog sidebar
    register_sidebar(array_merge($defaults, array("id" => "main-sidebar")));

    //Page sidebar
    register_sidebar(array_merge($defaults, array("name" => esc_html__("Page Sidebar", "aventa"), "id" => "page-sidebar")));

    //Footer widgets
    for ($i = 0; $i < $footer_widget_bars; $i++) {
        register_sidebar(array_merge($defaults, array(
            "name" => esc_html__("Footer Widgetbar", "aventa") . " " . ($i + 1),
            "id"   => "footer-widget-" . ($i + 1))
        ));

        $theme_sidebars[] = "Footer Widget " . ($i + 1);
    }

    //Woocommerce Sidebar
    register_sidebar(array_merge($defaults, array("name" => esc_html__("WC Sidebar", "aventa"), "id" => "woocommerce-sidebar")));

    //Woocommerce Filter Sidebar
    if (rad_get_option("shop-filter")) {
        register_sidebar(array_merge($defaults, array("name" => esc_html__("WC Filter first column", "aventa"), "id" => "woocommerce-filter-sidebar1")));
        register_sidebar(array_merge($defaults, array("name" => esc_html__("WC Filter 2nd column", "aventa"), "id" => "woocommerce-filter-sidebar2")));
        register_sidebar(array_merge($defaults, array("name" => esc_html__("WC Filter 3rd column", "aventa"), "id" => "woocommerce-filter-sidebar3")));
        register_sidebar(array_merge($defaults, array("name" => esc_html__("WC Filter 4th column", "aventa"), "id" => "woocommerce-filter-sidebar4")));
    }

    //Custom Sidebars
    if (rad_get_option("custom_sidebars") != "") {
        $sidebars = explode(",", rad_get_option("custom_sidebars"));
        $i        = 0;

        foreach ($sidebars as $bar) {
            if (!in_array($bar, $theme_sidebars) && !is_active_sidebar($bar)) {
                register_sidebar(array_merge($defaults, array(
                    "id"   => "custom-$i",
                    "name" => str_replace("%666", ",", $bar),
                )));

                $theme_sidebars[] = str_replace("%666", ",", $bar);
            }

            $i++;
        }
    }
}

add_action("widgets_init", "register_all_sidebars");
