<?php

class Rad_Nav_Walker extends Walker_Nav_Menu
{
    private $navIdPrefix = "";

    private $curItemID;
    private $megaMenuWraperID;
    private $menu_output = true;

    public function __construct($idPrefix = "menu-item-")
    {
        $this->navIdPrefix = $idPrefix;
    }

    public function start_el(&$output, $object, $depth = 0, $args = array(), $current_object_id = 0)
    {

        $this->curItemID = $object->ID;

        $indent = ($depth) ? str_repeat("\t", $depth) : "";

        $class_names = "";

        $classes = empty($object->classes) ? array() : (array) $object->classes;

        $classes = array_slice($classes, 0);
        //add mega menu class
        $is_mega_menu = get_post_meta($object->ID, "is-mega-menu", true);
        if ($depth == 0 && $is_mega_menu == 1) {
            $classes[] = "mega-menu-parent";
        }

        //badge
        $badge          = get_post_meta($object->ID, "badge-label", true);
        $badge_bg_color = get_post_meta($object->ID, "badge-bg-color", true);

        $bg = "";

        if ($depth > 0) {
            $bg = get_post_meta($object->ID, "bg-image", true);

            if ($bg != "") {
                $classes[] = "has-bg";
            }
        }

        $class_names = join(" ", apply_filters("nav_menu_css_class", array_filter($classes), $object));

        $attributes = !empty($object->attr_title) ? " title=\"" . esc_attr($object->attr_title) . "\"" : "";
        $attributes .= !empty($object->target) ? " target=\"" . esc_attr($object->target) . "\"" : "";
        $attributes .= !empty($object->xfn) ? " rel=\"" . esc_attr($object->xfn) . "\"" : "";

        if ($object->object == "custom") {
            $type = get_post_meta($object->ID, "_menu_item_rad_menu_type", true);

            if ($type == "column") {
                if ($depth == 1) {
                    $bg           = ($bg != "") ? " style=\"background:url(" . esc_url(rad_get_image_url($bg, "full")) . ");\"" : "";
                    $has_bg_class = ($bg != "") ? " has-bg" : "";

                    $output .= $indent . "<div class=\"menu-column" . $has_bg_class . "\" " . $bg . ">";
                }
            } elseif ($type == "headline") {
                if ($depth == 2) {
                    $class_names .= " " . "headline";
                    $output .= $indent . "<li class=\"" . esc_attr($class_names) . "\">";
                }
            } elseif ($type == "banner") {
                if ($depth == 2) {
                    $image = ($bg != "") ? "<div><img src=\"" . esc_url(rad_get_image_url($bg, "full")) . "\" alt=\"" . esc_attr__("banner", "aventa") . "\"></div>" : "";
                    $output .= $indent . "<li class=\"menu-banner\">" . $image;
                }

            } elseif ($type == "collection") {
                $output .= $indent . "<li class=\"collection\">";
            } else {
                $bg = ($bg != "") ? " style=\"background:url(" . esc_url($bg) . ");\"" : "";
                $output .= $indent . "<li class=\"" . $class_names . "\" " . $bg . ">";
            }

        } else {
            $bg = ($bg != "") ? " style=\"background:url( " . esc_url($bg) . ");\"" : "";
            $output .= $indent . "<li class=\"" . $class_names . "\" " . $bg . ">";
        }

        $attributes .= !empty($object->url) ? " href=\"" . esc_url($object->url) . "\"" : "";

        $object_output = $args->before;
        $object_output .= "<a" . $attributes . ">";
        $object_output .= $args->link_before;
        $object_output .= "<span>" . apply_filters("the_title", $object->title, $object->ID) . "</span>";

        $badge_output = "";
        if ($badge != "") {
            $badge_output = "<span class=\"badge unselectable\"" . ($badge_bg_color != "" ? " style=\"background-color:" . esc_attr($badge_bg_color) . "\"" : "") . ">" . $badge . "</span>";
        }

        $object_output .= $badge_output;
        $object_output .= $args->link_after;
        $object_output .= "</a>";
        $object_output .= "" . $args->after;

        //Custom menu types
        if ($object->object == "custom") {
            $type = get_post_meta($object->ID, "_menu_item_rad_menu_type", true);
            if ($type == "column") {
                $object_output = "";
            } elseif ($type == "headline") {
                if ($object->title != "") {
                    $object_output = $object->title . $badge_output;
                }

                if ($depth != 2) {
                    $object_output = ""; // reset it when was used in wrong depth
                }
            } elseif ($type == "banner") {
                $object_output .= $object->title;
                if ($depth != 2) {
                    $object_output = ""; // reset it when was used in wrong depth
                }
            }

        }

        $output .= apply_filters("walker_nav_menu_start_el", $object_output, $object, $depth, $args);

    }

    public function end_el(&$output, $item, $depth = 0, $args = array())
    {

        if ($this->menu_output == false) {
            $this->menu_output = true;
            return;
        }

        if ($item->object == "custom") {
            $type = get_post_meta($item->ID, "_menu_item_rad_menu_type", true);
            if ($type == "column") {
                if ($depth == 1) {
                    $output .= "</div>";
                }
            } elseif ($type == "headline") {
                if ($depth == 2) {
                    $output .= "</li>";
                }

            } elseif ($type == "banner") {
                if ($depth == 2) {
                    $output .= "</li>";
                }
            }
        } else {
            $output .= "</li>";
        }

    }

    public function start_lvl(&$output, $depth = 0, $args = array())
    {

        $indent   = str_repeat("\t", $depth);
        $bg       = "";
        $wrapper  = "";
        $start_ul = "<ul class=\"sub-menu\">\n";

        if ($depth == 0) {

            $bg = get_post_meta($this->curItemID, "bg-image", true);

            $is_mega_menu = get_post_meta($this->curItemID, "is-mega-menu", true);
            if ($is_mega_menu == 1) // Wrap mega menu of all types Of Menu
            {
                $this->megaMenuWraperID = $this->curItemID;
                $wrapper                = "<div class=\"menu-item-wrapper\">";
                if ($bg != "") {
                    $wrapper = "<div class=\"menu-item-wrapper\" style=\"background:url( " . esc_url(rad_get_image_url($bg, "full")) . ");\">";
                }

                $in_container = get_post_meta("mega-menu-container");

                if ($in_container == "0") // Wrap mega menu of all types Of Menu
                {
                    $wrapper .= "<div class=\"container\">";
                }

                $start_ul = "";
            }

        }

        $output .= "\n$indent" . $wrapper . $start_ul;

    }

    public function end_lvl(&$output, $depth = 0, $args = array())
    {
        $indent     = str_repeat("\t", $depth);
        $wrapperEnd = "";
        $end_ul     = "</ul>";

        $is_mega_menu = get_post_meta($this->megaMenuWraperID, "is-mega-menu", true);

        // Wrap Of mega menu all types Of Menu
        if ($this->megaMenuWraperID != -1 && $depth == 0 && $is_mega_menu == 1) {
            $this->megaMenuWraperID = -1; //reset saved ID
            $wrapperEnd             = "</div>";

            $in_container = rad_get_option("mega-menu-container");
            if ($in_container == "0") // Wrap mega menu of all types Of Menu
            {
                $wrapperEnd .= "</div>";
            }

            $end_ul = "";

        }

        $output .= "$indent" . $end_ul . $wrapperEnd . "\n";

    }
}

/**********************************************
 * Mobile menu nav-walker
 **********************************************/
class Rad_Mobbile_Nav_Walker extends Walker_Nav_Menu
{
    private $navIdPrefix = "";

    private $curItemID;
    private $menu_output = true;

    public function __construct($idPrefix = "menu-item-")
    {
        $this->navIdPrefix = $idPrefix;
    }

    public function start_el(&$output, $object, $depth = 0, $args = array(), $current_object_id = 0)
    {

        $this->curItemID = $object->ID;

        $type = "";
        if ($object->object == "custom") {
            $type = get_post_meta($object->ID, "_menu_item_rad_menu_type", true);
        }

        $indent = ($depth) ? str_repeat("\t", $depth) : "";

        $class_names = $value = "";

        $classes = empty($object->classes) ? array() : (array) $object->classes;
        $classes = array_slice($classes, 0);

        if ($object->object == "custom" && $type == "collection") {
            $classes[] = "collection";
        }

        //badge
        $badge          = get_post_meta($object->ID, "badge-label", true);
        $badge_bg_color = get_post_meta($object->ID, "badge-bg-color", true);

        $class_names = join(" ", apply_filters("nav_menu_css_class", array_filter($classes), $object));
        $class_names = " class=\"" . esc_attr($class_names) . "\"";

        $attributes = !empty($object->attr_title) ? " title=\"" . esc_attr($object->attr_title) . "\"" : "";
        $attributes .= !empty($object->target) ? " target=\"" . esc_attr($object->target) . "\"" : "";
        $attributes .= !empty($object->xfn) ? " rel=\"" . esc_attr($object->xfn) . "\"" : "";

        $output .= $indent . "<li " . $value . $class_names . ">";

        $attributes .= !empty($object->url) ? " href=\"" . esc_url($object->url) . "\"" : "";

        $object_output = $args->before;

        $object_output .= "<a" . $attributes . ">";

        if ($object->object == "custom" && $type == "column") {
            $column_title = get_post_meta($object->ID, "column-title", true);
            $object_output .= $args->link_before . apply_filters("the_title", $column_title, $object->ID);
        } else {
            $object_output .= $args->link_before . apply_filters("the_title", $object->title, $object->ID);
        }

        if ($badge != "") {
            $object_output .= "<span class=\"badge unselectable\"" . ($badge_bg_color != "" ? " style=\"background-color:" . esc_attr($badge_bg_color) . "\"" : "") . "> " . $badge . "</span>";
        }

        $object_output .= $args->link_after;
        $object_output .= "</a>";

        $object_output .= "" . $args->after;

        //Custom menu types
        if ($object->object == "custom" && ($type == "headline" || $type == "banner")) {
            return;
        }

        $output .= apply_filters("walker_nav_menu_start_el", $object_output, $object, $depth, $args);

    }

    public function end_el(&$output, $item, $depth = 0, $args = array())
    {
        if ($this->menu_output == false) {
            $this->menu_output = true;
            return;
        }

        $type = "";
        if ($item->object == "custom") {

        }
        //Custom menu types
        if ($item->object == "custom") {
            $type = get_post_meta($item->ID, "_menu_item_rad_menu_type", true);
            if ($type == "headline" || $type == "banner") {
                return;
            }
        }

        $output .= "</li>";
    }

    public function start_lvl(&$output, $depth = 0, $args = array())
    {
        $indent = str_repeat("\t", $depth);
        $toggle = "<span class=\"toggle_submneu\"></span>";
        $output .= "\n$indent" . $toggle . "<ul class=\"sub-menu\">\n";

    }

    public function end_lvl(&$output, $depth = 0, $args = array())
    {
        $indent = str_repeat("\t", $depth);

        $output .= "$indent</ul>" . "\n";

    }
}

/**********************************************
 * simple menu nav-walker
 **********************************************/
//A nav_walker to show menu just in depth = 0
class Rad_Simple_Nav_Walker extends Walker_Nav_Menu
{
    private $navIdPrefix = "";

    private $curItemID;

    public function __construct($idPrefix = "menu-item-")
    {
        $this->navIdPrefix = $idPrefix;
    }

    public function start_el(&$output, $object, $depth = 1, $args = array(), $current_object_id = 0)
    {

        if ($depth > 0) {
            return;
        }

        $this->curItemID = $object->ID;

        $indent = ($depth) ? str_repeat("\t", $depth) : "";

        $class_names = $value = "";

        $classes = empty($object->classes) ? array() : (array) $object->classes;
        $classes = array_slice($classes, 0);

        $class_names = join(" ", apply_filters("nav_menu_css_class", array_filter($classes), $object));
        $class_names = " class=\"" . esc_attr($class_names) . "\"";

        $attributes = !empty($object->attr_title) ? " title=\"" . esc_attr($object->attr_title) . "\"" : "";
        $attributes .= !empty($object->target) ? " target=\"" . esc_attr($object->target) . "\"" : "";
        $attributes .= !empty($object->xfn) ? " rel=\"" . esc_attr($object->xfn) . "\"" : "";

        $output .= $indent . "<li " . $value . $class_names . ">";

        $attributes .= !empty($object->url) ? " href=\"" . esc_url($object->url) . "\"" : "";

        $object_output = $args->before;

        $object_output .= "<a" . $attributes . ">";

        $object_output .= $args->link_before . apply_filters("the_title", $object->title, $object->ID);
        $object_output .= $args->link_after;
        $object_output .= "</a>";

        $object_output .= "" . $args->after;

        $output .= apply_filters("walker_nav_menu_start_el", $object_output, $object, $depth, $args);

    }

    public function end_el(&$output, $item, $depth = 0, $args = array())
    {
        if ($depth > 0) {
            return;
        }

        $output .= "</li>";
    }

    public function start_lvl(&$output, $depth = 0, $args = array())
    {
        if ($depth > 0) {
            return;
        }

        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent" . "<ul class=\"sub-menu\">\n";

    }

    public function end_lvl(&$output, $depth = 0, $args = array())
    {
        if ($depth > 0) {
            return;
        }

        $indent = str_repeat("\t", $depth);
        $output .= "$indent</ul>" . "\n";

    }

}
