<?php
/**********************************************/
/*  Separators
/**********************************************/

function rad_sc_separator($atts, $content = null)
{
    extract(shortcode_atts(array(
        "size"                 => "full", // small, small-center, medium, medium-center
        "thickness"            => "1",
        "color"                => "#888",
        "margin_bottom"        => "30",
        "margin_top"           => "30",
        "style"                => "solid",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
    ), $atts));

    $html    = "";
    $classes = array("vc_separator");
    switch ($size) {
        case "small":
            $classes[] = "sep-small";
            break;
        case "small-center":
            $classes[] = "sep-small sep-center";
            break;
        case "extra-small":
            $classes[] = "sep-extra-small";
            break;
        case "extra-small-center":
            $classes[] = "sep-extra-small sep-center";
            break;
        case "medium":
            $classes[] = "sep-medium";
            break;
        case "medium-center":
            $classes[] = "sep-medium sep-center";
            break;
        case "full":
            $classes[] = " full";
            break;
    }
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $sep_style = ($color != "") ? "border-color:" . $color . ";" : "";
    $sep_style .= ($style != "") ? "border-style:" . $style . ";" : "";
    $sep_style .= ($thickness != "") ? "border-width:" . $thickness . "px;" : "";
    $sep_style .= ($margin_top != "") ? "margin-top:" . $margin_top . "px;" : "";
    $sep_style .= ($margin_bottom != "") ? "margin-bottom:" . $margin_bottom . "px;" : "";

    $html .= rad_make_container("hr", "", "spr", implode(" ", array_filter($classes)), $sep_style, $anim_attr, false);

    return $html;
}

/**********************************************/
/*  Team Member
/**********************************************/

function rad_team_member_handler($atts, $content = null)
{

    extract(shortcode_atts(array(
        "name"                 => "JOHN DOE",
        "job_title"            => "Designer",
        "image"                => "",
        "style"                => "dark",
        "url"                  => "",
        "target"               => "_self",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
        "facebook"             => "",
        "twitter"              => "",
        "vimeo"                => "",
        "youtube"              => "",
        "google"               => "",
        "dribbble"             => "",
        "tumblr"               => "",
        "linkedin"             => "",
        "flickr"               => "",
        "github"               => "",
        "lastfm"               => "",
        "paypal"               => "",
        "rss"                  => "",
        "skype"                => "",
        "wordpress"            => "",
        "yahoo"                => "",
        "steam"                => "",
        "reddit"               => "",
        "stumbleupon"          => "",
        "pinterest"            => "",
        "deviantart"           => "",
        "xing"                 => "",
        "blogger"              => "",
        "soundcloud"           => "",
        "delicious"            => "",
        "foursquare"           => "",
        "instagram"            => "",
        "behance"              => "",
        "custom1"              => "",
        "custom2"              => "",
        "custom3"              => "",
        "custom1_name"         => "",
        "custom2_name"         => "",
        "custom3_name"         => "",
        "custom1_image"        => "",
        "custom2_image"        => "",
        "custom3_image"        => "",
    ), $atts));

    $id = rad_element_id("tm");

    if ($custom1 != "" && is_numeric($custom1_image)) {
        $custom1_image = wp_get_attachment_url($custom1_image);
    }
    if ($custom2 != "" && is_numeric($custom2_image)) {
        $custom2_image = wp_get_attachment_url($custom2_image);
    }
    if ($custom3 != "" && is_numeric($custom3_image)) {
        $custom3_image = wp_get_attachment_url($custom3_image);
    }

    $socials = array(
        "facebook"    => array(
            "name" => "facebook-f",
            "url"  => $facebook,
        ),
        "twitter"     => array(
            "name" => "twitter",
            "url"  => $twitter,
        ),
        "vimeo"       => array(
            "name" => "vimeo-v",
            "url"  => $vimeo,
        ),
        "youTube"     => array(
            "name" => "youtube",
            "url"  => $youtube,
        ),
        "google+"     => array(
            "name" => "google-plus-g",
            "url"  => $google,
        ),
        "dribbble"    => array(
            "name" => "dribbble",
            "url"  => $dribbble,
        ),
        "tumblr"      => array(
            "name" => "tumblr",
            "url"  => $tumblr,
        ),
        "linkedin"    => array(
            "name" => "linkedin-in",
            "url"  => $linkedin,
        ),
        "flickr"      => array(
            "name" => "flickr",
            "url"  => $flickr,
        ),
        "github"      => array(
            "name" => "github-alt",
            "url"  => $github,
        ),
        "last.fm"     => array(
            "name" => "lastfm",
            "url"  => $lastfm,
        ),
        "paypal"      => array(
            "name" => "paypal",
            "url"  => $paypal,
        ),
        "rss"         => array(
            "name" => "rss",
            "url"  => $rss,
        ),
        "skype"       => array(
            "name" => "skype",
            "url"  => $skype,
        ),
        "wordPress"   => array(
            "name" => "wordpress",
            "url"  => $wordpress,
        ),
        "yahoo"       => array(
            "name" => "yahoo",
            "url"  => $yahoo,
        ),
        "steam"       => array(
            "name" => "steam-symbol",
            "url"  => $steam,
        ),
        "reddit"      => array(
            "name" => "reddit-alien",
            "url"  => $reddit,
        ),
        "stumbleUpon" => array(
            "name" => "stumbleupon",
            "url"  => $stumbleupon,
        ),
        "pinterest"   => array(
            "name" => "pinterest-p",
            "url"  => $pinterest,
        ),
        "deviantArt"  => array(
            "name" => "deviantart",
            "url"  => $deviantart,
        ),
        "xing"        => array(
            "name" => "xing",
            "url"  => $xing,
        ),
        "blogger"     => array(
            "name" => "blogger-b",
            "url"  => $blogger,
        ),
        "soundCloud"  => array(
            "name" => "soundcloud",
            "url"  => $soundcloud,
        ),
        "delicious"   => array(
            "name" => "delicious",
            "url"  => $delicious,
        ),
        "foursquare"  => array(
            "name" => "foursquare",
            "url"  => $foursquare,
        ),
        "instagram"   => array(
            "name" => "instagram",
            "url"  => $instagram,
        ),
        "behance"     => array(
            "name" => "behance",
            "url"  => $behance,
        ),
        "custom1"     => array(
            "name"  => $custom1_name,
            "url"   => $custom1,
            "image" => $custom1_image,
        ),
        "custom2"     => array(
            "name"  => $custom2_name,
            "url"   => $custom2,
            "image" => $custom2_image,
        ),
        "custom3"     => array(
            "name"  => $custom3_name,
            "url"   => $custom3,
            "image" => $custom3_image,
        ),
    );

    $social_classes = array("social-icons", "horizontal", $style . "-style");
    $social_output  = rad_social_icons($id . "_sc", $socials, $social_classes, "icon");

    $html      = "";
    $classes   = array("team-member", "resp-block");
    $classes[] = $style;
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    if (is_numeric($image)) {

        $image = rad_get_image_url($image, "medium");
    }

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $html .= rad_make_container("div", "", "", "member-img-wrapper", "", "", false);
    $html .= rad_make_container("div", "", "", "member-img", "", "", false);
    if ($image) {
        $html .= "<img src=\"" . esc_url($image) . "\" alt=\"" . esc_attr($name) . "\">";
    }
    $html .= "</div>";
    $html .= rad_make_vc_url($url);
    $html .= "</div>";
    $html .= rad_make_container("div", "", "", "member-info", "", "", false);
    $html .= $social_output;
    $html .= rad_make_container("span", esc_attr($name), "", "member-name", "", "", true);
    $html .= rad_make_container("cite", esc_attr($job_title), "", "", "", "", true);
    $html .= "</div>";
    $html .= "</div>";

    return $html;
}

/**********************************************/
/* Testimonials shortcode
/**********************************************/

function rad_testimonial_handler($atts, $content = null)
{

    extract(shortcode_atts(array(
        "style"                => "Dark",
        "visible_items"        => "1",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
    ), $atts));

    $id      = rad_element_id("tst");
    $classes = array("carousel", "testimonial-block", "resp-block");
    $html    = "";

    $classes[] = ($style == "light") ? "light" : "";
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $item_attr = "data-visibleitems=\"" . esc_attr($visible_items) . "\"";

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $html .= rad_make_container("div", "", "", "swiper-container", "", $item_attr, false);
    $html .= rad_make_container("div", "", "", "swiper-wrapper", "", "", false);
    $html .= do_shortcode($content);
    $html .= "</div>";
    $html .= rad_make_container("div", "", "", "swiper-pagination", "", "", true);
    $html .= "</div>";
    $html .= "</div>";

    return $html;

}

/**********************************************/
/* Testimonial item shortcode
/**********************************************/

function rad_testimonial_item_handler($atts, $content = null)
{

    extract(shortcode_atts(array(
        "author"    => "",
        "text"      => "",
        "job"       => "",
        "image_url" => "",
    ), $atts));

    if (is_numeric($image_url)) {
        $image_url = wp_get_attachment_url($image_url);
    }

    $img_style = ($image_url != "") ? "background-image:url(" . esc_url($image_url) . ");" : "";

    $html = "";
    $html .= rad_make_container("div", "", "", "swiper-slide msg", "", "", false);
    $html .= rad_make_container("blockquote", "", "", "", "", "", false);
    $html .= rad_make_container("div", $text, "", "quote", "", "", true);
    $html .= rad_make_container("span", "", "", "img", $img_style, "", true);
    $html .= rad_make_container("div", "", "", "author", "", "", false);
    $html .= rad_make_text("h4", $author, "name", "", true);
    $html .= rad_make_container("cite", $job, "", "job", "", "", true);
    $html .= "</div>";
    $html .= "</blockquote>";
    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Pie Chart
/**********************************************/

function rad_chart_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "title"                => "",
        "title_color"          => "",
        "subtitle"             => "",
        "subtitle_color"       => "",
        "percent"              => "70",
        "percent_display"      => "enable",
        "bar_color"            => "#000",
        "track_color"          => "#eee",
        "main_color"           => "",
        "icon"                 => "",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
    ), $atts));

    $id      = rad_element_id("chrt");
    $classes = array("chart-block", "resp-block");
    $html    = "";

    $classes[] = ($percent_display != "enable") ? "no-percent" : "";
    $classes[] = ($icon == "") ? "no-icon" : "";
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    //styles
    $title_style    = ($title_color != "") ? "color:" . $title_color . ";" : "";
    $subtitle_style = ($subtitle_color != "") ? "color:" . $subtitle_color . ";" : "";
    $main_style     = ($main_color != "") ? "color:" . $main_color . ";fill:" . $main_color . ";" : "";

    $chart_attr = "data-bar-color=\"" . esc_attr($bar_color) . "\" ";
    $chart_attr .= "data-track-color=\"" . esc_attr($track_color) . "\" ";
    $chart_attr .= " data-percent=\"" . esc_attr($percent) . "\"";

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $html .= rad_make_container("div", "", "", "chart-wrapper", $main_style, $chart_attr, false);

    if ($icon) {
        $icon = explode(":", $icon);
        $html .= rad_Icon_Manager::get_icon($icon[0], $icon[1]);
    }

    if ($percent_display == "enable") {
        $html .= rad_make_container("span", $percent . "%", "", "percent");

    }
    $html .= "</div>";
    $html .= rad_make_text("span", $title, "title", $title_style);
    $html .= rad_make_text("p", $subtitle, "subtitle", $subtitle_style);
    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Horizontal progress bar
/**********************************************/

function rad_progressbar_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "title"                => "",
        "title_color"          => "",
        "percent"              => "50",
        "fill_color"           => "",
        "bar_color"            => "",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
    ), $atts));

    $id      = rad_element_id("pbr");
    $classes = array("progress-bar-block", "resp-block");
    $html    = "";

    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $title_style  = ($title_color != "") ? "color:" . $title_color . ";" : "";
    $percent_attr = "data-percentage=\"" . $percent . "\"";
    $fill_style   = ($fill_color != "") ? "background-color:" . $fill_color : "";
    $bar_style    = ($bar_color != "") ? "background-color:" . $bar_color : "";

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $html .= rad_make_text("span", $title, "title", $title_style);
    $html .= rad_make_text("span", $percent . "%", "value", $title_style);
    $html .= rad_make_container("span", "", "", "fill", $fill_style, $percent_attr);
    $html .= rad_make_container("span", "", "", "bar", $bar_style);
    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Social Icon
/**********************************************/

function rad_socials_block($atts, $content = null)
{
    extract(shortcode_atts(array(
        "facebook"      => "",
        "twitter"       => "",
        "vimeo"         => "",
        "youtube"       => "",
        "google"        => "",
        "dribbble"      => "",
        "tumblr"        => "",
        "linkedin"      => "",
        "flickr"        => "",
        "github"        => "",
        "lastfm"        => "",
        "paypal"        => "",
        "rss"           => "",
        "skype"         => "",
        "wordpress"     => "",
        "yahoo"         => "",
        "steam"         => "",
        "reddit"        => "",
        "stumbleupon"   => "",
        "pinterest"     => "",
        "deviantart"    => "",
        "xing"          => "",
        "blogger"       => "",
        "soundcloud"    => "",
        "delicious"     => "",
        "foursquare"    => "",
        "instagram"     => "",
        "behance"       => "",
        "custom1"       => "",
        "custom2"       => "",
        "custom3"       => "",
        "custom1_name"  => "",
        "custom2_name"  => "",
        "custom3_name"  => "",
        "custom1_image" => "",
        "custom2_image" => "",
        "custom3_image" => "",
        "style"         => "dark",
        "direction"     => "horizontal",
        "type"          => "icon",
        "background"    => "no",

    ), $atts));

    if ($custom1 != "" && is_numeric($custom1_image)) {
        $custom1_image = wp_get_attachment_url($custom1_image);
    }
    if ($custom2 != "" && is_numeric($custom2_image)) {
        $custom2_image = wp_get_attachment_url($custom2_image);
    }
    if ($custom3 != "" && is_numeric($custom3_image)) {
        $custom3_image = wp_get_attachment_url($custom3_image);
    }

    $socials = array(
        "facebook"    => array(
            "name" => "facebook-f",
            "url"  => $facebook,
        ),
        "twitter"     => array(
            "name" => "twitter",
            "url"  => $twitter,
        ),
        "vimeo"       => array(
            "name" => "vimeo-v",
            "url"  => $vimeo,
        ),
        "youTube"     => array(
            "name" => "youtube",
            "url"  => $youtube,
        ),
        "google+"     => array(
            "name" => "google-plus-g",
            "url"  => $google,
        ),
        "dribbble"    => array(
            "name" => "dribbble",
            "url"  => $dribbble,
        ),
        "tumblr"      => array(
            "name" => "tumblr",
            "url"  => $tumblr,
        ),
        "linkedin"    => array(
            "name" => "linkedin-in",
            "url"  => $linkedin,
        ),
        "flickr"      => array(
            "name" => "flickr",
            "url"  => $flickr,
        ),
        "github"      => array(
            "name" => "github-alt",
            "url"  => $github,
        ),
        "last.fm"     => array(
            "name" => "lastfm",
            "url"  => $lastfm,
        ),
        "paypal"      => array(
            "name" => "paypal",
            "url"  => $paypal,
        ),
        "rss"         => array(
            "name" => "rss",
            "url"  => $rss,
        ),
        "skype"       => array(
            "name" => "skype",
            "url"  => $skype,
        ),
        "wordPress"   => array(
            "name" => "wordpress",
            "url"  => $wordpress,
        ),
        "yahoo"       => array(
            "name" => "yahoo",
            "url"  => $yahoo,
        ),
        "steam"       => array(
            "name" => "steam-symbol",
            "url"  => $steam,
        ),
        "reddit"      => array(
            "name" => "reddit-alien",
            "url"  => $reddit,
        ),
        "stumbleUpon" => array(
            "name" => "stumbleupon",
            "url"  => $stumbleupon,
        ),
        "pinterest"   => array(
            "name" => "pinterest-p",
            "url"  => $pinterest,
        ),
        "deviantArt"  => array(
            "name" => "deviantart",
            "url"  => $deviantart,
        ),
        "xing"        => array(
            "name" => "xing",
            "url"  => $xing,
        ),
        "blogger"     => array(
            "name" => "blogger-b",
            "url"  => $blogger,
        ),
        "soundCloud"  => array(
            "name" => "soundcloud",
            "url"  => $soundcloud,
        ),
        "delicious"   => array(
            "name" => "delicious",
            "url"  => $delicious,
        ),
        "foursquare"  => array(
            "name" => "foursquare",
            "url"  => $foursquare,
        ),
        "instagram"   => array(
            "name" => "instagram",
            "url"  => $instagram,
        ),
        "behance"     => array(
            "name" => "behance",
            "url"  => $behance,
        ),
        "custom1"     => array(
            "name"  => $custom1_name,
            "url"   => $custom1,
            "image" => $custom1_image,
        ),
        "custom2"     => array(
            "name"  => $custom2_name,
            "url"   => $custom2,
            "image" => $custom2_image,
        ),
        "custom3"     => array(
            "name"  => $custom3_name,
            "url"   => $custom3,
            "image" => $custom3_image,
        ),
    );

    $id      = rad_element_id("sc");
    $classes = array("social-icons");
    $html    = "";

    $classes[] = $style . "-style";
    $classes[] = ($background == "yes") ? "with-bg" : "";
    $classes[] = $direction;

    $html .= rad_social_icons($id, $socials, $classes, $type);

    return $html;
}

/**********************************************/
/*  Custom Heading
/**********************************************/

function rad_custom_heading_handler($atts)
{
    extract(shortcode_atts(array(
        "title"                => "",
        "alignment"            => "center",
        "font"                 => "",
        "type"                 => "h1",
        "size"                 => "20",
        "color"                => "",
        "letter_spacing"       => "0",
        "background_style"     => "icon",
        "bg_title"             => "",
        "bg_color"             => "",
        "icon"                 => "",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
    ), $atts));

    $id      = rad_element_id("chd");
    $classes = array("custom-heading-block");
    $html    = "";

    $classes[] = $alignment;
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $title_style = ($size != "20") ? "font-size:" . $size . "px;" : "";
    $title_style .= ($font != "") ? rad_get_font_options($font, "name") : "";
    $title_style .= ($font != "") ? rad_get_font_options($font, "weight") : "";
    $title_style .= ($color != "") ? "color:" . $color . ";" : "";
    $title_style .= ($letter_spacing != "0") ? "letter-spacing:" . $letter_spacing . "px;" : "";

    $bg_title_style = ($bg_color != "") ? "color:" . $bg_color . ";fill:" . $bg_color . ";" : "";
    $bg_title_style .= ($size != "20") ? "font-size:" . ((int) $size + 20) . "px;" : "";

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $html .= rad_make_title($type, $title, "title", $title_style);

    if ($background_style == "text") {

        $html .= rad_make_container("span", $bg_title, "", "bg text", $bg_title_style);

    } elseif ($icon != "") {

        $icon = explode(":", $icon);
        $icon = rad_Icon_Manager::get_icon($icon[0], $icon[1]);
        $html .= rad_make_container("span", $icon, "", "bg icon", $bg_title_style);
    }

    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Heading
/**********************************************/

function rad_heading_handler($atts)
{
    extract(shortcode_atts(array(
        "title"                => "",
        "subtitle1"            => "",
        "subtitle2"            => "",
        "options"              => "simple",
        "alignment"            => "center",
        "title_font"           => "",
        "subs_font"            => "",
        "type"                 => "h1",
        "title_size"           => "28",
        "sub1_size"            => "15",
        "sub2_size"            => "15",
        "title_color"          => "",
        "sub1_color"           => "",
        "sub2_color"           => "",
        "title_letter_spacing" => "0",
        "sub1_letter_spacing"  => "2",
        "sub2_letter_spacing"  => "2",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
    ), $atts));

    $id      = rad_element_id("hd");
    $classes = array("heading-block");
    $html    = "";

    $classes[] = $options;
    $classes[] = $alignment;
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $title_style = ($title_size != "28") ? "font-size:" . $title_size . "px;" : "";
    $title_style .= ($title_font != "") ? rad_get_font_options($title_font, "name") : "";
    $title_style .= ($title_font != "") ? rad_get_font_options($title_font, "weight") : "";
    $title_style .= ($title_color != "") ? "color:" . $title_color . ";" : "";
    $title_style .= ($title_letter_spacing != "0") ? "letter-spacing:" . $title_letter_spacing . "px;" : "";

    $sub1_style = ($sub1_size != "15") ? "font-size:" . $sub1_size . "px;" : "";
    $sub1_style .= ($subs_font != "") ? rad_get_font_options($subs_font, "name") : "";
    $sub1_style .= ($subs_font != "") ? rad_get_font_options($subs_font, "weight") : "";
    $sub1_style .= ($sub1_color != "") ? "color:" . $sub1_color . ";" : "";
    $sub1_style .= ($sub1_letter_spacing != "0") ? "letter-spacing:" . $sub1_letter_spacing . "px;" : "";

    $sub2_style = ($sub2_size != "15") ? "font-size:" . $sub2_size . "px;" : "";
    $sub2_style .= ($subs_font != "") ? rad_get_font_options($subs_font, "name") : "";
    $sub2_style .= ($subs_font != "") ? rad_get_font_options($subs_font, "weight") : "";
    $sub2_style .= ($sub2_color != "") ? "color:" . $sub2_color . ";" : "";
    $sub2_style .= ($sub2_letter_spacing != "0") ? "letter-spacing:" . $sub2_letter_spacing . "px;" : "";

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    if ($subtitle1 != "") {

        $html .= rad_make_container("span", $subtitle1, "", "subtitle1", $sub1_style);

    }

    $html .= rad_make_title($type, $title, "title", $title_style);

    if ($subtitle2 != "") {

        $html .= rad_make_container("span", $subtitle2, "", "subtitle2", $sub2_style);

    }

    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Image-Box
/**********************************************/

function rad_banner_block($atts)
{
    extract(shortcode_atts(array(

        "banner_type"          => "general", //general,hover,creative
        "image"                => "",
        "image2"               => "",
        "title"                => "",
        "subtitle"             => "",
        "text"                 => "",
        "url"                  => "",
        "link_color"           => "", //banner_type:hover
        "color"                => "",
        "title_type"           => "h3",
        "title_size"           => "",
        "subtitle_size"        => "",
        "content_size"         => "",
        "title_font"           => "",
        "subtitle_font"        => "",
        "content_font"         => "",
        "hover_bg"             => "#000", //banner_type:hover
        "align"                => "left", //banner_type:creative
        "animation"            => "none",
        "img_animation"        => "zoom-in",
        "delay"                => "0",
        "responsive_animation" => "disable",

    ), $atts));

    if (is_numeric($image)) {
        $image = wp_get_attachment_image($image, "full", false, array("class" => "main-img", "alt" => $title));
    } else {
        $image = "";
    }

    if ($banner_type == "creative" && is_numeric($image2)) {
        $image2 = wp_get_attachment_image($image2, "full", false, array("class" => "", "alt" => $title));
    } else {
        $image2 = "";
    }

    $image  = str_replace("loading=\"lazy\"", "", $image);
    $image2 = str_replace("loading=\"lazy\"", "", $image2);

    $id      = rad_element_id("bnr");
    $classes = array("banner-block");
    $html    = "";

    $classes[] = $banner_type . "-style";
    $classes[] = $align;
    $classes[] = ($image2 == "" & $banner_type == "creative") ? "no-sec-img" : "";
    $classes[] = ($img_animation != "none") ? "img-anim img-anim-" . $img_animation : "";
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $img_container_cass   = array("img-container");
    $img_container_cass[] = ($img_animation != "none") ? "target-img-anim" : "";

    $title_style = ($title_size != "") ? "font-size:" . $title_size . "px;" : "";
    $title_style .= rad_get_font_options($title_font, "weight");
    $title_style .= rad_get_font_options($title_font, "name");

    $subtitle_style = ($subtitle_size != "") ? "font-size:" . $subtitle_size . "px;" : "";
    $subtitle_style .= rad_get_font_options($subtitle_font, "weight");
    $subtitle_style .= rad_get_font_options($subtitle_font, "name");

    $text_style = ($content_size != "") ? "font-size:" . $content_size . "px;" : "";
    $text_style .= rad_get_font_options($content_font, "weight");
    $text_style .= rad_get_font_options($content_font, "name");

    $content_style = ($color != "") ? "color:" . $color . ";" : "";
    $content_style = ($content_style != "") ? " style=\"" . $content_style . "\"" : "";

    $link_style = ($link_color != "") ? "color:" . $link_color . ";" : "";
    $link_style .= $text_style;

    // Prevent from printing style in front side of site. We add styles in front side by another way.
    if ($link_color != "" && print_element_style()) {
        $html .= "<style>";
        $html .= "#" . $id . " a:after { background-color:" . $link_color . ";}";
        $html .= "</style>";
    }

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $html .= rad_make_container("div", "", "", implode(" ", array_filter($img_container_cass)), "", "", false);
    $html .= rad_make_container("div", "", "", "img-wrap", "", "", false);
    $html .= $image;
    $html .= "</div></div>";
    if ($image2 != "") {
        $img_container_cass[] = "sec-img";
        $html .= rad_make_container("div", "", "", implode(" ", array_filter($img_container_cass)), "", "", false);
        $html .= $image2;
        $html .= "</div>";
    }

    if ($banner_type == "hover") {
        $html .= rad_make_container("span", "", "", "overlay", "background-color:" . $hover_bg, "", true);
        $html .= rad_make_text("span", $subtitle, "subtitle", $subtitle_style);
    }

    $html .= "<div class=\"text\"" . $content_style . ">";
    if ($banner_type == "general" || $banner_type == "creative") {
        $html .= rad_make_text("span", $subtitle, "subtitle", $subtitle_style);
    }
    $html .= rad_make_title($title_type, $title, "title", $title_style);
    $html .= rad_make_text("p", $text, "", $text_style);
    $html .= rad_make_vc_url($url, "", "underline-style init-show", $link_style);
    $html .= "</div>";
    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Advance marquee
/**********************************************/

function rad_marquee_handler($atts)
{
    extract(shortcode_atts(array(
        "image"       => "",
        "title"       => "",
        "front_color" => "",
        "back_color"  => "",
        "size"        => "30",
        "style"       => "simple",
        "font"        => "theme_default",
        "speed"       => "4",
    ), $atts));

    $id      = rad_element_id("mqe");
    $classes = array("marquee-block");
    $html    = "";

    if ($style == "image" && is_numeric($image)) {
        $image = wp_get_attachment_image($image, "full", false, array("alt" => $title));
    } else {
        $image = "";
    }

    $title_style = rad_get_font_options($font, "weight");
    $title_style .= rad_get_font_options($font, "name");
    $title_style .= ($size != "") ? "font-size:" . $size . "vw;" : "";
    $title_style .= ($style == "simple") ? "height:" . (intval($size * 1.5)) . "vw;" : "height:auto;";

    $animation_duration = "animation-duration:" . (strlen($title) * intval($speed)) . "s";

    $front_style = ($front_color != "") ? "color:" . $front_color . ";" : "";
    $front_style .= $animation_duration;
    $back_style = ($back_color != "") ? "color:" . $back_color . ";" : "";
    $back_style .= $animation_duration;

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), $title_style, "", false);
    $html .= rad_make_container("div", "", "", "front-wrap", "", "", false);
    $html .= $image;
    $html .= rad_make_container("span", "", "", "front-text", "", "", false);
    $html .= rad_make_container("span", "", "", "m-text", $front_style, "", false);
    $html .= rad_make_container("span", str_repeat($title . "<span class=\"m-space\"></span>", 4), "", "", "", "", true);
    $html .= rad_make_container("span", str_repeat($title . "<span class=\"m-space\"></span>", 4), "", "", "", "", true);
    $html .= "</span></span></div>";
    $html .= rad_make_container("span", "", "", "m-text", $back_style, "", false);
    $html .= rad_make_container("span", str_repeat($title . "<span class=\"m-space\"></span>", 4), "", "", "", "", true);
    $html .= rad_make_container("span", str_repeat($title . "<span class=\"m-space\"></span>", 4), "", "", "", "", true);
    $html .= "</span></div>";

    return $html;
}

/**********************************************/
/*  Icon block
/**********************************************/

function rad_icon_block_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "icon"                    => "",
        "position"                => "top",
        "alignment"               => "center",
        "size"                    => "35",
        "roundness"               => "0",
        "title"                   => "",
        "text"                    => "",
        "text_size"               => "14",
        "title_size"              => "20",
        "title_font"              => "",
        "text_font"               => "",
        "title_color"             => "",
        "text_color"              => "",
        "icon_color"              => "",
        "icon_bg_color"           => "",
        "icon_border_color"       => "",
        "icon_hover_color"        => "",
        "icon_hover_bg_color"     => "",
        "icon_hover_border_color" => "",
        "animation"               => "none",
        "delay"                   => "0",
        "responsive_animation"    => "disable",
    ), $atts));

    $id      = rad_element_id("icn");
    $classes = array("icon-block", "clearfix", "resp-block");
    $html    = "";

    if ($icon == "") {
        return;
    } else {
        $icon = explode(":", $icon);
    }

    $classes[] = $position;
    if ($position == "top") {
        $classes[] = $alignment . "-align";
    }
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $text_style = ($text_color != "") ? "color:" . $text_color . ";" : "";
    $text_style .= ($text_size != "12") ? "font-size:" . $text_size . "px;" : "";
    $text_style .= rad_get_font_options($text_font, "weight");
    $text_style .= rad_get_font_options($text_font, "name");

    $title_style = ($title_color != "") ? "color:" . $title_color . ";" : "";
    $title_style .= ($title_size != "20") ? "font-size:" . $title_size . "px;" : "";
    $title_style .= rad_get_font_options($title_font, "weight");
    $title_style .= rad_get_font_options($title_font, "name");

    $style_atts = array(
        "size"                    => "35",
        "text_size"               => "14",
        "title_size"              => "20",
        "roundness"               => "0",
        "icon_color"              => "",
        "icon_bg_color"           => "",
        "icon_border_color"       => "",
        "icon_hover_color"        => "",
        "icon_hover_bg_color"     => "",
        "icon_hover_border_color" => "",
    );

    $has_style = rad_has_custom_style($style_atts, $atts);

    // Prevent from printing style in front side of site. We add styles in front side by another way.
    if ($has_style && print_element_style()) {
        $html .= "<style>";

        if ($size != "35") {
            $html .= "#" . $id . " svg {";
            $html .= "width:" . $size . "px;";
            $html .= "}";
            $html .= "#" . $id . " .icon {";
            $html .= "width:" . ((int) $size + 30) . "px;";
            $html .= "height:" . ((int) $size + 30) . "px;";
            $html .= "}";
        }

        if ($icon_color != "") {
            $html .= "#" . $id . " .icon {";
            if ($icon_color != "") {
                $html .= "fill:" . $icon_color . ";";
                $html .= "width:" . ((int) $size + 55) . "px;";
                $html .= "height:" . ((int) $size + 55) . "px;";
            }
            $html .= "}";
        }

        if ($icon_bg_color != "" || $icon_border_color != "" || $roundness != "0") {
            $html .= "#" . $id . " .icon-bg {";
            if ($icon_bg_color != "") {
                $html .= "background:" . $icon_bg_color . ";";
            }

            if ($icon_border_color != "") {
                $html .= "border-color:" . $icon_border_color . ";";
            }

            if ($roundness != "0") {
                $html .= "border-radius:" . $roundness . "px;";
            }

            $html .= "}";
        }

        if ($icon_hover_color != "") {
            $html .= "#" . $id . ":hover .icon {";
            $html .= "fill:" . $icon_hover_color . ";";
            $html .= "}";
        }

        if ($icon_hover_bg_color != "" || $icon_hover_border_color != "") {
            $html .= "#" . $id . ":hover .icon-bg {";
            if ($icon_hover_bg_color != "") {
                $html .= "background:" . $icon_hover_bg_color . ";";

            }

            if ($icon_hover_border_color != "") {
                $html .= "border-color:" . $icon_hover_border_color . ";";

            }
            $html .= "}";
        }
        $html .= "</style>";
    }

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $html .= rad_make_container("div", "", "", "icon", "", "", false);
    $html .= rad_make_container("span", "", "", "icon-bg", "", "", true);
    $html .= rad_Icon_Manager::get_icon($icon[0], $icon[1]);
    $html .= "</div>";
    $html .= rad_make_container("div", "", "", "content", "", "", false);
    $html .= rad_make_title("h4", $title, "", $title_style, "", true);
    $html .= rad_make_text("p", wp_kses($text, rad_get_allowed_tags()), "", $text_style);
    $html .= "</div>";
    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Countdown
/**********************************************/

function rad_sc_countdown($atts, $content = null)
{
    extract(shortcode_atts(array(
        "end_date"             => "",
        "fontsize"             => "28",
        "color"                => "",
        "label_color"          => "",
        "alignment"            => "center",
        "animation"            => "none",
        "delay"                => "1000",
        "responsive_animation" => "disable",
    ), $atts));

    if ($end_date == "") {
        return;
    }

    $id = rad_element_id("cnt");

    $class = array("countdown-timer", "resp-block");

    if ($animation != "none") {
        $class[] = "elem-anim";

        if ($responsive_animation != "") {
            $class[] = "no-resp-anim";
        }
    }

    switch ($alignment) {
        case "right":
            $class[] = "right";
            break;
        case "center":
            $class[] = "center";
            break;
        case "left":
            $class[] = "left";
            break;
    }

    ob_start();

    ?>

    <div id="<?php echo esc_attr($id); ?>" class="<?php echo implode(" ", $class); ?>" <?php if (strlen(esc_attr($animation))) {?> data-delay="<?php echo esc_attr($delay); ?>" data-animation="<?php echo esc_attr($animation); ?>" <?php }?> data-end="<?php echo esc_attr($end_date); ?>" style="font-size:<?php echo esc_attr($fontsize); ?>px">
        <div class="time-block">
            <span class="days number" <?php if ($color) {echo "style=\"color:" . $color . "\"";}?>>0</span>
            <span class="label" <?php if ($label_color) {echo "style=\"color:" . $label_color . "\"";}?>><?php echo esc_html__("Days", "aventa"); ?></span>
        </div>
        <div class="time-block">
            <span class="hours number" <?php if ($color) {echo "style=\"color:" . $color . "\"";}?>>0</span>
            <span class="label" <?php if ($label_color) {echo "style=\"color:" . $label_color . "\"";}?>><?php echo esc_html__("Hours", "aventa"); ?></span>
        </div>
        <div class="time-block">
            <span class="minutes number" <?php if ($color) {echo "style=\"color:" . $color . "\"";}?>>0</span>
            <span class="label" <?php if ($label_color) {echo "style=\"color:" . $label_color . "\"";}?>><?php echo esc_html__("Mins", "aventa"); ?></span>
        </div>
        <div class="time-block">
            <span class="seconds number" <?php if ($color) {echo "style=\"color:" . $color . "\"";}?>>0</span>
            <span class="label" <?php if ($label_color) {echo "style=\"color:" . $label_color . "\"";}?>><?php echo esc_html__("Secs", "aventa"); ?></span>
        </div>
    </div>

    <?php
return ob_get_clean();
}

/**********************************************/
/*  Counter block
/**********************************************/

function rad_counter_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "number"               => "500",
        "number_color"         => "",
        "title"                => esc_html__("title", "aventa"),
        "description"          => esc_html__("Description", "aventa"),
        "number_color"         => "",
        "title_color"          => "",
        "text_color"           => "",
        "animation"            => "none",
        "delay"                => "1000",
        "responsive_animation" => "disable",
    ), $atts));

    $id      = rad_element_id("cntr");
    $classes = array("counter-block", "resp-block");
    $html    = "";

    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $title_style  = ($title_color != "") ? "color:" . $title_color . ";" : "";
    $text_style   = ($text_color != "") ? "color:" . $text_color . ";" : "";
    $number_style = ($number_color != "") ? "color:" . $number_color . ";" : "";
    $number       = intval($number);

    $counter_attr = "data-count-num=\"" . esc_attr($number) . "\"";

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr . " " . $counter_attr, false);
    $html .= rad_make_container("span", "0", "", "number", $number_style);
    $html .= rad_make_text("h5", $title, "title", $title_style);
    $html .= rad_make_text("span", $description, "desc", $text_style);
    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Embed Video
/**********************************************/

function rad_sc_embed_video($atts)
{
    extract(shortcode_atts(array(

        "video_display_type"      => "local_video",
        "video_autoplay"          => "enable",
        "video_poster_image"      => "",
        "video_background_image"  => "",
        "video_webm"              => "",
        "video_mp4"               => "",
        "video_ogv"               => "",
        "video_vimeo_id"          => "",
        "video_youtube_id"        => "",
        "alignment"               => "center",
        "video_play_button_color" => "light",
        "animation"               => "none",
        "delay"                   => "0",
        "responsive_animation"    => "disable",
        "loop"                    => "no",
        "el_aspect"               => "169",
        "text"                    => "", // Just used in Product detail video ( not included in VC )
    ), $atts));

    $class[] = "";

    switch ($alignment) {
        case "right":
            $class[] = " right";
            break;
        case "center":
            $class[] = " center";
            break;
        case "left":
            $class[] = " left";
            break;
    }

    if ($video_display_type == "local_video" || $video_display_type == "local_video_popup") {
        if ($video_webm == "" && $video_mp4 == "" && $video_ogv == "") {
            return;
        }
    } elseif ($video_display_type == "embeded_video_vimeo" || $video_display_type == "embeded_video_vimeo_popup") {
        if ($video_vimeo_id == "") {
            return;
        }
    } elseif ($video_display_type == "embeded_video_youtube" || $video_display_type == "embeded_video_youtube_popup") {
        if ($video_youtube_id == "") {
            return;
        }
    }

    /* Video ID extractor*/
    $vimeoURL = $video_vimeo_id;
    $vimeoId  = preg_replace("/[^0-9]/", "", $vimeoURL);

    // detect youtube id form url
    $youtubeURL = $video_youtube_id;
    
    if ($youtubeURL && ($video_display_type == "embeded_video_youtube_popup" || $video_display_type == "embeded_video_youtube")) {

        $pattern = '#^(?:https?://)?';    # Optional URL scheme. Either http or https.
        $pattern .= '(?:www\.)?';         #  Optional www subdomain.
        $pattern .= '(?:';                #  Group host alternatives:
        $pattern .=   'youtu\.be/';       #    Either youtu.be,
        $pattern .=   '|youtube\.com';    #    or youtube.com
        $pattern .=   '(?:';              #    Group path alternatives:
        $pattern .=     '/embed/';        #      Either /embed/,
        $pattern .=     '|/v/';           #      or /v/,
        $pattern .=     '|/watch\?v=';    #      or /watch?v=,    
        $pattern .=     '|/watch\?.+&v='; #      or /watch?other_param&v=
        $pattern .=   ')';                #    End path alternatives.
        $pattern .= ')';                  #  End host alternatives.
        $pattern .= '([\w-]{11})';        # 11 characters (Length of Youtube video ids).
        $pattern .= '(?:.+)?$#x';         # Optional other ending URL parameters.
        preg_match($pattern, $youtubeURL, $matches);
        $youtubeId = (isset($matches[1])) ? $matches[1] : false;

        if($youtubeId == false)
        {
            echo "<p>". esc_html__("The video URL cannot be parsed" , "aventa") ."</p>";
        }
    }

    if (is_numeric($video_background_image)) {
        $video_background_image = rad_get_image_url($video_background_image, "full");
    }

    if (is_numeric($video_poster_image)) {
        $video_poster_image = rad_get_image_url($video_poster_image, "full");
    }

    $id = rad_element_id("vd");

    ob_start();

    $attributes = "";
    if ($video_display_type == "local_video_popup") {
        $attributes = " preload=\"none\"";
    } elseif ($video_display_type == "local_video") {
        $attributes = " preload=\"auto\"";
    }

    if ($video_poster_image) {
        $attributes .= " poster=\"" . esc_url($video_poster_image) . "\"";
    }

    if ($loop == "yes") {
        $attributes .= " loop";
    }

    if ($video_autoplay == "enable" && $video_display_type == "local_video") {
        $attributes .= " autoplay muted";
    }

    ?>

    <?php if ($video_display_type == "local_video_popup") {?>

        <!-- Hidden video div -->
        <div style="display:none;" id="video<?php echo esc_attr($id); ?>">
            <video class="lg-video-object lg-html5 video-js vjs-default-skin"<?php echo " " . $attributes; //validated before echo   ?>>

                <?php if (esc_url($video_webm)) {?>
                    <source src="<?php echo esc_url($video_webm); ?>" type="video/webm">
                <?php }?>

                <?php if (esc_url($video_mp4)) {?>
                    <source src="<?php echo esc_url($video_mp4); ?>" type="video/mp4">
                <?php }?>

                <?php if (esc_url($video_ogv)) {?>
                    <source src="<?php echo esc_url($video_ogv); ?>" type="video/ogv">
                <?php }?>

            </video>
        </div>

    <?php }?>

    <?php if ($video_display_type == "local_video_popup" || $video_display_type == "embeded_video_youtube_popup" || $video_display_type == "embeded_video_vimeo_popup") {
        ?>

        <div id="<?php echo esc_attr($id); ?>" class="video_embed_container <?php if ($animation != "none") {?>  elem-anim <?php if ($responsive_animation != "") {echo " no-resp-anim";}}?>" <?php if (strlen(esc_attr($animation))) {?> data-delay="<?php echo esc_attr($delay); ?>" data-animation="<?php echo esc_attr($animation); ?>" <?php }?>>

            <?php if ($video_display_type == "local_video_popup") {
            ?>


                <!-- data-src should not be provided when you use html5 videos -->
                <a data-html="#video<?php echo esc_attr($id); ?>">

                    <?php if (esc_url($video_background_image)) {?>
                        <img src="<?php echo esc_url($video_background_image); ?>" alt="<?php echo esc_attr__("Video", "aventa"); ?>" />
                    <?php }?>

                    <div class="play-button <?php echo esc_attr($video_play_button_color);
            echo esc_attr(implode(" ", array_filter($class))); ?>">
                        <?php echo rad_Icon_Manager::get_icon("caret-right", "light"); ?>
                    </div>
                    <?php
        if ($text != "") {
                echo "<span class=\"text\">" . $text . "</span>";
            }

            ?>

                </a>

            <?php } else if ($video_display_type == "embeded_video_youtube_popup") {
            ?>

                <!-- Youtube popUp -->
                <a class="image" href="https://youtu.be/<?php echo str_replace("http://",'', esc_url($youtubeId)); ?>">

                    <?php if (esc_url($video_background_image)) {?>
                        <img src="<?php echo esc_url($video_background_image); ?>" alt="<?php echo esc_attr__("Video", "aventa"); ?>" />
                    <?php }?>

                     <div class="play-button <?php echo esc_attr($video_play_button_color); ?>">
                        <?php echo rad_Icon_Manager::get_icon("caret-right", "light"); ?>
                    </div>
                    <?php
            if ($text != "") {
                echo "<span class=\"text\">" . $text . "</span>";
            }

            ?>

                </a>

            <?php } else if ($video_display_type == "embeded_video_vimeo_popup") {
            ?>

                <!-- Vimeo popUp -->
                <a class="image" href="https://vimeo.com/<?php echo esc_url($vimeoId); ?>" >

                    <?php if (esc_url($video_background_image)) {?>
                        <img src="<?php echo esc_url($video_background_image); ?>" alt="<?php echo esc_attr__("Video", "aventa"); ?>" />
                    <?php }?>

                     <div class="play-button <?php echo esc_attr($video_play_button_color); ?>">
                        <?php echo rad_Icon_Manager::get_icon("caret-right", "light"); ?>
                    </div>
                    <?php
            if ($text != "") {
                echo "<span class=\"text\">" . $text . "</span>";
            }

            ?>

                </a>

            <?php }?>

        </div>

        <?php }?>

        <?php
        if ($video_display_type == "local_video") {?>

        <!-- HTML5 Video popUp -->
        <div class="inline_video video_embed_container">
            <video id="<?php echo esc_attr($id); ?>-player" class="video" width="320" height="240"<?php echo " " . $attributes; //validated   ?>>

                <?php if (esc_url($video_webm)) {?>
                    <source src="<?php echo esc_url($video_webm); ?>" type="video/webm">
                <?php }?>

                <?php if (esc_url($video_mp4)) {?>
                    <source src="<?php echo esc_url($video_mp4); ?>" type="video/mp4">
                <?php }?>

                <?php if (esc_url($video_ogv)) {?>
                    <source src="<?php echo esc_url($video_ogv); ?>" type="video/ogv">
                <?php }?>

                <object width="320" height="240" type="application/x-shockwave-flash" data="<?php echo RAD_THEME_ASSETS_URI; ?>/js/flashmediaelement.swf">
                    <param name="movie" value="<?php echo RAD_THEME_ASSETS_URI; ?>/js/flashmediaelement.swf" />
                    <param name="flashvars" value="controls=true&file="<?php echo esc_url($video_mp4); ?>" />

                    <?php if ($video_poster_image) {?>

                        <img src="<?php echo esc_url($video_poster_image); ?>" width="1920" height="800" title="<?php esc_attr_e("No video playback capabilities", "aventa")?>" alt="<?php esc_attr_e("Video thumb", "aventa")?>" />

                    <?php }?>

                </object>
            </video>

            <?php if (esc_attr($video_poster_image)) {?>

                <div class="play-button <?php echo esc_attr($video_play_button_color); ?>">
                    <?php echo rad_Icon_Manager::get_icon("caret-right", "solid"); ?>
                </div>

            <?php }?>


        </div>

        <?php
        } else if ($video_display_type == "embeded_video_vimeo") {
        ?>

        <div id="<?php echo esc_attr($id); ?>">

            <?php
        $video_w   = 500;
        $video_h   = 310; //1.61 golden ratio
        $link      = "https://vimeo.com/" . $vimeoId;
        $el_aspect = "vc_video-aspect-ratio-" . $el_aspect;
        global $wp_embed;

        $embed = $wp_embed->run_shortcode("[embed  width=\"" . esc_attr($video_w) . "\" height=\"" . esc_attr($video_h) . "\"]" . $link . "[/embed]");
        ?>

            <div class="wpb_video_widget wpb_content_element vc_clearfix <?php echo esc_attr($el_aspect); ?>">
                <div class="wpb_wrapper">
                    <div class="wpb_video_wrapper"> <?php echo "" . $embed; //validated   ?> </div>
                </div>
            </div>
        </div>

        <?php } else if ($video_display_type == "embeded_video_youtube") {
        ?>

        <div id="<?php echo esc_attr($id); ?>">

            <?php
        $el_aspect = "vc_video-aspect-ratio-169";
        ?>

            <div class="wpb_video_widget wpb_content_element vc_clearfix <?php echo esc_attr($el_aspect); ?>">
                <div class="wpb_wrapper">
                    <div class="wpb_video_wrapper">
                        <iframe title="<?php esc_attr_e("YouTube video player", "aventa")?>" src="https://www.youtube.com/embed/<?php echo str_replace("http://",'', esc_url($youtubeId)); ?>" allowfullscreen></iframe>
                    </div>
                </div>
            </div>
        </div>

        <?php }

    return ob_get_clean();
}

/**********************************************/
/*  Audio SoundCloud
/**********************************************/

function rad_sc_audio_soundcloud($atts, $content = null)
{
    extract(shortcode_atts(array(
        "soundcloud_id"     => "",
        "soundcloud_height" => "auto",
        "soundcloud_style"  => "full_width_thumbnail",
        "soundcloud_color"  => "",
    ), $atts));

    $id = rad_element_id("snd");?>

    <?php
    ob_start();
    ?>

    <div class="soundcloud_shortcode" id="<?php echo esc_attr($id); ?>">
    <?php
    if (esc_attr($soundcloud_style) == "full_width_thumbnail") {
        echo "<iframe width=\"100%\" height=\"" . esc_attr($soundcloud_height) . "\" src=\"https://w.soundcloud.com/player/?url=" . esc_url($soundcloud_id) . "&amp;visual=true\"></iframe>";
    } else {
        echo "<iframe width=\"100%\" src=\"https://w.soundcloud.com/player/?url=" . esc_url($soundcloud_id) . "&amp;color=" . str_replace("#", "", esc_attr($soundcloud_color)) . "\"></iframe>";
    }?>
    </div>

    <?php
    return ob_get_clean();
}

/**********************************************/
/*  Tabs
/**********************************************/

function rad_tab_group_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "icon_position"        => "top",
        "active_section"       => "1",
        "align"                => "center",
        "style"                => "color",
        "title"                => "",
        "font"                 => "",
        "type"                 => "h1",
        "size"                 => "20",
        "letter_spacing"       => "0",
        "color"                => "",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
    ), $atts));

    //Fetch All sections
    do_shortcode($content);
    $tabs = isset($GLOBALS["rad_tta"]) ? $GLOBALS["rad_tta"] : array();
    unset($GLOBALS["rad_tta"]);

    $active_section = (int) $active_section;

    $id      = rad_element_id("tb");
    $classes = array("tab-block", "resp-block");
    $html    = "";

    $classes[] = "i-" . $icon_position;
    $classes[] = $align;
    $classes[] = $style . "-style";
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $tab_style = ($color != "") ? "border-color:" . $color . ";color:" . $color . ";" : "";

    $title_style = ($size != "20") ? "font-size:" . $size . "px;" : "";
    $title_style .= ($font != "") ? "font-family:" . $font . ";" : "";
    $title_style .= ($color != "") ? "color:" . $color . ";" : "";
    $title_style .= ($letter_spacing != "0") ? "letter-spacing:" . $letter_spacing . "px;" : "";

    $counter       = 1;
    $tabs_nav_html = $tabs_html = "";
    foreach ($tabs as $tab) {
        $active_class = "";

        if ($counter == $active_section) {
            $active_class = "active";
        }

        $tabs_nav_html .= "<li class=\"" . $active_class . "\" data-id=\"" . esc_attr($counter - 1) . "\">";

        if ($tab["icon"] != "") {
            $icon = explode(":", $tab["icon"]);
            $icon = rad_Icon_Manager::get_icon($icon[0], $icon[1]);
            if ($icon_position == "right") {
                $tabs_nav_html .= esc_html($tab["title"]) . $icon;
            } else {
                $tabs_nav_html .= $icon . esc_html($tab["title"]);
            }
        } else {
            $tabs_nav_html .= esc_html($tab["title"]);
        }

        $tabs_nav_html .= "</li>";
        $tabs_html .= rad_make_container("div", wpb_js_remove_wpautop($tab["content"]), "", "tab-content " . $active_class);

        $counter++;
    }

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $html .= rad_make_title($type, $title, "title", $title_style);
    $html .= rad_make_container("ul", "", "", "tab-nav", $tab_style, "", false);
    $html .= $tabs_nav_html;
    $html .= "</ul>";
    $html .= rad_make_container("div", "", "", "tab-contents", "", "", false);
    $html .= $tabs_html;
    $html .= "</div>";
    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Tours
/**********************************************/

function rad_tour_group_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "icon_position"        => "right",
        "active_section"       => "1",
        "align"                => "left",
        "style"                => "color",
        "color"                => "",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
    ), $atts));

    //Fetch All sections
    do_shortcode($content);
    $tabs = isset($GLOBALS["rad_tta"]) ? $GLOBALS["rad_tta"] : array();
    unset($GLOBALS["rad_tta"]);

    $active_section = (int) $active_section;

    $id      = rad_element_id("tr");
    $classes = array("tour-block", "tab-block", "resp-block");
    $html    = "";

    $classes[] = "i-" . $icon_position;
    $classes[] = $align;
    $classes[] = $style . "-style";
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $tab_style = ($color != "") ? "color:" . $color . ";" : "";

    $counter       = 1;
    $tabs_nav_html = $tabs_html = "";
    foreach ($tabs as $tab) {
        $active_class = "";

        if ($counter == $active_section) {
            $active_class = "active";
        }

        $tabs_nav_html .= "<li class=\"" . $active_class . "\" data-id=\"" . esc_attr($counter - 1) . "\">";

        if ($tab["icon"] != "") {
            $icon = explode(":", $tab["icon"]);
            $icon = rad_Icon_Manager::get_icon($icon[0], $icon[1]);
            if ($icon_position == "right") {
                $tabs_nav_html .= esc_html($tab["title"]) . $icon;
            } else {
                $tabs_nav_html .= $icon . esc_html($tab["title"]);
            }
        } else {
            $tabs_nav_html .= esc_html($tab["title"]);
        }

        $tabs_nav_html .= "</li>";
        $tabs_html .= rad_make_container("div", wpb_js_remove_wpautop($tab["content"]), "", "tab-content " . $active_class);

        $counter++;
    }

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $html .= rad_make_container("ul", "", "", "tab-nav", $tab_style, "", false);
    $html .= $tabs_nav_html;
    $html .= "</ul>";
    $html .= rad_make_container("div", "", "", "tab-contents", "", "", false);
    $html .= $tabs_html;
    $html .= "</div>";
    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Accordion
/**********************************************/

function rad_accordion_group_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "active_section"       => "1",
        "icon_position"        => "left",
        "allow_collapse_all"   => "",
        "align"                => "left",
        "color"                => "",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
    ), $atts));

    //Fetch All sections
    do_shortcode($content);
    $tabs = isset($GLOBALS["rad_tta"]) ? $GLOBALS["rad_tta"] : array();
    unset($GLOBALS["rad_tta"]);

    $active_section = (int) $active_section;
    $id             = rad_element_id("acr");
    $classes        = array("accordion-block", "resp-block");
    $html           = "";

    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $section_style = ($color != "") ? "color:" . $color . ";" : "";

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $counter = 1;
    foreach ($tabs as $tab) {

        $title = $tab["title"];

        if ($tab["icon"] != "") {
            $icon  = explode(":", $tab["icon"]);
            $icon  = rad_Icon_Manager::get_icon($icon[0], $icon[1]);
            $title = $icon . $title;
        }

        $class = $align;
        $class .= " icon-$icon_position";
        if ($counter == $active_section) {
            $class .= " open";
        }

        if ($allow_collapse_all == "true") {
            $class .= " allow-collapse-all";
        }

        $html .= rad_make_container("div", "", "", "toggle-block accordion " . $class, "", "", false);
        $html .= rad_make_container("span", $title, "", "title", $section_style, "");
        $html .= rad_make_container("div", wpb_js_remove_wpautop($tab["content"]), "", "toggle-content");
        $html .= "</div>";

        $counter++;

    }

    $html .= "</div>";

    return $html;
}
/**********************************************/
/*  TTA section - a section for Tab, Tour Accordion
/**********************************************/

function rad_tta_handler($atts, $content = null)
{
    $tab_num = (isset($GLOBALS["rad_tta"])) ? count($GLOBALS["rad_tta"]) + 1 : 1;

    extract(shortcode_atts(array(
        "title"    => esc_html__("Section", "aventa") . " " . $tab_num,
        "add_icon" => "",
        "icon"     => "",
        "el_class" => "",
    ), $atts));

    $GLOBALS["rad_tta"][] = array(
        "title"   => $title,
        "icon"    => ($add_icon == "true") ? $icon : "",
        "content" => do_shortcode($content),
    );
}

/**********************************************/
/*  Button
/**********************************************/

function rad_button_block($atts, $content = null)
{
    extract(shortcode_atts(array(
        "url"                  => "#",
        "size"                 => "standard",
        "text_color"           => "",
        "show"                 => "first",
        "border_color"         => "",
        "background_color"     => "",
        "text_hover_color"     => "",
        "border_hover_color"   => "",
        "bg_hover_color"       => "",
        "alignment"            => "left",
        "position"             => "block",
        "icon"                 => "",
        "icon_position"        => "right",
        "border_radius"        => "0px",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
        "css"                  => "", // css editor option(Design tab)
    ), $atts));

    $style_atts = array(
        "text_color"         => "",
        "border_color"       => "",
        "background_color"   => "",
        "text_hover_color"   => "",
        "border_hover_color" => "",
        "bg_hover_color"     => "",
        "border_radius"      => "0px",
    );

    $id = rad_element_id("bt");

    $class     = array("rad-button", "resp-block");
    $class[]   = "button-" . $size;
    $class[]   = $show;
    $class[]   = "button-" . $alignment;
    $class[]   = "button-" . $position;
    $class[]   = ($icon != "") ? "has-icon " . $icon_position . "-icon" : "";
    if(defined('VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG'))
    {
        $class[]   = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($css, " "), "rad_button", $atts);
    }
    
    $class[]   = ($animation != "none") ? "elem-anim" : "";
    $class[]   = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $has_style = rad_has_custom_style($style_atts, $atts);

    $link = rad_make_vc_url($url);
    $html = "";

    if ($url != "" && function_exists("vc_build_link")) {
        // Prevent from printing style in front side of site. We add styles in front side by another way.
        if ($has_style && print_element_style()) {

            $html .= "<style>";

            if ($text_color != "" || $background_color != "" || $border_color != "" || $border_radius != "0px") {
                $html .= "#" . $id . ".rad-button {";
                if ($text_color != "") {
                    $html .= "color:" . esc_attr($text_color) . ";";
                    $html .= "fill:" . esc_attr($text_color) . ";";
                }

                if ($background_color != "") {
                    $html .= "background-color:" . esc_attr($background_color) . ";";
                }

                if ($border_color != "") {
                    $html .= "border-color:" . esc_attr($border_color) . ";";
                }

                if ($border_radius != "0px") {
                    $html .= "border-radius:" . esc_attr($border_radius) . ";";
                }

                $html .= "}";
            }

            if ($text_hover_color != "" || $bg_hover_color != "" || $border_hover_color != "") {
                $html .= "#" . $id . ".rad-button:hover {";
                if ($text_hover_color != "") {
                    $html .= "color:" . esc_attr($text_hover_color) . ";";
                    $html .= "fill:" . esc_attr($text_hover_color) . ";";
                }

                if ($bg_hover_color != "") {
                    $html .= "background-color:" . esc_attr($bg_hover_color) . ";";
                }

                if ($border_hover_color != "") {
                    $html .= "border-color:" . esc_attr($border_hover_color) . ";";
                }
                $html .= "}";
            }

            $html .= "</style>";

        }

        $link = vc_build_link($url);
        if ($link["url"] != "") {

            $title = ($link["title"] != "") ? $link["title"] : esc_html__("Click on me", "aventa");
            $html .= "<a id=\"" . esc_attr($id) . "\" href=\"" . esc_url($link["url"]) . "\" class=\"" . esc_attr(implode(" ", array_filter($class))) . "\"";
            $html .= ($link["target"] != "") ? " target=\"" . esc_attr($link["target"]) . "\"" : "";
            $html .= " title=\"" . esc_attr($link["title"]) . "\" " . $anim_attr . "><span class=\"txt\">" . esc_html($link["title"]) . "</span>";
            if ($icon != "") {
                $icon = explode(":", $icon);
                $html .= rad_Icon_Manager::get_icon($icon[0], $icon[1]);
            }
            $html .= "</a>";
        }
    }

    return $html;
}

/**********************************************/
/*  Link
/**********************************************/

function rad_link_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "url"                  => "#",
        "color"                => "",
        "hover_color"          => "#777",
        "alignment"            => "left",
        "position"             => "block",
        "css"                  => "", // css editor option(Design tab)
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
    ), $atts));

    $style_atts = array(
        "color"       => "",
        "hover_color" => "#eee",
    );

    $id = rad_element_id("lnk");

    $class     = array("rad_link", "underline-style", "init-show", "resp-block");
    $class[]   = "link-" . $alignment;
    $class[]   = "link-" . $position;
    if(defined('VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG'))
    {
        $class[]   = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($css, " "), "rad_link", $atts);
    }
    
    $class[]   = ($animation != "none") ? "elem-anim" : "";
    $class[]   = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $has_style = rad_has_custom_style($style_atts, $atts);

    $link = rad_make_vc_url($url);
    $html = "";

    if ($url != "" && function_exists("vc_build_link")) {
        // Prevent from printing style in front side of site. We add styles in front side by another way.
        if ($has_style && print_element_style()) {

            $html .= "<style>";

            if ($color != "") {
                $html .= "#" . $id . ".rad_link {";
                if ($color != "") {
                    $html .= "color:" . esc_attr($color) . ";";
                    $html .= "border-color:" . esc_attr($color) . ";";
                }

                $html .= "}";
            }

            if ($hover_color != "") {
                $html .= "#" . $id . ".rad_link:hover {";
                if ($hover_color != "") {
                    $html .= "color:" . esc_attr($hover_color) . ";";
                    $html .= "border-color:" . esc_attr($hover_color) . ";";
                }

                $html .= "}";
            }

            $html .= "</style>";

        }

        $link = vc_build_link($url);
        if ($link["url"] != "") {

            $title = ($link["title"] != "") ? $link["title"] : esc_html__("Read more", "aventa");
            $html .= "<a id=\"" . esc_attr($id) . "\" href=\"" . esc_url($link["url"]) . "\" class=\"" . esc_attr(implode(" ", array_filter($class))) . "\"";
            $html .= ($link["target"] != "") ? " target=\"" . esc_attr($link["target"]) . "\"" : "";
            $html .= " title=\"" . esc_attr($link["title"]) . "\" " . $anim_attr . "><span class=\"txt\">" . esc_html($link["title"]) . "</span>";
            $html .= "</a>";
            if ($alignment == "left" || $alignment == "right") {
                $html .= "<div class=\"rad-link-clearfix\"></div>";
            }

        }
    }

    return $html;
}
/**********************************************/
/*  Toggle block
/**********************************************/

function rad_toggle_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "title"                => "",
        "open"                 => "false",
        "title_color"          => "",
        "animation"            => "none",
        "delay"                => "0",
        "align"                => "left",
        "responsive_animation" => "disable",
    ), $atts));

    $id      = rad_element_id("tq");
    $classes = array("toggle-block", "resp-block");
    $html    = "";

    $classes[] = $align;
    $classes[] = ($open == "true") ? "open" : "";
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    $title_style   = ($title_color != "") ? "color:" . $title_color . ";" : "";
    $content_style = ($open == "true") ? "display: block;" : "";

    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $html .= rad_make_text("span", $title, "title", $title_style);
    $html .= rad_make_text("div", wpb_js_remove_wpautop($content), "toggle-content", $content_style);
    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  VC carousel
/**********************************************/

function rad_image_carousel_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "freemode"             => "no",
        "freemode_max_width"   => "40",
        "nav_style"            => "dark",
        "images"               => "",
        "hover_color"          => "c0392b",
        "custom_hover_color"   => "",
        "visible_items"        => "1",
        "image_size"           => "",
        "image_width"          => "",
        "image_height"         => "",
        "image_crop"           => "",
        "zoom"                 => "",
        "gutter"               => "",
        "navigation"           => "next-prev",
        "img_animation"        => "zoom-in",
        "entrance_animation"   => "none",
        "responsive_animation" => "disable",
        "is_autoplay"          => "off",
    ), $atts));

    $id = rad_element_id("imgc");

    $image_ids = ($images != "") ? explode(",", $images) : array();
    if (empty($image_ids)) {
        return;
    }

    $classes   = array("image-carousel-block", "carousel", "resp-block");
    $classes[] = $nav_style;
    $classes[] = ($zoom == "yes" ? "zoom-effect" : "");
    $classes[] = ($freemode == "yes" ? "freemode" : "");
    $classes[] = ($gutter == "no" ? "no-gutter" : "");
    $classes[] = ($img_animation != "none") ? "img-anim img-anim-" . $img_animation : "";
    $classes[] = ($entrance_animation != "none") ? "elem-grid-anim" : "";
    $classes[] = ($entrance_animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";

    $visible_attr  = "data-visibleitems=\"" . $visible_items . "\"";
    $autoplay_attr = "data-autoplay=\"" . $is_autoplay . "\" ";
    $anim_attr     = rad_make_anim_attributes($entrance_animation, "0");

    $html = "";
    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $autoplay_attr . $anim_attr, false);
    $html .= rad_make_container("div", "", "", "swiper-container", "", $visible_attr, false);
    $html .= rad_make_container("div", "", "", "swiper-wrapper", "", "", false);

    foreach ($image_ids as $image_id) {

        $image = rad_get_image($image_id, "", esc_attr__("item", "aventa"), $image_size, $image_width, $image_height, $image_crop, true);

        if ($image == "") {
            continue;
        }

        $style        = "padding-top:" . rad_get_height_percentage($image) . "%;";
        $slider_style = "";

        if ($freemode == "yes") {
            $slider_style = "width:" . rad_get_image_width($image) . "px;";
            $slider_style .= "max-width:" . $freemode_max_width . "vw;";

        }

        $html .= rad_make_container("div", "", "", "swiper-slide item carousel_item", $slider_style, "", false);
        $html .= rad_make_container("div", "", "", "img img-container lazy-load lazy-load-on-load", $style, "", false);
        $html .= rad_make_container("div", "", "", "img-wrap", "", "", false);
        $html .= $image;
        $html .= "</div>";
        $html .= "</div>";
        $html .= "</div>";
    }

    $html .= "</div></div>";

    if ($navigation == "next-prev") {
        $html .= rad_make_container("div", "", "", "rad-carousel-next unselectable", "", "");
        $html .= rad_make_container("div", "", "", "rad-carousel-prev unselectable", "", "");
    } elseif ($navigation == "scrollbar") {
        $html .= rad_make_container("div", "", "", "swiper-scrollbar", "", "");
    } else {
        $html .= rad_make_container("div", "", "", "swiper-pagination", "", "");
    }

    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Carousel Gallery
/**********************************************/

function rad_gallery_carousel_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "freemode"             => "no",
        "freemode_max_width"   => "40",
        "nav_style"            => "light",
        "hover_color"          => "",
        "title_size"           => "20",
        "subtitle_size"        => "14",
        "image_size"           => "",
        "image_width"          => "",
        "image_height"         => "",
        "image_crop"           => "",
        "visible_items"        => "1",
        "gutter"               => "",
        "navigation"           => "next-prev",
        "entrance_animation"   => "fade-in-bottom",
        "responsive_animation" => "disable",
        "is_autoplay"          => "on",
    ), $atts));

    //Save iamge size attirubtes in a global var to be used by nested elements
    $GLOBALS["rad_gc_settings"] = array(
        "image_size"         => $image_size,
        "image_width"        => $image_width,
        "image_height"       => $image_height,
        "image_crop"         => $image_crop,
        "freemode"           => $freemode,
        "freemode_max_width" => $freemode_max_width,
    );

    $id        = rad_element_id("gc");
    $classes   = array("gallery-carousel-block", "carousel", "resp-block");
    $classes[] = $nav_style;
    $classes[] = ($freemode == "yes" ? "freemode" : "");
    $classes[] = ($gutter == "no" ? "no-gutter" : "");
    $classes[] = ($entrance_animation != "none") ? "elem-anim" : "";
    $classes[] = ($entrance_animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";

    $autoplay_attr = "data-autoplay=\"" . $is_autoplay . "\"";
    $visible_attr  = "data-visibleitems=\"" . $visible_items . "\"";

    $hover_style = ($hover_color != "") ? "style=\"background-color:" . $hover_color . ";\"" : "";

    $title_style    = ($title_size != "20") ? " style=\"font-size:" . $title_size . "px;\"" : "";
    $subtitle_style = ($subtitle_size != "14") ? " style=\"font-size:" . $subtitle_size . "px;\"" : "";

    $html = "";
    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $autoplay_attr, false);
    $html .= rad_make_container("div", "", "", "swiper-container", "", $visible_attr, false);
    $html .= rad_make_container("div", "", "", "swiper-wrapper", "", "", false);

    $output = do_shortcode($content); //nested shortcodes
    if ($hover_style !== "") {
        $output = str_replace("class=\"overlay\"", "class=\"overlay\" " . $hover_style, $output);
    }

    if ($title_style !== "") {
        $output = str_replace("class=\"text\"", "class=\"text\" " . $title_style, $output);
    }

    if ($subtitle_style !== "") {
        $output = str_replace("class=\"subtext\"", "class=\"subtext\" " . $subtitle_style, $output);
    }

    $html .= $output;
    $html .= "</div></div>";

    if ($navigation == "next-prev") {
        $html .= "<div class=\"rad-carousel-next unselectable\"></div>";
        $html .= "<div class=\"rad-carousel-prev unselectable\"></div>";
    } elseif ($navigation == "scrollbar") {
        $html .= rad_make_container("div", "", "", "swiper-scrollbar", "", "", true);
    } else {
        $html .= rad_make_container("div", "", "", "swiper-pagination", "", "", true);
    }

    $html .= "</div>";

    unset($GLOBALS["rad_gc_image_dim"]);
    return $html;
}

function rad_gallery_carousel_item_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "img_id"   => "",
        "title"    => esc_html__("Gallery hover title", "aventa"),
        "subtitle" => "",
        "url"      => "",
    ), $atts));

    /* Get dimension from parent shortcode */
    $carousel_setting   = $GLOBALS["rad_gc_settings"];
    $image_size         = $carousel_setting["image_size"];
    $image_width        = $carousel_setting["image_width"];
    $image_height       = $carousel_setting["image_height"];
    $image_crop         = $carousel_setting["image_crop"];
    $freemode           = $carousel_setting["freemode"];
    $freemode_max_width = $carousel_setting["freemode_max_width"];

    $image = rad_get_image($img_id, "", $title, $image_size, $image_width, $image_height, $image_crop, true);

    if ($image == "") {
        return;
    }

    $style        = "padding-top:" . rad_get_height_percentage($image) . "%;";
    $slider_style = "";

    if ($freemode == "yes") {
        $slider_style = "width:" . rad_get_image_width($image) . "px;";
        $slider_style .= "max-width:" . $freemode_max_width . "vw;";

    }

    $html = rad_make_container("div", "", "", "swiper-slide item", $slider_style, "", false);
    $html .= rad_make_container("div", "", "", "img lazy-load lazy-load-on-load", $style, "", false);
    $html .= $image;
    $html .= "</div>";
    $html .= rad_make_vc_url($url);
    $html .= rad_make_container("span", "", "", "overlay", "", "", true);
    $html .= rad_make_container("span", "", "", "text-wrapper", "", "", false);
    $html .= rad_make_container("span", $title, "", "text", "", "", true);
    $html .= rad_make_container("span", $subtitle, "", "subtext", "", "", true);
    $html .= "</span></div>";

    return $html;
}

/**********************************************/
/*  Slideshow
/**********************************************/

function rad_slideshow_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "color"        => "",
        "bg_color"     => "",
        "image_size"   => "",
        "image_width"  => "",
        "image_height" => "",
        "image_crop"   => "",
        "title"        => "",
        "title_size"   => "12",
    ), $atts));

    $id = rad_element_id("sls");

    //Save iamge size attirubtes in a global var to be used by nested elements
    $GLOBALS["rad_sls_settings"] = array(
        "image_size"   => $image_size,
        "image_width"  => $image_width,
        "image_height" => $image_height,
        "image_crop"   => $image_crop,
    );

    //Fetch All sections
    $nested_content = do_shortcode($content);
    $items          = isset($GLOBALS["rad_sls_items"]) ? $GLOBALS["rad_sls_items"] : array();

    //unset Global variables
    unset($GLOBALS["rad_sls_items"]);
    unset($GLOBALS["rad_sls_settings"]);

    //Start processing output
    $classes         = array("slideshow-block", "resp-block");
    $slideshow_style = ($color != "") ? "border-color:" . $color . ";color:" . $color . ";" : "";
    $slideshow_style .= ($bg_color != "") ? "background-color:" . $bg_color . ";" : "";
    $title_style = ($title_size != "12") ? "font-size:" . $title_size . "px;" : "";

    $html = rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", "", false);
    $html .= rad_make_container("div", "", "", "sl-items", $slideshow_style, "", false);
    $html .= rad_make_title("h3", $title, "", $title_style, "", true);
    $html .= rad_make_container("ul", "", "", "", "", "", false);

    foreach ($items as $item) {
        $html .= "<li data-id=\"" . esc_attr($item["id"]) . "\" class=\"underline-style\">" . esc_html($item["title"]) . "</li>";
    }
    $html .= "</ul></div>";
    $html .= rad_make_container("div", "", "", "sl-images", "", "", false);
    $html .= $nested_content;
    $html .= "</div></div>";

    return $html;
}

function rad_slideshow_item_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "img_id" => "",
        "title"  => esc_html__("Gallery hover text", "aventa"),
        "url"    => "",
    ), $atts));

    $id = rad_element_id("sls_i");

    /* Get dimension from parent shortcode */
    $setting      = $GLOBALS["rad_sls_settings"];
    $image_size   = $setting["image_size"];
    $image_width  = $setting["image_width"];
    $image_height = $setting["image_height"];
    $image_crop   = $setting["image_crop"];

    $image = rad_get_image_url($img_id, $image_size, $image_width, $image_height, $image_crop);

    if ($image == "") {
        return;
    }

    $GLOBALS["rad_sls_items"][] = array(
        "title" => $title,
        "id"    => $id,
    );

    $attr = "data-src=\"" . $image . "\"";

    $html = rad_make_container("div", "", $id, "slideshow-item", "", "", false);
    $html .= rad_make_container("div", "", "", "img lazy-load bg-lazy-load lazy-load-on-load ", "", $attr);
    $html .= rad_make_vc_url($url, esc_html__("Read more", "aventa"), "underline-style init-show");
    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Reveal Slideshow
/**********************************************/

function rad_reveal_slideshow_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "ids"          => "",
        "nv_color"     => "dark",
        "pg_color"     => "",
        "image_size"   => "",
        "height"       => "60",
        "image_width"  => "",
        "image_height" => "",
        "image_crop"   => "",
    ), $atts));

    $id  = rad_element_id("rsls");
    $ids = ($ids != "") ? explode(",", $ids) : array();
    if (empty($ids)) {
        return;
    }

    //Start processing output
    $classes      = array("reveal-slideshow-block", "resp-block");
    $style        = ($pg_color != "") ? "color:" . $pg_color . ";" : "";
    $height_style = "padding-top:" . esc_attr($height) . "%;";
    $attr         = "data-cursor=\"#" . $id . "-p-g-cursor\"";

    $html = rad_make_container("div", "", $id, implode(" ", array_filter($classes)), $style, "", false);
    $html .= rad_make_container("div", "", "", "rsl-images custom-cursor", $height_style, $attr, false);

    $counter = 0;
    foreach ($ids as $image_id) {

        $image = rad_get_image_url($image_id, "", "item", $image_size, $image_width, $image_height, $image_crop, true);

        if ($image == "") {
            continue;
        }
//skip this itteration

        $attr  = "data-item=\"" . ($counter + 1) . "\"";
        $class = ($counter == 0) ? "active" : "go-out";
        $html .= rad_make_container("div", "", "", "slideshow-item " . $class, $height_style, $attr, false);

        $attr = "data-src=\"" . $image . "\"";
        $html .= rad_make_container("div", "", "", "img lazy-load bg-lazy-load lazy-load-on-load ", "", $attr, true);
        $html .= "</div>";
        $counter++;
    }

    $html .= "</div>";
    $html .= "<span id=\"" . $id . "-p-g-cursor\" class=\"rad-cursor rad-rsls-cursor " . esc_attr($nv_color) . "\"><span></span></span>";
    $html .= "<span class=\"rs-pagination\"><span class=\"current\">1</span>/" . esc_html($counter) . "</span>";
    $html .= "</div>";

    return $html;
}

/**********************************************/
/*  Newsletter(subscribtion form)
/**********************************************/

function rad_newsletter_handler($atts)
{
    extract(shortcode_atts(array(
        "form_id"              => "",
        "align"                => "left",
        "style"                => "dark",
        "animation"            => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
    ), $atts));

    $id = rad_element_id("nwsl");

    $classes   = array("rad-newsletter");
    $classes[] = $align;
    $classes[] = $style;
    $classes[] = ($animation != "none") ? "elem-anim" : "";
    $classes[] = ($animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";
    $anim_attr = rad_make_anim_attributes($animation, $delay);

    if (!class_exists("MC4WP_MailChimp") || $form_id == "") {
        return;
    }

    $html = rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $anim_attr, false);
    $html .= do_shortcode("[mc4wp_form id=\"" . $form_id . "\"]");
    $html .= "</div>";
    return $html;
}

/************************************************************/
/*                                                          */
/*                 Woocommerce shortcodes                   */
/*                                                          */
/************************************************************/

//single product 1
function rad_sc_product($atts)
{
    $atts = array_merge(array(
        "id"                   => "",
        "columns"              => "1",
        "limit"                => "1",
        "orderby"              => "date",
        "order"                => "DESC",
        "category"             => "",
        "cat_operator"         => "IN",
        "tags"                 => "",
        "paginate"             => "",
        "style"                => "bt-hover",
        "gutter"               => "one-unit-gutter",
        "entrance_animation"   => "fadeIn",
        "grid_mode"            => "general",
        "hover_image"          => "show",
        "quickview"            => "enable",
        "wishlist"             => "enable",
        "layout"               => "grid",
        "image_size"           => "woocommerce_single",
        "image_size_width"     => "",
        "image_size_height"    => "",
        "image_size_crop"      => "",
        "is_autoplay"          => "off",
        "nav_style"            => "dark",
        "navigation"           => "next-prev",
        "delay"                => "0",
        "responsive_animation" => "disable",

    ), (array) $atts);

    $atts["skus"]  = isset($atts["sku"]) ? $atts["sku"] : "";
    $atts["ids"]   = isset($atts["id"]) ? $atts["id"] : "";
    $atts["limit"] = "1";

    return rad_get_shortcode_content($atts, "product");
}

function rad_products($atts)
{

    $atts = array_merge(array(
        "columns"              => "1",
        "limit"                => "12",
        "orderby"              => "date",
        "order"                => "DESC",
        "category"             => "",
        "cat_operator"         => "IN",
        "tags"                 => "",
        "paginate"             => "",
        "style"                => "bt-hover",
        "gutter"               => "one-unit-gutter",
        "entrance_animation"   => "fadeIn",
        "grid_mode"            => "general",
        "hover_image"          => "show",
        "quickview"            => "enable",
        "wishlist"             => "enable",
        "layout"               => "grid",
        "image_size"           => "woocommerce_single",
        "image_size_width"     => "",
        "image_size_height"    => "",
        "image_size_crop"      => "",
        "is_autoplay"          => "off",
        "nav_style"            => "dark",
        "navigation"           => "next-prev",
        "delay"                => "0",
        "responsive_animation" => "disable",

    ), (array) $atts);

    return rad_get_shortcode_content($atts, "products");
}

function rad_recent_products($atts)
{

    $atts = array_merge(array(
        "columns"              => "1",
        "limit"                => "12",
        "orderby"              => "date",
        "order"                => "DESC",
        "category"             => "",
        "cat_operator"         => "IN",
        "tags"                 => "",
        "paginate"             => "",
        "style"                => "bt-hover",
        "gutter"               => "one-unit-gutter",
        "entrance_animation"   => "fadeIn",
        "grid_mode"            => "general",
        "hover_image"          => "show",
        "quickview"            => "enable",
        "wishlist"             => "enable",
        "layout"               => "grid",
        "image_size"           => "woocommerce_single",
        "image_size_width"     => "",
        "image_size_height"    => "",
        "image_size_crop"      => "",
        "is_autoplay"          => "off",
        "nav_style"            => "dark",
        "navigation"           => "next-prev",
        "delay"                => "0",
        "responsive_animation" => "disable",

    ), (array) $atts);

    return rad_get_shortcode_content($atts, "recent_products");

}

function rad_sale_products($atts)
{
    $atts = array_merge(array(
        "columns"              => "1",
        "limit"                => "12",
        "orderby"              => "date",
        "order"                => "DESC",
        "category"             => "",
        "cat_operator"         => "IN",
        "tags"                 => "",
        "paginate"             => "",
        "style"                => "bt-hover",
        "gutter"               => "one-unit-gutter",
        "entrance_animation"   => "fadeIn",
        "grid_mode"            => "general",
        "hover_image"          => "show",
        "quickview"            => "enable",
        "wishlist"             => "enable",
        "layout"               => "grid",
        "image_size"           => "woocommerce_single",
        "image_size_width"     => "",
        "image_size_height"    => "",
        "image_size_crop"      => "",
        "is_autoplay"          => "off",
        "nav_style"            => "dark",
        "navigation"           => "next-prev",
        "delay"                => "0",
        "responsive_animation" => "disable",

    ), (array) $atts);

    $atts["on_sale"] = true;

    return rad_get_shortcode_content($atts, "sale_products");

}

function rad_best_selling_products($atts)
{
    $atts = array_merge(array(
        "columns"              => "1",
        "limit"                => "12",
        "orderby"              => "date",
        "order"                => "DESC",
        "category"             => "",
        "cat_operator"         => "IN",
        "tags"                 => "",
        "paginate"             => "",
        "style"                => "bt-hover",
        "gutter"               => "one-unit-gutter",
        "entrance_animation"   => "fadeIn",
        "grid_mode"            => "general",
        "hover_image"          => "show",
        "quickview"            => "enable",
        "wishlist"             => "enable",
        "layout"               => "grid",
        "image_size"           => "woocommerce_single",
        "image_size_width"     => "",
        "image_size_height"    => "",
        "image_size_crop"      => "",
        "is_autoplay"          => "off",
        "nav_style"            => "dark",
        "navigation"           => "next-prev",
        "delay"                => "0",
        "responsive_animation" => "disable",

    ), (array) $atts);

    return rad_get_shortcode_content($atts, "best_selling_products");
}

function rad_top_rated_products($atts)
{
    $atts = array_merge(array(
        "columns"              => "1",
        "limit"                => "12",
        "orderby"              => "date",
        "order"                => "DESC",
        "category"             => "",
        "cat_operator"         => "IN",
        "tags"                 => "",
        "paginate"             => "",
        "style"                => "bt-hover",
        "gutter"               => "one-unit-gutter",
        "entrance_animation"   => "fadeIn",
        "grid_mode"            => "general",
        "hover_image"          => "show",
        "quickview"            => "enable",
        "wishlist"             => "enable",
        "layout"               => "grid",
        "image_size"           => "woocommerce_single",
        "image_size_width"     => "",
        "image_size_height"    => "",
        "image_size_crop"      => "",
        "is_autoplay"          => "off",
        "nav_style"            => "dark",
        "navigation"           => "next-prev",
        "delay"                => "0",
        "responsive_animation" => "disable",

    ), (array) $atts);

    return rad_get_shortcode_content($atts, "top_rated_products");
}

function rad_featured_products($atts)
{
    $atts = array_merge(array(
        "columns"              => "1",
        "limit"                => "12",
        "orderby"              => "date",
        "order"                => "DESC",
        "category"             => "",
        "cat_operator"         => "IN",
        "tags"                 => "",
        "paginate"             => "",
        "style"                => "bt-hover",
        "gutter"               => "one-unit-gutter",
        "entrance_animation"   => "fadeIn",
        "grid_mode"            => "general",
        "hover_image"          => "show",
        "quickview"            => "enable",
        "wishlist"             => "enable",
        "layout"               => "grid",
        "image_size"           => "woocommerce_single",
        "image_size_width"     => "",
        "image_size_height"    => "",
        "image_size_crop"      => "",
        "is_autoplay"          => "off",
        "nav_style"            => "dark",
        "navigation"           => "next-prev",
        "delay"                => "0",
        "responsive_animation" => "disable",

    ), (array) $atts);

    $atts["visibility"] = "featured";

    return rad_get_shortcode_content($atts, "featured_products");
}

function rad_product_attribute($atts)
{
    $atts = array_merge(array(
        "columns"              => "1",
        "limit"                => "12",
        "orderby"              => "date",
        "order"                => "DESC",
        "attribute"            => "",
        "terms"                => "",
        "paginate"             => "",
        "style"                => "bt-hover",
        "gutter"               => "one-unit-gutter",
        "entrance_animation"   => "fadeIn",
        "grid_mode"            => "general",
        "hover_image"          => "show",
        "quickview"            => "enable",
        "wishlist"             => "enable",
        "layout"               => "grid",
        "image_size"           => "woocommerce_single",
        "image_size_width"     => "",
        "image_size_height"    => "",
        "image_size_crop"      => "",
        "is_autoplay"          => "off",
        "nav_style"            => "dark",
        "navigation"           => "next-prev",
        "delay"                => "0",
        "responsive_animation" => "disable",

    ), (array) $atts);

    if (empty($atts["attribute"])) {
        return "";
    }

    return rad_get_shortcode_content($atts, "product_attribute");

}

function rad_product_category($atts)
{
    $atts = array_merge(array(
        "columns"              => "1",
        "limit"                => "12",
        "orderby"              => "date",
        "order"                => "DESC",
        "category"             => "",
        "cat_operator"         => "IN",
        "tags"                 => "",
        "paginate"             => "",
        "style"                => "bt-hover",
        "gutter"               => "one-unit-gutter",
        "entrance_animation"   => "fadeIn",
        "grid_mode"            => "general",
        "hover_image"          => "show",
        "quickview"            => "enable",
        "wishlist"             => "enable",
        "layout"               => "grid",
        "image_size"           => "woocommerce_single",
        "image_size_width"     => "",
        "image_size_height"    => "",
        "image_size_crop"      => "",
        "is_autoplay"          => "off",
        "nav_style"            => "dark",
        "navigation"           => "next-prev",
        "delay"                => "0",
        "responsive_animation" => "disable",

    ), (array) $atts);

    if (empty($atts["category"])) {
        return "";
    }

    return rad_get_shortcode_content($atts, "product_category");

}

//Product categories
function rad_product_categories($atts)
{

    if (isset($atts["number"])) {
        $atts["limit"] = $atts["number"];
    }

    $atts = shortcode_atts(array(
        "limit"                => "-1",
        "orderby"              => "name",
        "order"                => "ASC",
        "columns"              => "1",
        "hide_empty"           => 1,
        "parent"               => "",
        "ids"                  => "",
        /* *********** Rado codes  *********** */
        "style"                => "1",
        "layout"               => "grid",
        "nav_style"            => "dark",
        "navigation"           => "next-prev",
        "is_autoplay"          => "off",
        "count"                => "disable",
        "description"          => "enable",
        "hover_color"          => "",
        "tex_color"            => "",
        "gutter"               => "0",
        "hover_tex_color"      => "",
        "entrance_animation"   => "none",
        "delay"                => "0",
        "responsive_animation" => "disable",
        "grid_mode"            => "general",
        "image_size"           => "woocommerce_thumbnail",
        "image_size_width"     => "",
        "image_size_height"    => "",
        "image_size_crop"      => "",
        "grid_type"            => "standard",
        "masonry_style"        => "i2a",
        /* *********** Rado codes  *********** */
    ), $atts, "product_categories");

    /* *********** Rado codes  *********** */
    rad_enable_override_wc_cat_shortcode($atts);
    /* *********** </Rado code>  *********** */

    $ids        = array_filter(array_map("trim", explode(",", $atts["ids"])));
    $hide_empty = (true === $atts["hide_empty"] || "true" === $atts["hide_empty"] || 1 === $atts["hide_empty"] || "1" === $atts["hide_empty"]) ? 1 : 0;

    // Get terms and workaround WP bug with parents/pad counts.
    $args = array(
        "orderby"    => $atts["orderby"],
        "order"      => $atts["order"],
        "hide_empty" => $hide_empty,
        "include"    => $ids,
        "pad_counts" => true,
        "child_of"   => $atts["parent"],
    );

    /* *********** Rado codes  *********** */
    $args["meta_query"] = array(
        "relation" => "OR",
        array(
            "key"     => "cat-collection",
            "value"   => "1",
            "compare" => "!=",
        ),
        array(
            "key"     => "cat-collection",
            "compare" => "NOT EXISTS",
        ),
    );
    /* *********** </Rado code>  *********** */

    $product_categories = apply_filters(
        "woocommerce_product_categories",
        get_terms("product_cat", $args)
    );

    if ("" !== $atts["parent"]) {
        $product_categories = wp_list_filter($product_categories, array(
            "parent" => $atts["parent"],
        ));
    }

    if ($hide_empty) {
        foreach ($product_categories as $key => $category) {
            if (0 === $category->count) {
                unset($product_categories[$key]);
            }
        }
    }

    $atts["limit"] = "-1" === $atts["limit"] ? null : intval($atts["limit"]);
    if ($atts["limit"]) {
        $product_categories = array_slice($product_categories, 0, $atts["limit"]);
    }

    $columns = absint($atts["columns"]);

    wc_set_loop_prop("columns", $columns);
    wc_set_loop_prop("is_shortcode", true);

    ob_start();

    if ($product_categories) {
        do_action("woocommerce_shortcode_before_cat_loop");

        woocommerce_product_loop_start();

        foreach ($product_categories as $category) {
            wc_get_template("content-product_cat.php", array(
                "category" => $category,
            ));
        }

        woocommerce_product_loop_end();

        do_action("woocommerce_shortcode_after_cat_loop");
    }

    woocommerce_reset_loop();

    /* *********** Rado codes  *********** */
    rad_disable_override_wc_cat_shortcode();
    /* *********** </Rado code>  *********** */

    return "<div class=\"woocommerce columns-" . $columns . "\">" . ob_get_clean() . "</div>";
}

/**********************************************/
/*  Card blog
/**********************************************/

function rad_card_blog_handler($atts, $content = null)
{
    extract(shortcode_atts(array(
        "blog_style"                  => "classic",
        "blog_column"                 => "3",
        "blog_category"               => "",
        "blog_post_number"            => "16",
        "blog_foreground_color"       => "dark",
        "blog_layout_mode"            => "masonry",
        "blog_background_color"       => "#f8f8f8",
        "quote_blog_background_color" => "#000",
        "quote_blog_text_color"       => "#fff",
        "show_author"                 => "yes",
        "show_comments"               => "no",
        "blog_filter"                 => "all",
        "entrance_animation"          => "none",
        "responsive_animation"        => "disable",
        "blog_category_visibility"    => "yes",
        "load_more_visibility"        => "yes",
        "blog_multimedia_icon_style"  => "light",
        "load_more_style"             => "dark",
        "blog_image_size"             => "large",
    ), $atts));

    $show_video_audio = false;

    $id       = rad_element_id("blg");
    $postpage = isset($_GET["postpage"]) ? (int) $_GET["postpage"] : 1;
    $arrg     = array(
        "posts_per_page" => $blog_post_number,
        "paged"          => $postpage,
        "post_type"      => "post",
    );

    if ($blog_category != "") {
        $arrg["tax_query"] = array(
            array(
                "taxonomy" => "category",
                "field"    => "slug",
                "terms"    => explode(",", $blog_category),
            ),
        );
    }

    $query = new WP_Query($arrg);
    $max   = ceil($query->found_posts / $blog_post_number);

    $html = "";

    $classes   = array("card-blog", $blog_style . "-card", $blog_foreground_color, "column-" . $blog_column);
    $classes[] = ($load_more_visibility != "yes") ? "no-load-more" : "";
    $classes[] = ($entrance_animation != "none") ? "elem-grid-anim" : "";
    $classes[] = ($entrance_animation != "none" && $responsive_animation == "disable") ? "no-resp-anim" : "";

    $attrs = "data-page=\"1\" ";
    $attrs .= "data-maxpages=\"" . esc_attr($max) . "\" ";
    $attrs .= rad_make_anim_attributes($entrance_animation, "0");
    $html .= rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", $attrs, false);

    $attrs = "data-columnnumber=\"" . esc_attr($blog_column) . "\" ";
    $attrs .= "data-layout=\"" . esc_attr($blog_layout_mode) . "\" ";
    $html .= rad_make_container("div", "", "", "rad-card-posts isotope", "", $attrs, false);

    $stickies = array();
    while ($query->have_posts()) {
        $query->the_post();

        $format = rad_get_post_format(get_the_ID());
        if ($blog_image_size == "large") {
            $thumb = rad_get_image_url(get_post_thumbnail_id(), "large");
        } else {
            $thumb = rad_get_image_url(get_post_thumbnail_id(), "rad_thumbnail-auto-height");
        }

        $sticky     = (is_sticky(get_the_ID()) && !in_array(get_the_ID(), $stickies)) ? " sticky" : "";
        $stickies[] = get_the_ID();

        $html .= "<div class=\"card-post isotope-item" . $sticky . "\">";
        $html .= "<div class=\"rad-post-wrap target-anim\">";
        $style = $blog_background_color != "" ? "background-color:" . esc_attr($blog_background_color) . ";" : "";
        $html .= rad_make_container("div", "", "", "rad-post-inner " . $format . "-post", $style, "", false);

        if ($format == "audio") {
            if ($show_video_audio) {
                $audio = rad_get_meta("audio-url");
                if ($audio != null) {
                    $html .= do_shortcode("[audio_soundcloud soundcloud_id=\"" . esc_url($audio) . "\"]");
                }
            } else {
                if ($thumb != "") {
                    $html .= "<div class=\"image-container lazy-load bg-lazy-load lazy-load-on-load\" data-src=\"" . esc_url($thumb) . "\">";
                    $html .= "<a href=\"" . esc_url(get_the_permalink()) . "\">";
                    $html .= rad_Icon_Manager::get_icon("sound", "external");
                    $html .= "</a>";
                    $html .= "</div>";
                }
            }

        } else if ($format == "gallery") {
            $images = explode(",", rad_get_meta("gallery"));
            if (count($images) > 0) {
                $html .= "<div class=\"swiper-container clearfix\" data-visibleitems=\"1\">";
                $html .= "<div class=\"slides swiper-wrapper\">";
                foreach ($images as $img_id) {
                    if ($blog_image_size == "large") {
                        $img = rad_get_image_url($img_id, "large");
                    } else {
                        $img = rad_get_image_url($img_id, "rad_thumbnail-auto-height");
                    }
                    $html .= "<div class=\"swiper-slide\" style=\"background-image:url(" . esc_url($img) . ");\"></div>";
                }
                $html .= "</div>";
                if (count($images) > 1) {
                    $html .= "<div class=\"rad-carousel-prev unselectable\"></div>";
                    $html .= "<div class=\"rad-carousel-next unselectable\"></div>";
                }
                $html .= "</div>";
            }

        } else if ($format == "video") {

            if ($show_video_audio) {
                $videoUrl = rad_get_meta("video-id");
                $host     = rad_get_meta("video-type");

                $video_display_type = "embeded_video_$host";

                if ($video_display_type == "embeded_video_vimeo") {

                    $html .= "<div data-id=\"" . esc_attr($id) . "\">";
                    $html .= do_shortcode("[rad_video video_display_type=\"embeded_video_vimeo\" video_vimeo_id=\"" . esc_url($videoUrl) . "\"]");
                    $html .= "</div>";

                } else if ($video_display_type == "embeded_video_youtube") {

                    $video_id = explode("?v=", $videoUrl); // detect youtube id form url
                    if (empty($video_id[1])) {
                        $video_id = explode("/v/", $videoUrl);
                    }
                    if (!empty($video_id[1])) {
                        $video_id = explode("&", $video_id[1]); // removing any other params
                        $video_id = $video_id[0];
                    } else {
                        $video_id = $videoUrl;
                    }
                    $html .= "<div data-id=\"" . esc_attr($id) . "\">";
                    $html .= "<div class=\"wpb_video_widget wpb_content_element vc_clearfix vc_video-aspect-ratio-169\">";
                    $html .= "<div class=\"wpb_wrapper\">";
                    $html .= "<div class=\"wpb_video_wrapper\">";
                    $html .= "<iframe title=\"" . esc_attr__("YouTube video player", "aventa") . "\" src=\"https://www.youtube.com/embed/" . esc_url($video_id) . "\" allowfullscreen></iframe>";
                    $html .= "</div>";
                    $html .= "</div>";
                    $html .= "</div>";
                    $html .= "</div>";

                }
            } else {
                if ($thumb != "") {
                    $html .= "<div class=\"image-container lazy-load bg-lazy-load lazy-load-on-load\" data-src=\"" . esc_url($thumb) . "\">";
                    $html .= "<a href=\"" . esc_url(get_the_permalink()) . "\">";
                    $html .= rad_Icon_Manager::get_icon("caret-right", "solid");
                    $html .= "</a>";
                    $html .= "</div>";
                }
            }

        } elseif ($format == "quote") {
            if ($thumb != "") {
                $html .= "<div class=\"image-container lazy-load bg-lazy-load lazy-load-on-load\" data-src=\"" . esc_url($thumb) . "\"></div>";
            }
        } else {
            //standard format
            if ($thumb != "") {
                $html .= "<div class=\"image-container lazy-load bg-lazy-load lazy-load-on-load\" data-src=\"" . esc_url($thumb) . "\">";
                $html .= "<a href=\"" . esc_url(get_the_permalink()) . "\"></a>";
                $html .= "</div>";
            }
        }

        if ($format == "quote") {
            $quote_content = rad_get_meta("quote_content");
            $quote_author  = rad_get_meta("quote_author");

            $html .= "<a class=\"quote-wrap-link\" href=\"" . esc_url(get_the_permalink()) . "\">";
            $html .= "<div class=\"rad-content\">";
            $html .= "<blockquote style=\"color:" . esc_attr($quote_blog_text_color) . ";\">";
            $html .= "<p>" . esc_html($quote_content) . "</p>";
            $html .= "<cite class=\"author\" style=\"color:" . esc_attr($quote_blog_text_color) . ";\">";
            $html .= esc_html($quote_author) . "</cite>";
            $html .= "</blockquote>";
            $html .= "</div>";
            $html .= "</a>";

        } else {
            $more = (strlen(get_the_excerpt()) > 100) ? "..." : "";
            $html .= "<div class=\"rad-content\">";
            $html .= "<span class=\"rad-cats\">";
            if ($blog_category_visibility == "yes") {
                $terms = get_the_category(get_the_ID());
                if ($terms) {
                    foreach ($terms as $term) {
                        $html .= "<a href=\"" . esc_url(get_category_link(get_cat_ID($term->cat_name))) . "\" class=\"rad-cat underline-style\" title=\"" . esc_attr($term->cat_name) . "\">";
                        $html .= esc_html($term->cat_name) . "</a>";
                    }
                }
            }

            $title = get_the_title();

            $html .= "</span>";
            $html .= "<a href=\"" . esc_url(get_the_permalink()) . "\" title=\"" . $title . "\">";
            $html .= "<h2>" . $title . "</h2>";
            $html .= "</a>";
            if ($blog_style != "modern") {
                $html .= "<p class=\"rad-post-excerpt\">";
                $html .= mb_substr(get_the_excerpt(), 0, 100) . $more;
                $html .= "</p>";
                $html .= "<div class=\"rad-post-meta\">";
                if ($show_author == "yes") {
                    $html .= "<span class=\"post-author\">";
                    $html .= get_avatar(get_the_author_meta("user_email"), 35);
                    $html .= get_the_author_posts_link();
                    $html .= "</span>";
                }

                $html .= "<span class=\"rad-post-date\">";
                $html .= get_the_time(get_option("date_format"));
                $html .= "</span>";

                if ($show_comments == "yes") {
                    $html .= "<a class=\"rad-post-comments\" href=\"" . esc_url(get_comments_link()) . "\">" . get_comments_number_text(esc_html__("No comment", "aventa"), esc_html__("1 comment", "aventa"), esc_html__("% comments", "aventa")) . "</a>";
                }

                $html .= "</div>";
            }
            $html .= "<a class=\"rad-post-link\" href=\"" . esc_url(get_the_permalink()) . "\">" . esc_html__("Read more", "aventa") . "</a>";

            $html .= "</div>";

        }
        $html .= "</div>";
        $html .= "</div>";
        $html .= "</div>";
    }
    wp_reset_postdata();

    $html .= "</div>";
    if ($load_more_visibility == "yes") {
        $html .= "<div class=\"card-blog-load-more " . esc_attr($load_more_style) . "\">";
        $html .= "<a href=\"#\">" . esc_html__("Load more", "aventa") . "</a>";
        $html .= "</div>";
    }
    $html .= "</div>";

    return $html;

}

function rad_enable_override_wc_cat_shortcode($atts)
{
    radWCCategoryShortcodeAttributes::init($atts);
    add_filter("subcategory_archive_thumbnail_size", "radWCCategoryShortcodeAttributes::custom_image_dimension", 100);
    add_filter("rad_loop_start_attributes", "radWCCategoryShortcodeAttributes::override_attributes", 100);
    add_filter("rad_loop_start_classes", "radWCCategoryShortcodeAttributes::override_class", 101);
    add_filter("rad_loop_start_attributes", "radWCCategoryShortcodeAttributes::override_attributes", 100);
    add_filter("rad_get_option_filter", "radWCCategoryShortcodeAttributes::override_theme_options", 100, 2);

    add_action("woocommerce_shortcode_before_cat_loop", "radWCCategoryShortcodeAttributes::carousel_container_open", 100);
    add_action("woocommerce_shortcode_after_cat_loop", "radWCCategoryShortcodeAttributes::carousel_container_close", 100);
}

function rad_disable_override_wc_cat_shortcode()
{
    remove_filter( "subcategory_archive_thumbnail_size", "radWCCategoryShortcodeAttributes::custom_image_dimension", 100);
    remove_filter( "rad_loop_start_classes", "radWCCategoryShortcodeAttributes::override_class", 101);
    remove_filter( "rad_loop_start_attributes", "radWCCategoryShortcodeAttributes::override_attributes", 100);
    remove_filter( "rad_get_option_filter", "radWCCategoryShortcodeAttributes::override_theme_options", 100);

    remove_action("woocommerce_shortcode_before_cat_loop", "radWCCategoryShortcodeAttributes::carousel_container_open", 100);
    remove_action("woocommerce_shortcode_after_cat_loop", "radWCCategoryShortcodeAttributes::carousel_container_close", 100);

    radWCCategoryShortcodeAttributes::destroy();
}

function rad_get_shortcode_content($atts, $loop_name)
{

    $atts["type"] = $loop_name;

    //Adding hooks temprarily
    radWCProductShortcodeAttributes::init($atts);

    add_filter("rad_loop_start_classes", "radWCProductShortcodeAttributes::override_class", 100);
    add_filter("rad_loop_start_attributes", "radWCProductShortcodeAttributes::override_attributes", 100);
    add_filter("rad_get_option_filter", "radWCProductShortcodeAttributes::override_theme_options", 100, 2);
    add_filter("single_product_archive_thumbnail_size", "radWCProductShortcodeAttributes::custom_image_dimension", 100);

    add_action("woocommerce_shortcode_before_" . $loop_name . "_loop", "radWCProductShortcodeAttributes::carousel_container_open", 100);
    add_action("woocommerce_shortcode_after_" . $loop_name . "_loop", "radWCProductShortcodeAttributes::carousel_container_close", 100);

    //Call WC related class to handle shortcode output
    $shortcode = new WC_Shortcode_Products($atts, $loop_name);
    $output    = $shortcode->get_content();

    //removing hooks
    remove_filter( "rad_loop_start_attributes", "radWCProductShortcodeAttributes::override_attributes", 100);
    remove_filter( "rad_loop_start_classes", "radWCProductShortcodeAttributes::override_class", 100);
    remove_filter( "rad_get_option_filter", "radWCProductShortcodeAttributes::override_theme_options", 100);
    remove_filter( "single_product_archive_thumbnail_size", "radWCProductShortcodeAttributes::custom_image_dimension", 100);

    remove_action("woocommerce_shortcode_before_" . $loop_name . "_loop", "radWCProductShortcodeAttributes::carousel_container_open", 100);
    remove_action("woocommerce_shortcode_after_" . $loop_name . "_loop", "radWCProductShortcodeAttributes::carousel_container_close", 100);

    radWCProductShortcodeAttributes::destroy();

    return $output;
}

class RadWCProductShortcodeAttributes
{

    private static $atts = array();

    public static function init($shortcode_attributes)
    {
        self::$atts = $shortcode_attributes;
    }

    //override theme setting options for current shortcode
    public static function override_theme_options($value, $key)
    {
        switch ($key) {
            case "product-style":
                return self::get_attr("style");
                break;
            case "shop-gutter":
                return self::get_attr("gutter", true);
                break;
            case "shop-column":
                return self::get_attr("columns");
                break;
            case "shop-entrance-animation":
                return self::get_attr("entrance_animation");
                break;
            case "shop-layout":
                return self::get_attr("grid_mode");
                break;
            case "product-hover-image":
                return (self::get_attr("hover_image") == "show" ? 1 : "");
                break;
            case "shop-enable-quickview":
                return (self::get_attr("quickview") == "enable" ? 1 : "");
                break;
            case "product-wishlist":
                return (self::get_attr("wishlist") == "enable" ? 1 : "");
                break;
            default:
                return $value;
                break;
        }
    }

    private static function get_attr($key, $integer = false)
    {
        if (isset(self::$atts[$key])) {
            if ($integer) {
                return (int) self::$atts[$key];
            } else {
                return self::$atts[$key];
            }

        }
        return "";
    }

    public static function carousel_container_open()
    {
        if (self::get_attr("layout") == "carousel") {
            $navigation_style = $classes[] = self::get_attr("nav_style");
            echo "<div class=\"wc-shortcode carousel " . $navigation_style . "\"><div class=\"swiper-container\" data-visibleitems=\"" . esc_attr(self::get_attr("columns")) . "\">";
        }
    }

    public static function carousel_container_close()
    {
        if (self::get_attr("layout") == "carousel") {
            echo "</div>";
            if (self::get_attr("navigation") == "next-prev") {
                echo "<div class=\"rad-carousel-next unselectable\"></div><div class=\"rad-carousel-prev unselectable\"></div>";
            } elseif (self::get_attr("navigation") == "scrollbar") {
                echo "<div class=\"swiper-scrollbar\"></div>";
            } elseif (self::get_attr("navigation") == "pagination") {
                echo "<div class=\"swiper-pagination\"></div>";
            }

            echo "</div>";
        }
    }

    public static function override_class($classes)
    {

        if (self::get_attr("entrance_animation") != "none") {
            if (self::get_attr("responsive_animation") == "") {
                if (($key = array_search("no-resp-anim", $classes)) !== false) {
                    unset($classes[$key]);
                }
            }
        }

        if (self::get_attr("layout") == "carousel") {
            if (($key = array_search("shop-grid", $classes)) !== false) {
                unset($classes[$key]);
            }
            $classes[] = "swiper-wrapper";
        }

        $classes[] = self::get_attr("type") . "-shortcode";
        return $classes;
    }

    public static function custom_image_dimension($size)
    {
        if (self::get_attr("image_size") == "custom" && self::get_attr("image_size_width") != "" && self::get_attr("image_size_height") != "") {
            $width  = self::get_attr("image_size_width");
            $height = self::get_attr("image_size_height");
            $crop   = wc_string_to_bool(self::get_attr("image_size_crop"));
            return array($width, $height, $crop);
        } else {
            return self::get_attr("image_size");
        }
    }

    public static function override_attributes($attributes)
    {
        if (self::get_attr("layout") == "carousel") {
            if (self::get_attr("is_autoplay") == "on") {
                $attributes["data-autoplay"] = "on";
            }
        }

        return $attributes;
    }

    public static function destroy()
    {
        self::$atts = array();
    }
}

class RadWCCategoryShortcodeAttributes
{

    private static $atts = array();

    public static function init($shortcode_attributes)
    {
        self::$atts = $shortcode_attributes;
    }

    //override theme setting options for current shortcode
    public static function override_theme_options($value, $key)
    {
        switch ($key) {
            case "wc-category-style":
                return self::get_attr("style", true);
                break;
            case "shop-gutter":
                return self::get_attr("gutter", true);
                break;
            case "shop-column":
                return self::get_attr("columns");
                break;
            case "shop-entrance-animation":
                return self::get_attr("entrance_animation");
                break;
            case "shop-layout":
                return self::get_attr("grid_mode");
                break;
            case "wc-category-number":
                return (self::get_attr("count") == "enable" ? 1 : "");
                break;
            case "wc-category-description":
                return (self::get_attr("description") == "enable" ? 1 : "");
                break;
            case "wc-category-hover-color":
                return self::get_attr("hover_color");
                break;
            case "wc-category-text-color":
                return self::get_attr("tex_color");
                break;
            default:
                return $value;
                break;
        }
    }

    private static function get_attr($key, $integer = false)
    {
        if (isset(self::$atts[$key])) {
            if ($integer) {
                return (int) self::$atts[$key];
            } else {
                return self::$atts[$key];
            }

        }
        return "";
    }

    public static function carousel_container_open()
    {
        if (self::get_attr("layout") == "carousel") {
            $navigation_style = $classes[] = self::get_attr("nav_style");
            echo "<div class=\"wc-shortcode carousel " . $navigation_style . "\"><div class=\"swiper-container\" data-visibleitems=\"" . esc_attr(self::get_attr("columns")) . "\">";
        }
    }

    public static function carousel_container_close()
    {
        if (self::get_attr("layout") == "carousel") {
            echo "</div>";
            if (self::get_attr("navigation") == "next-prev") {
                echo "<div class=\"rad-carousel-next unselectable\"></div><div class=\"rad-carousel-prev unselectable\"></div>";
            } elseif (self::get_attr("navigation") == "scrollbar") {
                echo "<div class=\"swiper-scrollbar\"></div>";
            } elseif (self::get_attr("navigation") == "pagination") {
                echo "<div class=\"swiper-pagination\"></div>";
            }

            echo "</div>";
        }
    }

    public static function override_class($classes)
    {

        if (self::get_attr("entrance_animation") != "none") {
            if (self::get_attr("responsive_animation") == "") {
                if (($key = array_search("no-resp-anim", $classes)) !== false) {
                    unset($classes[$key]);
                }
            }
        }

        if (self::get_attr("layout") == "carousel") {
            if (($key = array_search("shop-grid", $classes)) !== false) {
                unset($classes[$key]);
            }
            $classes[] = "swiper-wrapper";
            $classes[] = self::get_attr("nav_style");
        }

        $classes[] = "wc-categories";
        if (self::get_attr("style") == "2") {
            $classes[] = self::get_attr("style");
        }

        if (self::get_attr("grid_type") == "masonry") {
            $classes[] = self::get_attr("grid_type") . "-g";
            $classes[] = self::get_attr("masonry_style");
        }

        return $classes;
    }

    public static function custom_image_dimension($size)
    {
        if (self::get_attr("image_size") == "custom" && self::get_attr("image_size_width") != "" && self::get_attr("image_size_height") != "") {
            $width  = self::get_attr("image_size_width");
            $height = self::get_attr("image_size_height");
            $crop   = wc_string_to_bool(self::get_attr("image_size_crop"));
            return array($width, $height, $crop);
        } else {
            return self::get_attr("image_size");
        }
    }

    public static function override_attributes($attributes)
    {
        if (self::get_attr("layout") == "carousel") {
            if (self::get_attr("is_autoplay") == "") {
                $attributes["data-autoplay"] = "on";
            }
        }

        return $attributes;
    }

    public static function destroy()
    {
        self::$atts = array();
    }
}
