<?php
$name        = $vars["key"];
$settings    = $vars["settings"];
$value       = $vars["val"];
$class       = rad_array_value("class", $settings);
$title       = rad_array_value("title", $settings, esc_html__("Upload Image", "aventa"));
$referer     = rad_array_value("referer", $settings);
$placeholder = rad_array_value("placeholder", $settings);
$label       = rad_array_value("label", $settings); //Optional value
$multiple    = rad_array_value("multiple", $settings); //Optional value

if ($multiple == true) {
    $class .= " multiple";
}
?>
<div class="field upload-field clear-after <?php echo esc_attr($class); ?>" data-title="<?php echo esc_attr($title); ?>" data-referer="<?php echo esc_attr($referer); ?>" data-name="<?php echo esc_attr($name); ?>">
    <?php if ($label != "") {?>
        <label for="field-<?php echo esc_attr($name); ?>"><?php echo esc_html($label); ?></label>
    <?php }?>
    <input type="hidden" id="field-<?php echo esc_attr($name); ?>" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr($value); ?>" placeholder="<?php echo esc_attr($placeholder); ?>" />
    <a href="#" class="upload-button"><?php esc_html_e("Select image", "aventa");?></a>
    <div class="upload-thumb<?php if ($value) {echo " show";}?>">
        <div class="close"><span class="close-icon"></span></div>
        <?php
$ids = explode(",", $value);
foreach ($ids as $id) {
    $url = rad_get_image_url($id, "full");
    ?>
            <img class="" src="<?php echo esc_url($url); ?>">
            <?php
}
?>
    </div>
</div>