<?php
$name        = $vars["key"];
$settings    = $vars["settings"];
$class       = rad_array_value("class", $settings); //Optional value
$placeholder = rad_array_value("placeholder", $settings); //Optional value
$label       = rad_array_value("label", $settings); //Optional value
if ($name == "attribute-title[]" || $name == "attribute-value[]") {
    $value = $vars["val"];
} else {
    $value = ((esc_attr($this->rad_GetValue($name)) == "") && (rad_array_value("value", $settings) != "")) ? rad_array_value("value", $settings) : esc_attr($this->rad_GetValue(rtrim($name, "-" . get_the_ID())));
}

?>

<div class="field random-key-input <?php echo esc_attr($class); ?>" data-name="<?php echo esc_attr($name); ?>">
    <?php if ($label != "") {?>
        <label for="field-<?php echo esc_attr($name); ?>"><?php echo esc_html($label); ?></label>
    <?php }?>
    <input type="text" id="field-<?php echo esc_attr($name); ?>" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr($value); ?>" autocomplete="off" placeholder="<?php echo esc_attr($placeholder); ?>" />
    <a href="#" class="rad-make-id"><?php echo esc_html__("Renewal the ID", "aventa"); ?></a>
</div>
