<?php
$name        = $vars["key"];
$settings    = $vars["settings"];
$class       = rad_array_value("class", $settings); //Optional value
$checked     = rad_array_value("checked", $settings); //Optional value
$label       = rad_array_value("label", $settings); //Optional value
$description = rad_array_value("description", $settings); //Optional description
$value       = ((esc_attr($this->rad_GetValue($name)) == "") && (rad_array_value("value", $settings) != "")) ? rad_array_value("value", $settings) : esc_attr($this->rad_GetValue($name));

//remove -{id} from end of name of filed[just used in admin menu page] becouse in that page we make names unique by adding -{id}
$current_value = get_post_meta(get_the_ID(), rtrim($name, "-" . get_the_ID()), true);

?>

<div class="field checkbox-input <?php echo esc_attr($class); ?>" data-name="<?php echo esc_attr($name); ?>">
    <input type="checkbox" id="field-<?php echo esc_attr($name); ?>" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr($value); ?>" <?php if ($current_value != "") {echo "checked=\"checked\"";}?> />
	<?php if ($description != "") {?>
        <span class="description"><?php echo esc_html($description); ?></span>
    <?php }?>
	<?php if ($label != "") {?>
        <label for="field-<?php echo esc_attr($name); ?>"><?php echo esc_html($label); ?></label>
    <?php }?>

</div>
<?php if (strpos($class, "related") !== false) {?>
    <div class="clearfix"></div>
<?php }