<?php
require RAD_THEME_ADMIN . "/settings/template.php";

class Rad_FieldTemplate extends rad_Template
{
    /* @var IValueProvider $valueProvider */
    private $valueProvider = null;

    public function __construct(IValueProvider $valueProvider, $templatesDir = "")
    {
        $this->valueProvider = $valueProvider;
        parent::__construct($templatesDir);
    }

    public function rad_GetValue($key)
    {
        return $this->valueProvider->rad_GetValue($key);
    }

    public function GetField($key, array $settings, array $vars = null)
    {
        $params = array("key" => $key, "settings" => $settings);

        if ($vars != null) {
            $params = array_merge($vars, $params);
        }

        return $this->rad_GetTemplate($settings["type"] . "-field", $params);
    }
}
