<?php

if (class_exists("rad_Meta_Box")) {

    class Rad_Post extends rad_Meta_Box
    {
        public function __construct()
        {
            parent::__construct("post");
        }

        public function rad_EnqueueScripts()
        {
            wp_enqueue_script("hoverIntent");
            wp_enqueue_script("rad-jquery-easing");

            wp_enqueue_style("rad-nouislider-style");
            wp_enqueue_script("rad-nouislider-script");

            wp_enqueue_style("wp-color-picker");
            wp_enqueue_script("wp-color-picker");
            wp_enqueue_script("rad-colorpicker-alpha");
            wp_enqueue_script("rad-admin-posts", RAD_THEME_INC_URI . "/admin/assets/js/meta-boxes/post.js", array("jquery"), RAD_THEME_VERSION);

        }

        public function rad_OnProcessFieldForStore($post_id, $key, $settings)
        {
            //Process media field
            if ($key != "media") {
                return false;
            }

            $selectedOpt = $_POST[$key];

            switch ($selectedOpt) {
                case "image":
                    {
                        //delete video meta
                        delete_post_meta($post_id, "video-type");
                        delete_post_meta($post_id, "video-id");

                        $images = $_POST["gallery"];

                        update_post_meta($post_id, "gallery", $images);

                        break;
                    }
                case "video":
                    {
                        //Delete images
                        delete_post_meta($post_id, "image");

                        $videoType = $_POST["video-type"];
                        $videoId   = $_POST["video-id"];

                        update_post_meta($post_id, "video-type", $videoType);
                        update_post_meta($post_id, "video-id", $videoId);

                        break;
                    }
                default:
                    {
                        //Delete all
                        delete_post_meta($post_id, "video-type");
                        delete_post_meta($post_id, "video-id");
                        delete_post_meta($post_id, "image");

                        break;
                    }
            }

            return false;
        }

        protected function rad_GetOptions()
        {
            $fields = array(
                "video-type"     => array(
                    "type"    => "select",
                    "options" => array(
                        "vimeo"   => esc_html__("Vimeo", "aventa"),
                        "youtube" => esc_html__("YouTube", "aventa"),
                    ),
                ),
                "video-id"       => array(
                    "type"        => "text",
                    "placeholder" => esc_html__("Video URL", "aventa"),
                ), //video id
                "audio-url"      => array(
                    "type"        => "text",
                    "placeholder" => esc_html__("Audio URL", "aventa"),
                ), //Audio url
                "gallery"        => array(
                    "type"     => "upload",
                    "title"    => esc_html__("Gallery Image", "aventa"),
                    "referer"  => "rad-insert-image",
                    "multiple" => true,
                ), //gallery image
                "quote_content"  => array(
                    "type"        => "textarea",
                    "label"       => esc_html__("Quote", "aventa"),
                    "placeholder" => esc_html__("Quote", "aventa"),
                ), //Quote content
                "quote_author"   => array(
                    "type"        => "text",
                    "label"       => esc_html__("Quote author", "aventa"),
                    "placeholder" => esc_html__("Author", "aventa"),
                ), //Quote author
                "quote_color"    => array(
                    "type"  => "color",
                    "label" => esc_html__("Quote text color", "aventa"),
                ), //Quote color
                "quote_bg_color" => array(
                    "type"  => "color",
                    "label" => esc_html__("Quote background color", "aventa"),
                ), //Quote color
                "link_url"       => array(
                    "type"        => "text",
                    "label"       => esc_html__("link", "aventa"),
                    "placeholder" => esc_html__("Enter the link", "aventa"),
                ), //Quote author
                "extra_class"    => array(
                    "type"        => "text",
                    "label"       => esc_html__("Extra Class Name", "aventa"),
                    "placeholder" => esc_html__("class name ex: class1 class2", "aventa"),
                ), // Extra class name
            );

            //Option sections
            $options = array(
                "video"       => array(
                    "title"   => esc_html__("Post Video", "aventa"),
                    "tooltip" => esc_html__("Copy and paste your browser URL in this section to automatically load a video into your post. Additional information can be uploaded in the content area.", "aventa"),
                    "fields"  => array(
                        "video-type" => $fields["video-type"],
                        "video-id"   => $fields["video-id"],
                    ),
                ), //Video sec
                "audio"       => array(
                    "title"   => esc_html__("SoundCloud url", "aventa"),
                    "tooltip" => esc_html__("Copy the URL of an audio that is uploaded on the SoundCloud.", "aventa"),
                    "fields"  => array(
                        "audio-url" => $fields["audio-url"],
                    ),
                ), //Audio sec
                "gallery"     => array(
                    "title"   => esc_html__("Post Gallery", "aventa"),
                    "tooltip" => esc_html__("Select images of post gallery", "aventa"),
                    "fields"  => array(
                        "gallery" => $fields["gallery"],
                    ),
                ), //Gallery sec
                "quote"       => array(
                    "title"   => esc_html__("Quote", "aventa"),
                    "tooltip" => esc_html__("Type down quote information", "aventa"),
                    "fields"  => array(
                        "quote_content"  => $fields["quote_content"],
                        "quote_author"   => $fields["quote_author"],
                        "quote_color"    => $fields["quote_color"],
                        "quote_bg_color" => $fields["quote_bg_color"],
                    ),
                ), //Quote sec
                "link"        => array(
                    "title"   => esc_html__("Link URL", "aventa"),
                    "tooltip" => esc_html__("Enter the link of the post", "aventa"),
                    "fields"  => array(
                        "link_url" => $fields["link_url"],
                    ),
                ), //Quote sec
                "extra_class" => array(
                    "title"   => esc_html__("Extra Class name", "aventa"),
                    "tooltip" => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS. use space between diffrent class name", "aventa"),
                    "fields"  => array(
                        "extra_class" => $fields["extra_class"],
                    ),
                ), //Extra Class name
            );

            return array(
                array(
                    "id"       => "post_meta_box",
                    "title"    => esc_html__("Settings", "aventa"),
                    "context"  => "normal",
                    "priority" => "default",
                    "options"  => $options,
                ), //Meta box
            );
        }
    }

    new rad_Post();
}
