<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 

class Rad_Toggle_Block_Widget extends Widget_Base{

  public function get_name() {
    return "rad-toggle-block";
  }

  public function get_title() {
    return esc_html__("Toggle Block", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-toggle";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Toggle Block", "aventa" ),
			]
		);

    // Toggle title
		$this->add_control(
			"toggle_title", 
      [
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html__( "Toggle Title" , "aventa" ),
        "separator" => "after"
			]
		);

    // Toggle content
		$this->add_control(
			"toggle_content", [
				"label" => esc_html__( "Content", "aventa" ),
				"type" => Controls_Manager::WYSIWYG,
				"default" => esc_html__( "Toggle content. Click the edit button to change this text." , "aventa" ),
			]
		);

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // Toggle open/close switcher
    $this->add_control(
      "toggle_open",
      [
        "label" => esc_html__( "Open by Default?", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
      ]
    );

    // Toggle alignment
    Rad_Helpers::alignment( $this, "toggle_alignment", [], ["left", "right"], "left", false );

    // Toggle title color
    $this->add_control(
      "toggle_title_color",
      [
        "label" => esc_html__( "Title Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .toggle-block .title" => "color: {{VALUE}}",
        ],
        "default" => "#000",
      ]
    );

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if (
      !$settings[ "toggle_title" ]    &&
      !$settings[ "toggle_content" ]
    ) {
			return;
		}

    $classes = [ 
      "toggle-block", 
      "resp-block"
    ];

    // User inputs
		$title            = esc_html( $settings[ "toggle_title" ] );
		$content          = esc_html( $settings[ "toggle_content" ] );
		$alignment        = esc_html( $settings[ "toggle_alignment" ] );
		$is_toggle_open   = esc_html( $settings[ "toggle_open" ] );

    // Assign proper class based on selected options
    $classes[] = $alignment;
    if ( $is_toggle_open ) {
      $classes[] = "open";
    }

    // Element attributes
		$this->add_render_attribute( "toggle_wrapper", "class", implode( " ", array_map( "esc_attr", $classes ) ) );
		$this->add_render_attribute( "toggle_title", "class", "title" );
		$this->add_render_attribute( "toggle_content", "class", "toggle-content" );

    $this->add_inline_editing_attributes( "toggle_title", "none" );
    $this->add_inline_editing_attributes( "toggle_content", "advanced" );

    // HTML elements
    $title_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "span",
      $this->get_render_attribute_string( "toggle_title" ),
      $title
    );

    $content_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div",
      $this->get_render_attribute_string( "toggle_content" ),
      $content
    );

    // Final HTML to render
    $html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>',
      "div",
      $this->get_render_attribute_string( "toggle_wrapper" ),
      $title_html . $content_html
    );

    echo "$html";
  }

}