<?php

namespace Aventa;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 

class Rad_Team_Member_Widget extends Widget_Base{

  public function get_name() {
    return "rad-team-member";
  }

  public function get_title() {
    return esc_html__("Team Member", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-person";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Team Member", "aventa" ),
			]
		);

    // Team member name
		$this->add_control(
			"tm_name", [
				"label" => esc_html__( "Name", "aventa" ),
				"type" => Controls_Manager::TEXT,
				"default" => esc_html__( "John Doe" , "aventa" ),
			]
		);

    // Team member job
		$this->add_control(
			"tm_job", [
				"label" => esc_html__( "Job", "aventa" ),
				"type" => Controls_Manager::TEXT,
				"default" => esc_html__( "Developer" , "aventa" )
			]
		);

    // Team member image
    $this->add_control(
			"tm_image",
			[
				"label" => esc_html__( "Image", "aventa" ),
				"type" => Controls_Manager::MEDIA,
				"default" => [
					"url" => Utils::get_placeholder_image_src(),
				],
        "separator" => "before"
			]
		); 

    // Team member link
    $this->add_control(
      "tm_image_has_link",
      [
        "label" => esc_html__( "Is Clickable?", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
        "description" => esc_html__( "Opens a URL when you click on the image.", "aventa" ),
				"default" => ""
      ]
    );

		Rad_Helpers::link( 
      $this,
      "tm_link", 
      esc_html__( "Link Title", "aventa" ), 
      esc_html__( "Link URL", "aventa" ),
      [
        "tm_image_has_link" => "true"
      ]
    );

    $this->add_control( 
      "socials_separator", 
      ["type" => Controls_Manager::DIVIDER]
    );

    // Socials
    Rad_Helpers::social_control( $this, "tm_socials" );

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // Social style
    $this->add_control(
      "tm_style",
      [
        "label" => esc_html__( "Style", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "light" => esc_html__( "Light", "aventa" ),
          "dark" => esc_html__( "Dark", "aventa" )
        ],
        "default" => "dark"
      ]
    );

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if (
      !$settings[ "tm_name" ]    &&
      !$settings[ "tm_job" ]    &&
      !$settings[ "tm_image" ]
    ) {
			return;
		}

    $classes = [ 
      "team-member",
      "resp-block"
    ];

    // User inputs
		$name           = esc_html( $settings[ "tm_name" ] );
		$job            = esc_html( $settings[ "tm_job" ] );
		$image          = $settings[ "tm_image" ];
		$style          = esc_html( $settings[ "tm_style" ] );
		$image_has_link = esc_html( $settings[ "tm_image_has_link" ] );
		$socials        = $settings[ "tm_socials" ];

    $image_link = "";
    if ( $image_has_link ) {
      $link           =  $settings[ "tm_link_url" ] ;
      $link_title     =  esc_html( $settings[ "tm_link_title" ] );
      $link_url       =  esc_url( $link[ "url" ] );
      $link_target    =  $link[ "is_external" ] ? "_blank" : "";
      $link_nofollow  =  $link[ "nofollow" ]    ? "nofollow" : "";

		  $this->add_render_attribute( "tm_image_link", "title", $link_title);
		  $this->add_render_attribute( "tm_image_link", "href", $link_url);
		  $this->add_render_attribute( "tm_image_link", "target", $link_target);
		  $this->add_render_attribute( "tm_image_link", "rel", $link_nofollow);

      $image_link = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>', 
        "a",
        $this->get_render_attribute_string( "tm_image_link" ),
        $link_title
      );
    }

    // Assign proper class based on selected options
    $classes[] = $style;

    // Element attributes
		$this->add_render_attribute( "tm_wrapper", "class", implode( " ", array_map( "esc_attr", $classes ) ) );
		$this->add_render_attribute( "tm_image_wrapper", "class", "member-img-wrapper" );
		$this->add_render_attribute( "tm_image", "class", "member-img" );
		$this->add_render_attribute( "tm_info_wrapper", "class", "member-info" );
		$this->add_render_attribute( "tm_name", "class", "member-name" );

    // Get socials
    $socials_html = "";
    if ( $socials ) {

      // Holds each individual social
      $social_items_array = []; 
      
      // Socials wrapper attributes
      $this->add_render_attribute( "tm_socials_wrapper", "class", "social-icons horizontal $style-style icon-type" );

      foreach ( $socials as $social ) {
        $is_custom_social = esc_html( $social[ "tm_socials_is_custom" ] );

        $social_url     = esc_url( $social[ "tm_socials_url" ][ "url" ] );
        $social_target  =  $social[ "tm_socials_url" ] ? "_blank" : "";

        if ( !$is_custom_social ) {
          $social_name    = esc_html( $social[ "tm_socials_name" ] );
          $social_icon    = \Rad_Icon_Manager::get_icon( $social_name, "all" );
        } else {
          $social_name    =   esc_html( $social[ "tm_socials_custom_name" ] );
          $social_icon    =   $social[ "tm_socials_custom_icon" ][ "id" ] 
            ? wp_get_attachment_image( esc_html( $social[ "tm_socials_custom_icon" ][ "id" ] ) ) 
            : Rad_Helpers::get_placeholder_image();
        }

        $this->add_render_attribute( "tm_social_item", "class", "$social_name-icon", true );
        $this->add_render_attribute( "tm_social_item", "href", $social_url, true );
        $this->add_render_attribute( "tm_social_item", "target", $social_target, true );

        $social_item  =  sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "a",
          $this->get_render_attribute_string( "tm_social_item" ),
          $social_icon . $social_name
        );

        $social_items_array[] = $social_item;
      }

      $socials_html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>', 
        "span",
        $this->get_render_attribute_string( "tm_socials_wrapper" ),
        implode( "", $social_items_array )
      );
    }

    // HTML elements
    $image_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div",
      $this->get_render_attribute_string( "tm_image" ),
      ( $image["id"] ) // If image is set show it, otherwise show placeholder
        ? wp_get_attachment_image( esc_html( $image["id"] ), "medium" ) 
        : Rad_Helpers::get_placeholder_image()
    );

    $image_wrapper_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div",
      $this->get_render_attribute_string( "tm_image_wrapper" ),
      $image_html . $image_link
    );

    $name_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "span",
      $this->get_render_attribute_string( "tm_name" ),
      $name
    );

    $job_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "cite",
      $this->get_render_attribute_string( "tm_job" ),
      $job
    );

    $info_wrapper_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div",
      $this->get_render_attribute_string( "tm_info_wrapper" ),
      $socials_html . $name_html . $job_html
    );

    // Final HTML to render
    $html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>',
      "div",
      $this->get_render_attribute_string( "tm_wrapper" ),
      $image_wrapper_html . $info_wrapper_html
    );

    echo "$html";

  }

}