<?php

namespace Aventa;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 


class Rad_Tab_Block_Widget extends Widget_Base{

  public function get_name() {
    return "rad-tab-block";
  }

  public function get_title() {
    return esc_html__("Tab Block", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-tabs";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Tab Block", "aventa" ),
			]
		);

    // Tab title
		$this->add_control(
			"tab_title", 
      [
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXT,
			]
		);

    // Tab active item
		$this->add_control(
			"tab_active_item", 
      [
				"label" => esc_html__( "Active Item", "aventa" ),
				"type" => Controls_Manager::NUMBER,
        "separator" => "after",
        "default" => 0
			]
		);

    // Tab item fields
    $tab_item = new Repeater();

    // Tab item icon
    $tab_item->add_control(
      "tab_show_icon",
      [
        "label" => esc_html__( "Show Icon?", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
      ]
    );

    $tab_item->add_control(
      "tab_icon", 
      [
        "label" => esc_html__( "Icon", "aventa" ),
        "type" => Rad_Icons_Control::TYPE,
        "default" => "smile",
        "condition" => [
          "tab_show_icon" => "true"
        ]
      ]
    );

    // Tab item title
		$tab_item->add_control(
			"tab_item_title", 
      [
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html__( "Item Title" , "aventa" ),
        "separator" => "after"
			]
		);

    // Tab item content
		$tab_item->add_control(
			"tab_item_content", [
				"label" => esc_html__( "Content", "aventa" ),
				"type" => Controls_Manager::WYSIWYG,
				"default" => esc_html__( "Item content. Click the edit button to change this text." , "aventa" ),
			]
		);

    // Tab item repeater
		$this->add_control(
			"tab_items",
			[
				"label" => esc_html__( "Tab Items", "aventa" ),
				"type" => Controls_Manager::REPEATER,
				"fields" => $tab_item->get_controls(),
				"default" => [
					[
						"tab_item_title" => esc_html__( 'Item #1', "aventa" ),
						"tab_item_content" => esc_html__( "Item content. Click the edit button to change this text.", "aventa"),
					],
					[
						"tab_item_title" => esc_html__( 'Item #2', "aventa" ),
						"tab_item_content" => esc_html__( "Item content. Click the edit button to change this text.", "aventa"),
					],
				],
				"title_field" => "{{{ tab_item_title }}}",
			]
		);

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // Tab icon position
    $this->add_control(
      "tab_icon_position",
      [
        "label" => esc_html__( "Icon Position", "aventa" ),
        "type" => Controls_Manager::CHOOSE,
        "options" => [
          "i-left" => [
            "title" => esc_html__( "Left", "aventa" ),
            "icon" => "eicon-h-align-left",
          ],
          "i-top" => [
            "title" => esc_html__( "Top", "aventa" ),
            "icon" => "eicon-v-align-top",
          ],
          "i-right" => [
            "title" => esc_html__( "Right", "aventa" ),
            "icon" => "eicon-h-align-right",
          ]
        ],
        "default" => "i-top"
      ]
    );

    // Tab alignment
    Rad_Helpers::alignment($this, "tab_alignment", [], [], "left", false);

    // Tab style
    $this->add_control(
      "tab_hover_style",
      [
        "label" => esc_html__( "Hover Style", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "color-style" => esc_html__( "Change Color", "aventa" ),
          "line-style" => esc_html__( "Show Line", "aventa" ),
        ],
        "default" => "color-style"
      ]
    );

		$this->end_controls_section();

    // Title style
    $this->start_controls_section(
      "section_title_style",
      [
        "label" => esc_html__( "Title", "aventa" ),
        "tab" => Controls_Manager::TAB_STYLE,
      ]
    );

    // Tab title tag
    Rad_Helpers::heading_tag( $this, "title_tag" );

    // Tab title typography
    Rad_Helpers::typography( $this, "title_typography", ".tab-block .title" );

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( 
      !$settings[ "tab_title" ] &&
      !$settings[ "tab_items" ]
    ) {
			return;
		}

    $classes = [ 
      "tab-block", 
      "resp-block"
    ];

    // User inputs
		$tab_items        = $settings[ "tab_items" ];
		$tab_title        = esc_html( $settings[ "tab_title" ] );
		$alignment        = esc_html( $settings[ "tab_alignment" ] );
    $hover_style      = esc_html( $settings[ "tab_hover_style" ] );
    $icon_position    = esc_html( $settings[ "tab_icon_position" ] );
    $active_item      = is_numeric( $settings[ "tab_active_item" ] )
      ? esc_html( $settings[ "tab_active_item" ] )
      : 0 ;

    // Assign proper class based on selected options
    $classes[] = $alignment;
    $classes[] = $hover_style;
    $classes[] = $icon_position;

    // Element attributes
		$this->add_render_attribute( "tab_block_wrapper", "class", implode( " ", array_map( "esc_attr", $classes ) ) );
		$this->add_render_attribute( "tab_title", "class", "title" );
		$this->add_render_attribute( "tab_nav_wrapper", "class", "tab-nav" );
		$this->add_render_attribute( "tab_contents_wrapper", "class", "tab-contents" );
		$this->add_render_attribute( "tab_content", "class", "tab-content" );

    // HTML elements
    if ( $tab_items ) {
      // nav and contents array holds html code of each individual tab item
      $nav_array = [];
      $contents_array = [];

			foreach (  $tab_items as $key => $tab_item ) {
        // Add active class to the first item, and remove it from others
        if ( $key == $active_item ) {
          $this->add_render_attribute( "tab_nav_item", "class", "active" );
          $this->add_render_attribute( "tab_content", "class", "active" );
        } else if ( $key == $active_item + 1 ) {
          $this->remove_render_attribute( "tab_nav_item", "class", "active" );
          $this->remove_render_attribute( "tab_content", "class", "active" );
        }

        $this->add_render_attribute( "tab_nav_item", "data-id", $key, true );
        
        $title    = esc_html( $tab_item[ "tab_item_title" ] );
        $content  = $tab_item[ "tab_item_content" ];
        $has_icon = esc_html( $tab_item[ "tab_show_icon" ] );
        $icon 	  = ( $has_icon )
          ? \Rad_Icon_Manager::get_icon( 
            esc_html( $tab_item[ "tab_icon" ] ), 
            "all"
          )
          : null;

        // Add icon to the title based on position
        $title = ( $icon_position == "i-right" )
          ? $title . $icon    // Icon right 
          : $icon . $title;   // Icon top or left

        $nav_item_html = sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "li",
          $this->get_render_attribute_string( "tab_nav_item" ),
          $title
        );

        $content_html = sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "div",
          $this->get_render_attribute_string( "tab_content" ),
          $content
        );

        $nav_array[]        = $nav_item_html;
        $contents_array[]   = $content_html;
			}

      // Tab title
      $title_html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>', 
        Utils::validate_html_tag( $settings[ "title_tag" ] ), 
        $this->get_render_attribute_string( "tab_title" ), 
        $tab_title
      );

      // Tab nav wrapper
      $nav_wrapper_html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>', 
        "ul",
        $this->get_render_attribute_string( "tab_nav_wrapper" ),
        implode( "", $nav_array )
      );

      // Tab contents wrapper
      $contents_wrapper_html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>', 
        "div",
        $this->get_render_attribute_string( "tab_contents_wrapper" ),
        implode( "", $contents_array )
      );

      // Final HTML to render
      $html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>',
        "div",
        $this->get_render_attribute_string( "tab_block_wrapper" ),
        $title_html . $nav_wrapper_html . $contents_wrapper_html
      );
  
      echo "$html";
		}

  }

}