<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 

class Rad_Social_Icons_Widget extends Widget_Base{

  public function get_name() {
    return "rad-social-icons";
  }

  public function get_title() {
    return esc_html__("Social Icons", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-social-icons";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Social Icons", "aventa" ),
			]
		);

    // Socials
    Rad_Helpers::social_control( $this, "si_socials" );

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // Social type
    $this->add_control(
      "si_type",
      [
        "label" => esc_html__( "Type", "aventa" ),
        "type" => Controls_Manager::CHOOSE,
        "options" => [
          "icon-type" => [
            "title" => esc_html__( "Icon", "aventa" ),
            "icon" => "eicon-facebook"
          ],
          "text-type" => [
            "title" => esc_html__( "Text", "aventa" ),
            "icon" => "eicon-link"
          ]
        ],
        "default" => "icon-type"
      ]
    );
    
    // Social style
    $this->add_control(
      "si_style",
      [
        "label" => esc_html__( "Style", "aventa" ),
        "type" => Controls_Manager::CHOOSE,
        "options" => [
          "light-style" => [
            "title" => esc_html__( "Light", "aventa" ),
            "icon" => "fas fa-sun"
          ],
          "dark-style" => [
            "title" => esc_html__( "Dark", "aventa" ),
            "icon" => "fas fa-moon"
          ]
        ],
        "default" => "dark-style"
      ]
    );

    // Social direction
    $this->add_control(
      "si_direction",
      [
        "label" => esc_html__( "Direction", "aventa" ),
        "type" => Controls_Manager::CHOOSE,
        "options" => [
          "horizontal" => [
            "title" => esc_html__( "Horizontal", "aventa" ),
            "icon" => "eicon-ellipsis-h"
          ],
          "vertical" => [
            "title" => esc_html__( "Vertical", "aventa" ),
            "icon" => "eicon-ellipsis-v"
          ]
        ],
        "default" => "horizontal"
      ]
    );

    // Does social have background or not
    $this->add_control(
      "si_has_background",
      [
        "label" => esc_html__( "Has Background?", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
        "separator" => "before"
      ]
    );

    // Background color
    $this->add_control(
      "si_background_color",
      [
        "label" => esc_html__( "Background Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .social-icons" => "background-color: {{VALUE}}",
        ],
        "condition" => [
          "si_has_background" => "true"
        ]
      ]
    );

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( !$settings[ "si_socials" ] ) {
			return;
		}

    $classes = [ "social-icons" ];

    // User inputs
		$type        = esc_attr( $settings[ "si_type" ] );
		$style       = esc_attr( $settings[ "si_style" ] );
		$direction   = esc_attr( $settings[ "si_direction" ] );
		$socials     = $settings[ "si_socials" ];

    // Assign proper class based on selected options
    $classes[] = $type;
    $classes[] = $style;
    $classes[] = $direction;

    // Element attributes
		$this->add_render_attribute( "si_socials_wrapper", "class", implode( " ", array_map( "esc_attr", $classes ) ) );
    if ( $type == "text-type" ) {
      $this->add_render_attribute( "si_social_item", "class", "underline-style" );
    } else {
      $this->remove_render_attribute( "si_social_item", "class", "underline-style" );
    }

    // Get socials
    if ( $socials ) {

      // Holds each individual social
      $social_items_array = []; 
      
      foreach ( $socials as $social ) {
        $is_custom_social = esc_html( $social[ "si_socials_is_custom" ] );

        $social_url     = esc_url( $social[ "si_socials_url" ][ "url" ] );
        $social_target  =  $social[ "si_socials_url" ] ? "_blank" : "";

        if ( !$is_custom_social ) {
          $social_name    = esc_html( $social[ "si_socials_name" ] );
          $social_icon    = \Rad_Icon_Manager::get_icon( $social_name, "all" );
        } else {
          $social_name    =   esc_html( $social[ "si_socials_custom_name" ] );
          $social_icon    =   $social[ "si_socials_custom_icon" ][ "id" ] 
            ? wp_get_attachment_image( esc_html( $social[ "si_socials_custom_icon" ][ "id" ] ) ) 
            : Rad_Helpers::get_placeholder_image();
        }

        $this->add_render_attribute( "si_social_item", "id", "$social_name-icon", true );
        $this->add_render_attribute( "si_social_item", "href", $social_url, true );
        $this->add_render_attribute( "si_social_item", "target", $social_target, true );

        $social_content = ( $type == "text-type" ) ? $social_name : $social_icon;
        $social_item  =  sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "a",
          $this->get_render_attribute_string( "si_social_item" ),
          $social_content
        );

        $social_items_array[] = $social_item;
      }

    // Final HTML to render
      $html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>', 
        "span",
        $this->get_render_attribute_string( "si_socials_wrapper" ),
        implode( "", $social_items_array )
      );
      
      echo "$html";
    }

  }

}