<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 


class Rad_Progress_Bar_Widget extends Widget_Base{

  public function get_name() {
    return "rad-progress-bar";
  }

  public function get_title() {
    return esc_html__("Progress Bar", "aventa");
  }

	public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-skill-bar";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Progress Bar", "aventa" ),
			]
		);

    // Progress Bar title
    $this->add_control(
			"progress_bar_title",
			[
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXT,
				"default" => esc_html__( "Progress Bar Title", "aventa" ),
			]
		);

    // Progress Bar percentage
    $this->add_control(
			"progress_bar_percentage",
			[
				"label" => esc_html__( "Percentage", "aventa" ),
				"type" => Controls_Manager::NUMBER,
				"min" => 0,
				"max" => 100,
				"step" => 1,
				"default" => 85,
      ]
		);

		$this->end_controls_section();

    // Title style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "Title", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

		// Title color
		$this->add_control(
			"title_color",
			[
				"label" => esc_html__( "Title Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"default" => "#000",
				"selectors" => [
					"{{WRAPPER}} .progress-bar-block .title" => "color: {{VALUE}}", 
          "{{WRAPPER}} .progress-bar-block .value" => "color: {{VALUE}}",
				],
			]
		);

		$this->end_controls_section();


		// Progress Bar style
		$this->start_controls_section(
			"section_progress_bar_style",
			[
				"label" => esc_html__( "Progress Bar", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // Progress bar active color
    $this->add_control(
			"active_bar_color",
			[
				"label" => esc_html__( "Active Bar Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"default" => "#000",
				"selectors" => [
					"{{WRAPPER}} .progress-bar-block .fill" => "background-color: {{VALUE}};",
				],
			]
		);

    // Progress bar inactive color
    $this->add_control(
			"inactive_bar_color",
			[
				"label" => esc_html__( "Inactive Bar Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"default" => "#bbb",
				"selectors" => [
					"{{WRAPPER}} .progress-bar-block .bar" => "background-color: {{VALUE}};",
				],
			]
		);

		$this->end_controls_section();

  }
  

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( "" === $settings["progress_bar_title"] && "" === $settings["progress_bar_percentage"] ) {
			return;
		}

    $classes = [ 
      "progress-bar-block",
      "resp-block",
    ];

		// User inputs
		$title 		      = esc_html( $settings[ "progress_bar_title" ] );
		$percentage 		= esc_html( $settings[ "progress_bar_percentage" ] );

    // Element attributes
		$this->add_render_attribute( "progress_bar_title", "class", "title" );
		$this->add_render_attribute( "progress_bar_percentage", "class", "value" );
		$this->add_render_attribute( "active_bar", "class", "fill" );
		$this->add_render_attribute( "active_bar", "style", "width: $percentage%" );
		$this->add_render_attribute( "active_bar", "data-percentage", $percentage );
		$this->add_render_attribute( "inactive_bar", "class", "bar" );

		// HTML elements
		$title_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "span", 
      $this->get_render_attribute_string( "progress_bar_title" ), 
      $title
    );

		$percentage_html = sprintf(
      '<%1$s %2$s>%3$s</%1$s>', 
      "span", 
      $this->get_render_attribute_string( "progress_bar_percentage" ), 
      "$percentage%"
    );

		$inactive_bar_html = sprintf(
      '<%1$s %2$s></%1$s>', 
      "span", 
      $this->get_render_attribute_string( "active_bar" ) 
    );

		$active_bar_html = sprintf(
      '<%1$s %2$s></%1$s>', 
      "span", 
      $this->get_render_attribute_string( "inactive_bar" )
    );

    // Final HTML to render
    $html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div", 
      "class='" . implode( " ", array_map( "esc_attr", $classes ) ) . "'",
      $title_html . $percentage_html . $inactive_bar_html . $active_bar_html
    );

    echo "$html";
  }

}