<?php
namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( "ABSPATH" ) ) {
	exit; // Exit if accessed directly
}

class Rad_Product_Page_Widget extends Widget_Base {

	public function get_name() {
		return "rad-product-page";
	}

	public function get_title() {
		return esc_html__( "Product Page", "aventa" );
	}

	public function get_icon() {
		return "eicon-product-description";
	}

	public function get_keywords() {
		return [ "woocommerce", "shop", "store", "product", "aventa" ];
	}

	public function get_categories() {
		return [ Rad_Helpers::WC_WIDGETS_CATEGORY ];
	}

	protected function register_controls() {
    $this->start_controls_section(
      "section_content",
			[
				"label" => esc_html__( "Product Page", "aventa" )
			]
    );

    $this->add_control(
			"pp_product_id",
			[
				"label"         => esc_html__( "Product", "aventa" ),
				"type"          => Controls_Manager::SELECT2,
				"options"       => Rad_Helpers::get_products(),
        "description"   => esc_html__( "Search products by id or title.", "aventa" )
			]
		);

    $this->end_controls_section();

	}

	protected function render() {
    $settings = $this->get_settings();
    $product_id = esc_attr( $settings[ "pp_product_id" ] );

    if ( !$product_id ) { return; }

    $html = do_shortcode( "[product_page id='$product_id']" );
    echo "$html";
	}

}
