<?php
namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( "ABSPATH" ) ) {
	exit; // Exit if accessed directly
}

class Rad_Order_Tracking_Form_Widget extends Widget_Base {

	public function get_name() {
		return "rad-order-tracking-form";
	}

	public function get_title() {
		return esc_html__( "Order Tracking Form", "aventa" );
	}

	public function get_icon() {
		return "eicon-form-horizontal";
	}

	public function get_keywords() {
		return [ "woocommerce", "shop", "store", "order", "track", "aventa" ];
	}

	public function get_categories() {
		return [ Rad_Helpers::WC_WIDGETS_CATEGORY ];
	}

	protected function register_controls() {
    $this->start_controls_section(
      "section_content",
			[
				"label" => esc_html__( "Order Tracking Form", "aventa" )
			]
    );

    $this->add_control(
			"wc_notice_frontpage",
			[
				"type" => Controls_Manager::RAW_HTML,
				"raw" => esc_html__( "There are no customization options available for this widget.", "aventa" ),
				"content_classes" => "elementor-panel-alert elementor-panel-alert-info"
			]
		);

    $this->end_controls_section();
	}

	protected function render() {
    $html = do_shortcode( "[woocommerce_order_tracking]" );
    echo "$html";
	}

}
