<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 


class Rad_link_Widget extends Widget_Base{

  public function get_name() {
    return "rad-link";
  }

  public function get_title() {
    return esc_html__("Link", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-link";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Link", "aventa" ),
			]
		);

    Rad_Helpers::link( 
      $this, 
      "link",
      esc_html__( "Title", "aventa" ), 
      esc_html__( "URL", "aventa" )
    );

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    Rad_Helpers::alignment( $this, "link_alignment" );

    $this->add_control(
      "link_display",
      [
        "label" => esc_html__( "Display", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "inline"     => esc_html__( "Inline", "aventa" ),
          "block"     => esc_html__( "Block", "aventa" )
        ],
        "default" => "inline"
      ]
    );

    $this->start_controls_tabs( "tabs_link_style" );

		$this->start_controls_tab(
			"tab_link_normal",
			[
				"label" => esc_html__( "Normal", "aventa" ),
			]
		);

    $this->add_control(
      "link_text_color",
      [
        "label" => esc_html__( "Text Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .rad_link" => "color: {{VALUE}}"
        ],
        "default" => "#000"
      ]
    );

		$this->end_controls_tab();

		$this->start_controls_tab(
			"tab_link_hover",
			[
				"label" => esc_html__( "Hover", "aventa" ),
			]
		);


    $this->add_control(
      "link_text_hover",
      [
        "label" => esc_html__( "Text Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .rad_link:hover" => "color: {{VALUE}}"
        ],
        "default" => "#555"
      ]
    );

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( "" === $settings["link_title"] ) {
			return;
		}

    $classes = [ 
      "rad_link",
      "underline-style",
      "init-show",
      "resp-block"
    ];

    // User inputs
		$title 		      = esc_html( $settings[ "link_title" ] );
		$link 		      = $settings[ "link_url" ];
		$alignment      = $settings[ "link_alignment" ];
		$display 		    = $settings[ "link_display" ];

    // Assign proper class based on display mode
    $classes[] = "link-$alignment";
    $classes[] = "link-$display";    

    // Element attributes
		$this->add_render_attribute( "link", "class", implode( " ", $classes ) );
		$this->add_render_attribute( "link", "title", $title );
		$this->add_render_attribute( "link_title", "class", "txt" );
    
    if ( $link ) {
      $link_url       =  esc_url( $link[ "url" ] );
      $link_target    =  $link[ "is_external" ] ? "_blank" : "";
      $link_nofollow  =  $link[ "nofollow" ]    ? "nofollow" : "";

		  $this->add_render_attribute( "link", "href", $link_url);
		  $this->add_render_attribute( "link", "target", $link_target);
		  $this->add_render_attribute( "link", "rel", $link_nofollow);
    }

    $title_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "span",
      $this->get_render_attribute_string( "link_title" ),
      $title
    );

    $html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "a",
      $this->get_render_attribute_string( "link" ),
      $title_html
    );

    $html .= "<div class='rad-link-clearfix'></div>";

    echo "$html";
  }

}