<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 


class Rad_Icon_Block_Widget extends Widget_Base{

  public function get_name() {
    return "rad-icon-block";
  }

  public function get_title() {
    return esc_html__("Icon Block", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-favorite";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Icon Block", "aventa" ),
			]
		);

    // Icon selector
    $this->add_control(
      "icon",
      [
        "label" => esc_html__( "Icon", "aventa" ),
        "type" => Rad_Icons_Control::TYPE,
        "default" => "acorn",
      ]
    );

    $this->add_control(
			"content_divider",
			[ "type" => Controls_Manager::DIVIDER ]
		);

    // Icon title
    $this->add_control(
			"icon_title",
			[
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXT,
				"default" => esc_html__( "Icon Title", "aventa" ),
			]
		);

    // Icon subtitle
    $this->add_control(
			"icon_subtitle",
			[
				"label" => esc_html__( "Subtitle", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html( "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua." ),
			]
		);

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // Icon position
    $this->add_control(
      "icon_position",
      [
        "label" => esc_html__( "Icon Position", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "top"  => esc_html__( "Top", "aventa" ),
          "left"        => esc_html__( "Left", "aventa" ),
          "right"        => esc_html__( "Right", "aventa" ),
        ],
        "default" => "top",
      ]
    );

    // Icon alignment
    Rad_Helpers::alignment( 
      $this, 
      "icon_alignment", 
      [
        "icon_position" => "top"
      ]
    );

		$this->end_controls_section();

    // Icon style
    $this->start_controls_section(
			"section_icon_style",
			[
				"label" => esc_html__( "Icon", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // Icon size
    Rad_Helpers::slider(
      $this,
      "icon_size",
      esc_html__( "Icon Size", "aventa" ),
			[
        "{{WRAPPER}} .icon-block .icon" => "height: calc({{SIZE}}{{UNIT}} + 30px);" . "width: calc({{SIZE}}{{UNIT}} + 30px);",
        "{{WRAPPER}} .icon-block .icon svg" => "width: {{SIZE}}{{UNIT}};",
      ],
      40,
      [ "min" => 15, "max" => 150, "step" => 1 ]
    );

    // Icon color
    $this->add_control(
      "icon_color",
      [
        "label" => esc_html__( "Icon Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .icon-block .icon" => "fill: {{VALUE}}",
        ],
        "default" => "#000"
      ]
    );

    // Icon color on hover
    $this->add_control(
      "icon_color_hover",
      [
        "label" => esc_html__( "Icon Color on Hover", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .icon-block:hover .icon" => "fill: {{VALUE}}",
        ],
        "separator" => "after"
      ]
    );

    // Icon background border radius
    Rad_Helpers::slider(
      $this,
      "icon_bg_border_radius",
      esc_html__( "Background Border Radius", "aventa" ),
      [
        "{{WRAPPER}} .icon-bg" => "border-radius: {{SIZE}}{{UNIT}}",
      ],
      5,
      [ "min" => 0, "max" => 100, "step" => 1 ]
    );

    // Icon background
    $this->add_control(
      "icon_bg",
      [
				"label" => esc_html__( "Background Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"selectors" => [
					"{{WRAPPER}} .icon-block .icon .icon-bg" => "background: {{VALUE}}",
				]
			]
    );

    // Icon background on hover
    $this->add_control(
      "icon_bg_color_hover",
      [
				"label" => esc_html__( "Background Color on Hover", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"selectors" => [
					"{{WRAPPER}} .icon-block:hover .icon-bg" => "background: {{VALUE}}",
				],
        "separator" => "after"
			]
    );

    
    // Icon border color
    $this->add_control(
      "icon_border_color",
      [
				"label" => esc_html__( "Border Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"selectors" => [
					"{{WRAPPER}} .icon-bg" => "border-color: {{VALUE}}",
				]
			]
    );

    // Icon border color on hover
    $this->add_control(
      "icon_border_color_hover",
      [
				"label" => esc_html__( "Border Color on Hover", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"selectors" => [
					"{{WRAPPER}} .icon-block:hover .icon-bg" => "border-color: {{VALUE}}",
				]
			]
    );

		$this->end_controls_section();


    // Title styles
    $this->start_controls_section(
      "section_title_style",
      [
        "label" => esc_html__( "Title", "aventa" ),
        "tab" => Controls_Manager::TAB_STYLE,
      ]
    );

    // Title size
    Rad_Helpers::slider(
      $this,
      "icon_title_size",
      esc_html__( "Title Size", "aventa" ),
      [ "{{WRAPPER}} .icon-block .content h4" => "font-size: {{SIZE}}{{UNIT}}" ],
      20,
      [ "min" => 15, "max" => 70, "step" => 1 ]
    );

    // Icon border color on hover
    $this->add_control(
      "icon_title_color",
      [
        "label" => esc_html__( "Title Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .icon-block .content h4" => "color: {{VALUE}}",
        ]
      ]
    );

		$this->end_controls_section();


    // Subtitle styles
    $this->start_controls_section(
      "section_subtitle_style",
      [
        "label" => esc_html__( "Subtitle", "aventa" ),
        "tab" => Controls_Manager::TAB_STYLE,
      ]
    );

    // Subtitle size
    Rad_Helpers::slider(
      $this,
      "icon_subtitle_size",
      esc_html__( "Subtitle Size", "aventa" ),
      [ "{{WRAPPER}} .icon-block .content p" => "font-size: {{SIZE}}{{UNIT}}" ],
      14,
      [ "min" => 10, "max" => 70, "step" => 1 ]
    );
    
    // Icon border color on hover
    $this->add_control(
      "icon_subtitle_color",
      [
        "label" => esc_html__( "Subtitle Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .icon-block .content p" => "color: {{VALUE}}",
        ]
      ]
    );

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( 
      "" === $settings["icon"]          && 
      "" === $settings["icon_title"]    &&
      "" === $settings["icon_subtitle"] 
    ) {
			return;
		}

    $classes = [ 
      "icon-block", 
      "clearfix", 
      "resp-block"
    ];

    // User inputs
		$title 		  = esc_html( $settings[ "icon_title" ] );
		$subtitle 	= esc_html( $settings[ "icon_subtitle" ] );
    $position   = esc_attr( $settings[ "icon_position" ] );
    $alignment  = esc_attr( $settings[ "icon_alignment" ] );
    // $icon_bg_size  = esc_attr( $settings[ "icon_size" ]["size"] ) + 30;
		$icon 	    = \Rad_Icon_Manager::get_icon( 
      esc_html( $settings[ "icon" ] ), 
      "all"
    );

    // Assign proper class based on display mode
    $classes[] = $position;
    if ( $position == "top" ) {
      $classes[] = "$alignment-align";
    }

    // Element attributes
		$this->add_render_attribute( "icon", "class", "icon" );
		$this->add_render_attribute( "icon_bg", "class", "icon-bg" );
		$this->add_render_attribute( "icon_block_content", "class", "content" );

    $this->add_inline_editing_attributes( "icon_title", "none" );
    $this->add_inline_editing_attributes( "icon_subtitle" );

    // HTML elements
    $icon_bg_html = sprintf( 
      '<%1$s %2$s></%1$s>', 
      "span",
      $this->get_render_attribute_string( "icon_bg" )
    );

    $icon_wrapper_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div",
      $this->get_render_attribute_string( "icon" ),
      $icon_bg_html . $icon
    );

		$title_html = sprintf(
      '<%1$s %2$s>%3$s</%1$s>', 
      "h4", 
      $this->get_render_attribute_string( "icon_title" ), 
      $title
    );

		$subtitle_html = sprintf(
      '<%1$s %2$s>%3$s</%1$s>', 
      "p", 
      $this->get_render_attribute_string( "icon_subtitle" ), 
      $subtitle
    );

    $content_wrapper_html = sprintf(
      '<%1$s %2$s>%3$s</%1$s>', 
      "div", 
      $this->get_render_attribute_string( "icon_block_content" ), 
      $title_html . $subtitle_html
    );

    // Final HTML to render
    $html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div", 
      "class='" . implode( " ", array_map( "esc_attr", $classes ) ) . "'",
      $icon_wrapper_html . $content_wrapper_html
    );

    echo "$html";
  }

}