<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if ( !defined( "ABSPATH" ) ) exit; 


class Rad_Heading_Widget extends Widget_Base{

  public function get_name() {
    return "rad-heading";
  }

  public function get_title() {
    return esc_html__("Heading", "aventa");
  }

	public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-heading";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Heading", "aventa" ),
			]
		);

		// Heading title
		$this->add_control(
			"title",
			[
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html__( "Heading Title", "aventa" ),
			]
		);

		// Heading subtitle 1
		$this->add_control(
			"subtitle1",
			[
				"label" => esc_html__( "Subtitle 1", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html__( "Subtitle 1", "aventa" ),
				"separator" => "before"
			]
		);

		// Heading subtitle 2
		$this->add_control(
			"subtitle2",
			[
				"label" => esc_html__( "Subtitle 2", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html__( "Subtitle 2", "aventa" ),
				"separator" => "before"
			]
		);
		
		$this->end_controls_section();

    // General Settings
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

		Rad_Helpers::alignment( $this, "align" );

		// Subtitle styles
    $this->add_control(
			"sub_style",
			[
				"label" => esc_html__( "Subtitle Style", "aventa" ),
				"type" => Controls_Manager::SELECT,
				"options" => [
				  "" => esc_html__( "None", "aventa" ),
				  "sub1-line" => esc_html__( "Subtitle 1 with Line", "aventa" ),
				  "sub2-line" => esc_html__( "Subtitle 2 with Line", "aventa" ),
				],
			]
		);

		$this->end_controls_section();


		// Title styles
		$this->start_controls_section(
			"section_title_style",
			[
				"label" => esc_html__( "Title", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

		Rad_Helpers::heading_tag( $this, "title_tag" );

		Rad_Helpers::typography( $this, "title", ".title" );

		$this->end_controls_section();


    // Subtitle 1 styles
    $this->start_controls_section(
			"section_subtitle1_style",
			[
				"label" => esc_html__( "Subtitle 1", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

		Rad_Helpers::typography( 
			$this, 
			"subtitle1", 
			".subtitle1", 
			[ "min" => 10, "max" => 30, "step" => 1 ], 
			15 
		);

		$this->end_controls_section();

    // Subtitle 2 styles
    $this->start_controls_section(
			"section_subtitle2_style",
			[
				"label" => esc_html__( "Subtitle 2", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

		Rad_Helpers::typography( 
			$this, 
			"subtitle2", 
			".subtitle2", 
			[ "min" => 10, "max" => 30, "step" => 1 ], 
			15 
		);

		$this->end_controls_section();
  }
  

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( 
      "" === $settings["title"]     && 
      "" === $settings["subtitle1"] && 
      "" === $settings["subtitle2"] 
    ) {
			return;
		}

    $classes = [ 
      "heading-block",
      $settings["align"],
    ];

		// Assign class based on selected subtitle style
    if ( $settings["sub_style"] ) {
      $classes[] = "with-line";
      $classes[] = $settings["sub_style"];
    }

		// Elements attributes
		$this->add_render_attribute( "title", "class", "title" );
		$this->add_render_attribute( "subtitle1", "class", "subtitle1" );
		$this->add_render_attribute( "subtitle2", "class", "subtitle2" );

		$this->add_inline_editing_attributes( "title" );
		$this->add_inline_editing_attributes( "subtitle1" );
		$this->add_inline_editing_attributes( "subtitle2" );

		// User inputs
		$title 	= esc_html( $settings[ "title" ] );
		$sub1 	= esc_html( $settings[ "subtitle1" ] );
		$sub2 	= esc_html( $settings[ "subtitle2" ] );

		// HTML elements
		$title_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      Utils::validate_html_tag( $settings[ "title_tag" ] ), 
      $this->get_render_attribute_string( "title" ), 
      $title 
    );

		$sub1_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "span", 
      $this->get_render_attribute_string( "subtitle1" ), 
      $sub1 
    );
    
		$sub2_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "span", 
      $this->get_render_attribute_string( "subtitle2" ), 
      $sub2 
    );

		// Final HTML to render
    $html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div",
      "class='" . implode( " ", array_map( "esc_attr", $classes ) ) . "'",
      $sub1_html . $title_html . $sub2_html
    );

    echo "$html";
  }

}