<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 


class Rad_Counter_Block_Widget extends Widget_Base{

  public function get_name() {
    return "rad-counter-block";
  }

  public function get_title() {
    return esc_html__("Counter Block", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-counter";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Counter Block", "aventa" ),
			]
		);

    // Counter number
    $this->add_control(
			"counter_number",
			[
				"label" => esc_html__( "Number", "aventa" ),
				"type" => Controls_Manager::NUMBER,
				"default" => 5000,
			]
		);

    // Counter title
    $this->add_control(
			"counter_title",
			[
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXT,
				"default" => esc_html__( "Counter Title", "aventa" ),
			]
		);

    // Counter description
    $this->add_control(
			"counter_description",
			[
				"label" => esc_html__( "Description", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html( "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua." ),
			]
		);

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // Counter number color
    $this->add_control(
      "counter_number_color",
      [
        "label" => esc_html__( "Number Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .counter-block .number" => "color: {{VALUE}}",
        ],
        "default" => "#000",
      ]
    );

    // Counter title color
    $this->add_control(
      "counter_title_color",
      [
        "label" => esc_html__( "Title Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .counter-block .title" => "color: {{VALUE}}",
        ],
        "default" => "#000",
      ]
    );

    // Counter description color
    $this->add_control(
      "counter_description_color",
      [
        "label" => esc_html__( "Description Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .counter-block .desc" => "color: {{VALUE}}",
        ],
        "default" => "#8c8c8c",
      ]
    );

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( 
      "" === $settings[ "counter_number" ]   && 
      "" === $settings[ "counter_title" ]    &&
      "" === $settings[ "counter_subtitle" ] 
    ) {
			return;
		}

    $classes = [ 
      "counter-block", 
      "resp-block"
    ];

    // User inputs
		$number 		  = esc_html( $settings[ "counter_number" ] );
		$title 	      = esc_html( $settings[ "counter_title" ] );
    $description  = esc_html( $settings[ "counter_description" ] );

    // Element attributes
		$this->add_render_attribute( "counter_wrapper", "data-count-num", esc_attr( $number ) );
		$this->add_render_attribute( "counter_wrapper", "class", implode( " ", array_map( "esc_attr", $classes ) ) );
		$this->add_render_attribute( "counter_number", "class", "number" );
		$this->add_render_attribute( "counter_title", "class", "title" );
		$this->add_render_attribute( "counter_description", "class", "desc" );

    $this->add_inline_editing_attributes( "counter_title", "none" );
    $this->add_inline_editing_attributes( "counter_description" );

    // HTML elements
    $number_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "span",
      $this->get_render_attribute_string( "counter_number" ),
      $number
    );

    $title_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "h5",
      $this->get_render_attribute_string( "counter_title" ),
      $title
    );

    $description_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "span",
      $this->get_render_attribute_string( "counter_description" ),
      $description
    );

    // Final HTML to render
    $html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div", 
      $this->get_render_attribute_string("counter_wrapper"),
      $number_html . $title_html . $description_html
    );

    echo "$html";
  }

}