<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 


class Rad_Button_Widget extends Widget_Base{

  public function get_name() {
    return "rad-button";
  }

  public function get_title() {
    return esc_html__("Button", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-button";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Button", "aventa" ),
			]
		);

    Rad_Helpers::link( 
      $this, 
      "button_link", 
      esc_html__( "Title", "aventa" ), 
      esc_html__( "URL", "aventa" )
    );

    $this->add_control(
      "button_has_icon",
      [
        "label" => esc_html__( "Has Icon?", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
        "separator" => "before"
      ]
    );

    $this->add_control(
      "button_icon",
      [
        "label" => esc_html__( "Icon", "aventa" ),
        "type" => Rad_Icons_Control::TYPE,
        "default" => "acorn",
        "condition" => [
          "button_has_icon" => "true"
        ]
      ]
    );

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    Rad_Helpers::alignment( $this, "alignment" );

    $this->add_control(
      "button_size",
      [
        "label" => esc_html__( "Button Size", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "button-large"     => esc_html__( "Large", "aventa" ),
          "button-standard"  => esc_html__( "Standard", "aventa" ),
          "button-small"     => esc_html__( "Small", "aventa" )
        ],
        "default" => "button-standard"
      ]
    );

    $this->add_control(
      "button_border_radius",
      [
        "label" => esc_html__( "Border Radius", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "0px"   => esc_html__( "0px", "aventa" ),
          "3px"   => esc_html__( "3px", "aventa" ),
          "5px"   => esc_html__( "5px", "aventa" ),
          "40px"  => esc_html__( "40px", "aventa" )
        ],
        "selectors" => [
          "{{WRAPPER}} .rad-button" => "border-radius: {{VALUE}}",
        ],
        "default" => "0px"
      ]
    );

    $this->add_control(
      "button_display",
      [
        "label" => esc_html__( "Button Display", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "button-inline"     => esc_html__( "Inline", "aventa" ),
          "button-block"     => esc_html__( "Block", "aventa" )
        ],
        "default" => "button-inline"
      ]
    );

    $this->add_control(
      "button_icon_position",
      [
        "label" => esc_html__( "Icon Position", "aventa" ),
        "type" => Controls_Manager::CHOOSE,
        "options" => [
          "left-icon" => [
            "title" => esc_html__( "Left", "aventa" ),
            "icon" => "eicon-h-align-left",
          ],
          "right-icon" => [
            "title" => esc_html__( "Right", "aventa" ),
            "icon" => "eicon-h-align-right",
          ]
        ],
        "default" => "left-icon",
        "separator" => "before",
        "condition" => [
          "button_has_icon" => "true"
        ]
      ]
    );

    $this->add_control(
      "button_icon_on_hover",
      [
        "label" => esc_html__( "Show Icon on Hover?", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
        "condition" => [
          "button_has_icon" => "true"
        ]
      ]
    );

    $this->add_control(
      "divider",
      [ 
        "type" => Controls_Manager::DIVIDER,
        "condition" => [
          "button_has_icon" => "true"
        ]
      ]
    );

    $this->start_controls_tabs( "tabs_button_style" );

		$this->start_controls_tab(
			"tab_button_normal",
			[
				"label" => esc_html__( "Normal", "aventa" ),
			]
		);

    $this->add_control(
      "button_bg_color",
      [
				"label" => esc_html__( "Background Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"selectors" => [
          "{{WRAPPER}} .rad-button" => "background-color: {{VALUE}}",
        ],
        "default" => "#000"
			]
    );

    $this->add_control(
      "button_border_color",
      [
				"label" => esc_html__( "Border Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"selectors" => [
          "{{WRAPPER}} .rad-button" => "border-color: {{VALUE}}",
        ],
        "default" => "#333"
			]
    );

    $this->add_control(
      "button_text_color",
      [
        "label" => esc_html__( "Text Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .rad-button .txt" => "color: {{VALUE}}",
          "{{WRAPPER}} .rad-button svg" => "fill: {{VALUE}}",
        ],
        "default" => "#DDD"
      ]
    );

		$this->end_controls_tab();

		$this->start_controls_tab(
			"tab_button_hover",
			[
				"label" => esc_html__( "Hover", "aventa" ),
			]
		);

    $this->add_control(
      "button_bg_hover",
      [
				"label" => esc_html__( "Background Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"selectors" => [
          "{{WRAPPER}} .rad-button:hover" => "background-color: {{VALUE}}",
        ],
        "default" => "#333"
			]
    );

		$this->add_control(
      "button_border_hover",
      [
				"label" => esc_html__( "Border Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"selectors" => [
          "{{WRAPPER}} .rad-button:hover" => "border-color: {{VALUE}}",
        ],
        "default" => "#000"
			]
    );

    $this->add_control(
      "button_text_hover",
      [
        "label" => esc_html__( "Text Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .rad-button:hover .txt" => "color: {{VALUE}}",
          "{{WRAPPER}} .rad-button:hover svg" => "fill: {{VALUE}}",
        ],
        "default" => "#FFF"
      ]
    );

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( "" === $settings["button_link_title"] && "" === $settings["button_icon"] ) {
			return;
		}

    $classes = [ 
      "rad-button"
    ];

    // User inputs
		$title 		      = esc_html( $settings[ "button_link_title" ] );
		$link 		      = $settings[ "button_link_url" ];
    $size           = esc_attr( $settings[ "button_size" ] );
    $position       = esc_attr( $settings[ "button_icon_position" ] );
    $alignment      = esc_attr( $settings[ "alignment" ] );
    $display        = esc_attr( $settings[ "button_display" ] );
    $has_icon       = esc_attr( $settings[ "button_has_icon" ] );
    $icon_on_hover  = $settings[ "button_icon_on_hover" ];
		$icon 	        = \Rad_Icon_Manager::get_icon( 
      esc_html( $settings[ "button_icon" ] ), 
      "all"
    );

    // Assign proper class based on display mode
    $classes[] = $position;
    $classes[] = "button-$alignment";
    $classes[] = $display;    
    $classes[] = $has_icon      ? "has-icon" : "";
    $classes[] = $icon_on_hover ? "hover" : "first";
    $classes[] = $size;

    // Element attributes
		$this->add_render_attribute( "button", "class", implode( " ", $classes ) );
		$this->add_render_attribute( "button", "title", $title );
		$this->add_render_attribute( "button_title", "class", "txt" );
    if ( $link ) {
      $link_url       =  esc_url( $link[ "url" ] );
      $link_target    =  $link[ "is_external" ] ? "_blank" : "";
      $link_nofollow  =  $link[ "nofollow" ]    ? "nofollow" : "";

		  $this->add_render_attribute( "button", "href", $link_url);
		  $this->add_render_attribute( "button", "target", $link_target);
		  $this->add_render_attribute( "button", "rel", $link_nofollow);
    }

    $title_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "span",
      $this->get_render_attribute_string( "button_title" ),
      $title
    );

    $html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "a",
      $this->get_render_attribute_string( "button" ),
      $title_html . $icon
    );

    echo "$html";
  }

}