<?php
namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( "ABSPATH" ) ) {
	exit; // Exit if accessed directly
}

class Rad_Add_To_Cart_Widget extends Widget_Base {

	public function get_name() {
		return "rad-add-to-cart";
	}

	public function get_title() {
		return esc_html__( "Add to Cart", "aventa" );
	}

	public function get_icon() {
		return "eicon-product-add-to-cart";
	}

	public function get_keywords() {
		return [ "woocommerce", "shop", "store", "cart", "aventa" ];
	}

	public function get_categories() {
		return [ Rad_Helpers::WC_WIDGETS_CATEGORY ];
	}

	protected function register_controls() {
    $this->start_controls_section(
      "section_content",
			[
				"label" => esc_html__( "Add to Cart", "aventa" )
			]
    );

    $this->add_control(
			"atc_product_id",
			[
				"label"         => esc_html__( "Product", "aventa" ),
				"type"          => Controls_Manager::SELECT2,
				"options"       => Rad_Helpers::get_products(),
        "description"   => esc_html__( "Search products by id or title.", "aventa" )
			]
		);

    $this->add_control(
			"atc_show_price",
			[
				"label" 				=> esc_html__( "Show Price?", "aventa" ),
				"type" 					=> Controls_Manager::SWITCHER,
				"label_on" 			=> esc_html__( "Yes", "aventa" ),
				"label_off" 		=> esc_html__( "No", "aventa" ),
				"return_value" 	=> "true",
				"default" 			=> "true"
			]
		);

    $this->end_controls_section();

    $this->start_controls_section(
			"section_button_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    $this->add_control(
			"atc_text_color",
			[
				"label" => esc_html__( "Text Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"default" => "#fff",
				"selectors" => [
          "{{WRAPPER}} .add_to_cart_inline a" => "color: {{VALUE}};",
				]
			]
		);

    $this->add_control(
			"atc_bg_color",
			[
				"label" => esc_html__( "Background Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"default" => "#000",
				"selectors" => [
          "{{WRAPPER}} .add_to_cart_inline a" => "background-color: {{VALUE}};"
        ]
			]
		);

    $this->end_controls_section();
	}

	protected function render() {

    $settings = $this->get_settings();
    $product_id = esc_attr( $settings[ "atc_product_id" ] );
    $show_price = esc_attr( $settings[ "atc_show_price" ] );

    if ( !$product_id ) { return; }

    $html = do_shortcode( "[add_to_cart id='$product_id' show_price='$show_price']" );
    echo "$html";
	}

}
