<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;


if ( !defined( "ABSPATH" ) ) exit; 


class Rad_Accordion_Block_Widget extends Widget_Base{

  public function get_name() {
    return "rad-accordion-block";
  }

  public function get_title() {
    return esc_html__("Accordion Block", "aventa");
  }

  public function get_icon() {
    return "eicon-accordion";
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Accordion Block", "aventa" ),
			]
		);

    // Accordion item fields
    $accordion_item = new Repeater();

    // Accordion item icon
    $accordion_item->add_control(
      "accordion_show_icon",
      [
        "label" => esc_html__( "Show Icon?", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
      ]
    );

    $accordion_item->add_control(
      "accordion_icon", 
      [
        "label" => esc_html__( "Icon", "aventa" ),
        "type" => Rad_Icons_Control::TYPE,
        "default" => "smile",
        "condition" => [
          "accordion_show_icon" => "true"
        ]
      ]
    );

    // Accordion item title
		$accordion_item->add_control(
			"accordion_title", 
      [
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html__( "Item Title" , "aventa" ),
        "separator" => "after"
			]
		);

    // Accordion item content
		$accordion_item->add_control(
			"accordion_content", [
				"label" => esc_html__( "Content", "aventa" ),
				"type" => Controls_Manager::WYSIWYG,
				"default" => esc_html__( "Item content. Click the edit button to change this text." , "aventa" ),
			]
		);

    // Accordion item repeater
		$this->add_control(
			"accordion_items",
			[
				"label" => esc_html__( "Accordion Items", "aventa" ),
				"type" => Controls_Manager::REPEATER,
				"fields" => $accordion_item->get_controls(),
				"default" => [
					[
						"accordion_title" => esc_html__( 'Item #1', "aventa" ),
						"accordion_content" => esc_html__( "Item content. Click the edit button to change this text.", "aventa"),
					],
					[
						"accordion_title" => esc_html__( 'Item #2', "aventa" ),
						"accordion_content" => esc_html__( "Item content. Click the edit button to change this text.", "aventa"),
					],
				],
				"title_field" => "{{{ accordion_title }}}",
			]
		);

    // Accordion allow collapse all items option
    $this->add_control(
      "accordion_allow_collapse_all",
      [
        "label" => esc_html__( "Allow Collapse All Items?", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
        "separator" => "before"
      ]
    );

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    Rad_Helpers::alignment($this, "accordion_alignment", [], ["left", "right"], "left", false);

    $this->add_control(
      "accordion_icon_position",
      [
        "label" => esc_html__( "Icon Position", "aventa" ),
        "type" => Controls_Manager::CHOOSE,
        "options" => [
          "icon-left" => [
            "title" => esc_html__( "Left", "aventa" ),
            "icon" => "eicon-h-align-left",
          ],
          "icon-right" => [
            "title" => esc_html__( "Right", "aventa" ),
            "icon" => "eicon-h-align-right",
          ]
        ],
        "default" => "icon-left"
      ]
    );

    $this->add_control(
      "accordion_title_color",
      [
        "label" => esc_html__( "Title Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .accordion-block .title" => "color: {{VALUE}}",
        ],
        "default" => "#000",
      ]
    );

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( !$settings[ "accordion_items" ] ) {
			return;
		}

    $wrapper_classes = [ 
      "accordion-block", 
      "resp-block"
    ];

    $item_classes = [ 
      "toggle-block",
      "accordion"
    ];

    // User inputs
		$accordion_items      = $settings[ "accordion_items" ];
		$alignment            = esc_html( $settings[ "accordion_alignment" ] );
    $icon_position        = esc_html( $settings[ "accordion_icon_position" ] );
		$allow_collapse_all   = esc_html( $settings[ "accordion_allow_collapse_all" ] );

    // Assign proper class based on selected options
    $item_classes[]     = $alignment;
    $item_classes[]     = $icon_position;
    if ( $allow_collapse_all ) {
      $item_classes[] = "allow-collapse-all";
    }

    // Element attributes
		$this->add_render_attribute( "accordion_wrapper", "class", implode( " ", array_map( "esc_attr", $wrapper_classes ) ) );
		$this->add_render_attribute( "accordion_item", "class", implode( " ", array_map( "esc_attr", $item_classes ) ) );
		$this->add_render_attribute( "accordion_title", "class", "title" );
		$this->add_render_attribute( "accordion_content", "class", "toggle-content" );

    // HTML elements
    if ( $accordion_items ) {
      // items array holds html code of each individual accordion item
      $items_array = [];
      $active_item = 0;

			foreach (  $accordion_items as $key => $accordion_item ) {
        // Add open class to the first item, and remove it from the others
        if ( $key == $active_item ) {
          $this->add_render_attribute( "accordion_item", "class", "open" );
        } else if ( $key == $active_item + 1 ) {
          $this->remove_render_attribute( "accordion_item", "class", "open" );
        }

        $title    = esc_html( $accordion_item[ "accordion_title" ] );
        $content  = $accordion_item[ "accordion_content" ];
        $has_icon = esc_html( $accordion_item[ "accordion_show_icon" ] );
        $icon 	  = ( $has_icon )
          ? \Rad_Icon_Manager::get_icon( 
            esc_html( $accordion_item[ "accordion_icon" ] ), 
            "all"
          )
          : null;

        $title_html = sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "span",
          $this->get_render_attribute_string( "accordion_title" ),
          $icon . $title
        );

        $content_html = sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "div",
          $this->get_render_attribute_string( "accordion_content" ),
          $content
        );

        $item_html = sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "div",
          $this->get_render_attribute_string( "accordion_item" ),
          $title_html . $content_html
        );

        $items_array[] = $item_html;
			}

      // Final HTML to render
      $html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>',
        "div",
        $this->get_render_attribute_string( "accordion_wrapper" ),
        implode( "", $items_array )
      );
  
      echo "$html";
		}

  }

}