<?php
namespace Aventa;

// Top of section
if ( ! function_exists( "rad_add_custom_controls_page_settings" ) ) {

    function rad_add_custom_controls_page_settings(\Elementor\Core\DocumentTypes\Page $page)
    {
        // Is elementor Pro loaded
        $elm_pro_loaded = false;
        if( function_exists( "elementor_pro_load_plugin" ) ) {
            $elm_pro_loaded = true; 
        }


        $args = array(
            "orderby"    => "id",
            "order"      => "DESC",
            "hide_empty" => false,
            "fields"     => "all",
        );
        $sliderCategories = get_terms("slider_cats", $args);
        $sliderSlugName   = array();
        if (!empty($sliderCategories) && !is_wp_error($sliderCategories)) {
            foreach ($sliderCategories as $sliderCat) {
                $sliderSlugName[$sliderCat->slug] = $sliderCat->name;
            }
        }
             


        if(isset($page) && $page->get_id() > ""){
            $th_post_type = false;

            $th_post_type = get_post_type($page->get_id());

            //|| ($elm_pro_loaded && $th_post_type == "post")  || ($elm_pro_loaded && $th_post_type == "revision")
            if($th_post_type == "page"){

                // general settings
                $page->start_controls_section(
                    "aventa_general",
                    [
                        "label" => esc_html__( "Aventa general", "aventa" ),
                        "tab" => \Elementor\Controls_Manager::TAB_SETTINGS,
                    ]
                );

                $page->add_control(
                    "sidebar",
                    [
                        "label" => esc_html__( "Choose the sidebar", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "no-sidebar",
                        "options" => [
                            "no-sidebar" => esc_html__( "No Sidebar", "aventa" ),
                            "page-sidebar" => esc_html__( "Page Sidebar", "aventa" ),
                        ],
                    ]
                );

                $page->add_control(
                    "extra_class",
                    [
                        "label" => esc_html__( "Extra Class Name", "aventa" ),
                        "type" => \Elementor\Controls_Manager::TEXT,
                        "placeholder" => esc_html__( "class name ex: class1 class2", "aventa" ),
                    ]
                );

                $page->end_controls_section();

                // Header settings
                $page->start_controls_section(
                    "aventa_header",
                    [
                        "label" => esc_html__( "Aventa Header", "aventa" ),
                        "tab" => \Elementor\Controls_Manager::TAB_SETTINGS,
                    ]
                );

                $page->add_control(
                    "page_header_custom",
                    [
                        "label" => esc_html__( "Page Header", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "inherit",
                        "options" => [
                            "inherit" => esc_html__( "Inherit from theme settings", "aventa" ),
                            "custom" => esc_html__( "Custom", "aventa" ),
                        ],
                    ]
                );

                $page->add_control(
                    "page_header_mode",
                    [
                        "label" => esc_html__( "Page begins with", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "1",
                        "options" => [
                            "1" => esc_html__( "Header at top", "aventa" ),
                            "2" => esc_html__( "Space at top", "aventa" ),
                            "3" => esc_html__( "No space at top", "aventa" ),
                        ],
                        "condition" => [
                          "page_header_custom" => "custom"
                        ],
                    ]
                );
                $page->add_control(
                    "title_bar",
                    [
                        "label" => esc_html__( "Title in header", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "2",
                        "options" => [
                            "2" => esc_html__( "Use post title", "aventa" ),
                            "1" => esc_html__( "Use custom title", "aventa" ),
                            "0" => esc_html__( "Hide it", "aventa" ),
                        ],
                        "condition" => [
                          "page_header_custom" => "custom",
                          "page_header_mode" => "1"
                        ],
                    ]
                );


                $page->add_control(
                    "title_text",
                    [
                        "label" => esc_html__( "Title", "aventa" ),
                        "type" => \Elementor\Controls_Manager::TEXT,
                        "placeholder" => esc_html__( "Header use this title instead of page title", "aventa" ),
                        "condition" => [
                          "page_header_custom" => "custom",
                          "page_header_mode" => "1"
                        ],
                    ]
                );

                $page->add_control(
                  "page_header_bg",
                  [
                    "label" => esc_html__( "Overlay Color", "aventa" ),
                    "type" => \Elementor\Controls_Manager::COLOR,
                    "scheme" => [
                      "type" => \Elementor\Core\Schemes\Color::get_type(),
                      "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                    ],
                    "selectors" => [
                      "{{WRAPPER}} #header.overlay:before" => "background-color: {{VALUE}}",
                    ],
                    "condition" => [
                      "page_header_custom" => "custom",
                      "page_header_mode" => "1"
                    ],
                  ]
                );

                $page->add_control(
                  "page_header_bg_image",
                  [
                    "label" => esc_html__( "Header background image", "aventa" ),
                    "type" => \Elementor\Controls_Manager::MEDIA,
                    "default" => [
                      "url" => \Elementor\Utils::get_placeholder_image_src(),
                    ],
                    "condition" => [
                      "page_header_custom" => "custom",
                      "page_header_mode" => "1"
                    ],
                  ]
                );

                $page->add_control(
                  "page_header_text_color",
                  [
                    "label" => esc_html__( "Header Text Color", "aventa" ),
                    "type" => \Elementor\Controls_Manager::COLOR,
                    "scheme" => [
                      "type" => \Elementor\Core\Schemes\Color::get_type(),
                      "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                    ],
                    "selectors" => [
                      "{{WRAPPER}} .title" => "color: {{VALUE}}",
                    ],
                    "condition" => [
                      "page_header_custom" => "custom",
                      "page_header_mode" => "1"
                    ],
                  ]
                );

                $page->end_controls_section();

                // Header settings
                $page->start_controls_section(
                    "aventa_slider",
                    [
                        "label" => esc_html__( "Aventa Slider", "aventa" ),
                        "tab" => \Elementor\Controls_Manager::TAB_SETTINGS,
                    ]
                );

                $page->add_control(
                    "slider_type",
                    [
                        "label" => esc_html__( "Slider type", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "none",
                        "options" => [
                            "none" => esc_html__( "None", "aventa" ),
                            "builtin-slider" => esc_html__( "Aventa builtin slider", "aventa" ),
                            "rev-slider" => esc_html__( "revolution slider", "aventa" ),
                        ],
                    ]
                );

                $page->add_control(
                    "slide_mode",
                    [
                        "label" => esc_html__( "Slide mode", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "slide",
                        "options" => [
                            "slide" => esc_html__( "Slide", "aventa" ),
                            "fade" => esc_html__( "Fade", "aventa" ),
                        ],
                        "condition" => [
                          "slider_type" => "builtin-slider"
                        ],
                    ]
                );

                $page->add_control(
                    "slider_width",
                    [
                        "label" => esc_html__( "Slider width", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "fullscreen",
                        "options" => [
                            "fullscreen" => esc_html__( "Fullscreen", "aventa" ),
                            "fullscreen-edge" => esc_html__( "Fillscreen with space in edges", "aventa" ),
                            "boxed" => esc_html__( "Boxed in container", "aventa" ),
                        ],
                        "condition" => [
                          "slider_type" => "builtin-slider"
                        ],
                    ]
                );

                $page->add_control(
                    "builtin_slider_cat",
                    [
                        "label" => esc_html__( "Category Of Slides", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "",
                        "options" => $sliderSlugName,
                        "condition" => [
                          "slider_type" => "builtin-slider"
                        ],
                    ]
                );


                $page->add_control(
                    "slider_pagination_type",
                    [
                        "label" => esc_html__( "Pagination type", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "none",
                        "options" => [
                            "none" => esc_html__( "None", "aventa" ),
                            "simple" => esc_html__( "Simple", "aventa" ),
                            "linear" => esc_html__( "Linear", "aventa" ),
                            "progress" => esc_html__( "Progress", "aventa" ),
                        ],
                        "condition" => [
                          "slider_type" => "builtin-slider"
                        ],
                    ]
                );


                $page->add_control(
                    "slider_pagination_style",
                    [
                        "label" => esc_html__( "Pagination/Navigation style", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "light",
                        "options" => [
                            "light" => esc_html__( "Light", "aventa" ),
                            "dark" => esc_html__( "Dark", "aventa" ),
                        ],
                        "condition" => [
                          "slider_type" => "builtin-slider"
                        ],
                    ]
                );

                $page->add_control(
                    "rev_slider",
                    [
                        "label" => esc_html__( "Choose a revolution slider", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "",
                        "options" => rad_get_revolution_slider_slides(),
                        "condition" => [
                          "slider_type" => "rev-slider"
                        ],
                    ]
                );

                $page->end_controls_section();

                if (rad_get_option("menu-state") != "single-state") {

                    // Header settings
                    $page->start_controls_section(
                        "aventa_menu",
                        [
                            "label" => esc_html__( "Aventa Menu style", "aventa" ),
                            "tab" => \Elementor\Controls_Manager::TAB_SETTINGS,
                        ]
                    );
                    $page->add_control(
                        "aventa_menu_title",
                        [
                            "label" => __( "Current page menu style Change style of menu just for this page. this settings override aventa settings just for current page.", "aventa" ),
                            "type" => \Elementor\Controls_Manager::HEADING,
                            "separator" => "before",
                        ]
                    );


                    $page->add_control(
                        "menu",
                        [
                            "label" => esc_html__( "Menu style", "aventa" ),
                            "type" => \Elementor\Controls_Manager::SELECT,
                            "label_block" => true,
                            "default" => "default",
                            "options" => [
                                "default" => esc_html__( "Inherit from theme settings", "aventa" ),
                                "custom" => esc_html__( "Custom", "aventa" ),
                            ],
                        ]
                    );

                    $page->add_control(
                        "aventa_menu_initial_description",
                        [
                            "label" => __( "Initial State", "aventa" ),
                            "type" => \Elementor\Controls_Manager::HEADING,
                            "separator" => "before",
                            "condition" => [
                              "menu" => "custom"
                            ],
                        ]
                    );

                    $page->add_control(
                        "menu_initial_state_logo",
                        [
                            "label" => __( "Initial Logo", "aventa" ),
                            "type" => \Elementor\Controls_Manager::SWITCHER,
                            "default" => "1",
                            "label_on" => __( "Main logo", "aventa" ),
                            "label_off" => __( "Second logo", "aventa" ),
                            "return_value" => "1",
                            "condition" => [
                              "menu" => "custom"
                            ],
                        ]
                    );

                    $page->add_control(
                      "initial_menu_background_color",
                      [
                        "label" => esc_html__( "Background Color", "aventa" ),
                        "type" => \Elementor\Controls_Manager::COLOR,
                        "scheme" => [
                          "type" => \Elementor\Core\Schemes\Color::get_type(),
                          "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                        ],
                        "selectors" => [
                          "{{WRAPPER}} .title" => "color: {{VALUE}}",
                        ],
                        "condition" => [
                          "menu" => "custom"
                        ],
                      ]
                    );
                    $page->add_control(
                      "initial_menu_text_color",
                      [
                        "label" => esc_html__( "Text Color", "aventa" ),
                        "type" => \Elementor\Controls_Manager::COLOR,
                        "scheme" => [
                          "type" => \Elementor\Core\Schemes\Color::get_type(),
                          "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                        ],
                        "selectors" => [
                          "{{WRAPPER}} .title" => "color: {{VALUE}}",
                        ],
                        "condition" => [
                          "menu" => "custom"
                        ],
                      ]
                    );

                    $page->add_control(
                      "initial_menu_border_color",
                      [
                        "label" => esc_html__( "Border Color", "aventa" ),
                        "type" => \Elementor\Controls_Manager::COLOR,
                        "scheme" => [
                          "type" => \Elementor\Core\Schemes\Color::get_type(),
                          "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                        ],
                        "selectors" => [
                          "{{WRAPPER}} .title" => "color: {{VALUE}}",
                        ],
                        "condition" => [
                          "menu" => "custom"
                        ],
                      ]
                    );
                    
                    $page->add_control(
                      "initial_shop_cart_text_color",
                      [
                        "label" => esc_html__( "Cart/Wishlist Text Color", "aventa" ),
                        "type" => \Elementor\Controls_Manager::COLOR,
                        "scheme" => [
                          "type" => \Elementor\Core\Schemes\Color::get_type(),
                          "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                        ],
                        "selectors" => [
                          "{{WRAPPER}} .title" => "color: {{VALUE}}",
                        ],
                        "condition" => [
                          "menu" => "custom"
                        ],
                      ]
                    );

                    $page->add_control(
                        "aventa_menu_second_description",
                        [
                            "label" => __( "Initial State", "aventa" ),
                            "type" => \Elementor\Controls_Manager::HEADING,
                            "separator" => "before",
                            "condition" => [
                              "menu" => "custom"
                            ],
                        ]
                    );

                    $page->add_control(
                        "menu_second_state_logo",
                        [
                            "label" => __( "Initial Logo", "aventa" ),
                            "type" => \Elementor\Controls_Manager::SWITCHER,
                            "default" => "1",
                            "label_on" => __( "Main logo", "aventa" ),
                            "label_off" => __( "Second logo", "aventa" ),
                            "return_value" => "1",
                            "condition" => [
                              "menu" => "custom"
                            ],
                        ]
                    );

                    $page->add_control(
                      "menu_background_color",
                      [
                        "label" => esc_html__( "Background Color", "aventa" ),
                        "type" => \Elementor\Controls_Manager::COLOR,
                        "scheme" => [
                          "type" => \Elementor\Core\Schemes\Color::get_type(),
                          "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                        ],
                        "selectors" => [
                          "{{WRAPPER}} .title" => "color: {{VALUE}}",
                        ],
                        "condition" => [
                          "menu" => "custom"
                        ],
                      ]
                    );
                    $page->add_control(
                      "menu_text_color",
                      [
                        "label" => esc_html__( "Text Color", "aventa" ),
                        "type" => \Elementor\Controls_Manager::COLOR,
                        "scheme" => [
                          "type" => \Elementor\Core\Schemes\Color::get_type(),
                          "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                        ],
                        "selectors" => [
                          "{{WRAPPER}} .title" => "color: {{VALUE}}",
                        ],
                        "condition" => [
                          "menu" => "custom"
                        ],
                      ]
                    );

                    $page->add_control(
                      "menu_border_color",
                      [
                        "label" => esc_html__( "Border Color", "aventa" ),
                        "type" => \Elementor\Controls_Manager::COLOR,
                        "scheme" => [
                          "type" => \Elementor\Core\Schemes\Color::get_type(),
                          "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                        ],
                        "selectors" => [
                          "{{WRAPPER}} .title" => "color: {{VALUE}}",
                        ],
                        "condition" => [
                          "menu" => "custom"
                        ],
                      ]
                    );
                    
                    $page->add_control(
                      "shop_cart_text_color",
                      [
                        "label" => esc_html__( "Cart/Wishlist Text Color", "aventa" ),
                        "type" => \Elementor\Controls_Manager::COLOR,
                        "scheme" => [
                          "type" => \Elementor\Core\Schemes\Color::get_type(),
                          "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                        ],
                        "selectors" => [
                          "{{WRAPPER}} .title" => "color: {{VALUE}}",
                        ],
                        "condition" => [
                          "menu" => "custom"
                        ],
                      ]
                    );
                    $page->end_controls_section();
                }
            }
        }

    }
}


// Top of section
if ( ! function_exists( "rad_add_custom_controls_post_settings" ) ) {

    function rad_add_custom_controls_post_settings(\Elementor\Core\DocumentTypes\Post $page)
    {


        if(isset($page) && $page->get_id() > ""){
            $th_post_type = false;

            $th_post_type = get_post_type($page->get_id());
            
            if($th_post_type == "post"){

                // general settings
                $page->start_controls_section(
                    "aventa_general",
                    [
                        "label" => esc_html__( "Aventa - Post general", "aventa" ),
                        "tab" => \Elementor\Controls_Manager::TAB_SETTINGS,
                    ]
                );

                $page->add_control(
                    "extra_class",
                    [
                        "label" => esc_html__( "Extra Class Name", "aventa" ),
                        "type" => \Elementor\Controls_Manager::TEXT,
                        "placeholder" => esc_html__( "class name ex: class1 class2", "aventa" ),
                    ]
                );

                $page->end_controls_section();

                // Header settings
                $page->start_controls_section(
                    "aventa_pf_section",
                    [
                        "label" => esc_html__( "Post Format", "aventa" ),
                        "tab" => \Elementor\Controls_Manager::TAB_SETTINGS,
                    ]
                );

                $page->add_control(
                    "aventa_post_format",
                    [
                        "label" => esc_html__( "Post Format", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "standard",
                        "options" => [
                            "standard" => esc_html__( "Default", "aventa" ),
                            "gallery" => esc_html__( "Gallery", "aventa" ),
                            "video" => esc_html__( "Video", "aventa" ),
                            "audio" => esc_html__( "Audio", "aventa" ),
                            "link" => esc_html__( "Link", "aventa" ),
                            "quote" => esc_html__( "Quote", "aventa" ),
                        ],
                    ]
                );

                $page->add_control(
                    "video_type",
                    [
                        "label" => esc_html__( "Video Type", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "vimeo",
                        "options" => [
                            "vimeo" => esc_html__( "Vimeo", "aventa" ),
                            "youtube" => esc_html__( "Youtube", "aventa" ),
                        ],
                        "condition" => [
                          "aventa_post_format" => "video"
                        ],
                    ]
                );

                $page->add_control(
                    "video_id",
                    [
                        "label" => esc_html__( "Video URL", "aventa" ),
                        "type" => \Elementor\Controls_Manager::TEXT,
                        "condition" => [
                          "aventa_post_format" => "video"
                        ],
                    ]
                );

                $page->add_control(
                    "audio_url",
                    [
                        "label" => esc_html__( "Audio URL - Soundcloud", "aventa" ),
                        "type" => \Elementor\Controls_Manager::TEXT,
                        "condition" => [
                          "aventa_post_format" => "audio"
                        ],
                    ]
                );

                $page->add_control(
                  "gallery",
                  [
                    "label" => esc_html__( "Post gallery images", "aventa" ),
                    "type" => \Elementor\Controls_Manager::GALLERY,
                    "condition" => [
                      "aventa_post_format" => "gallery"
                    ],
                  ]
                );

                $page->add_control(
                    "quote_content",
                    [
                        "label" => esc_html__( "Quote", "aventa" ),
                        "type" => \Elementor\Controls_Manager::TEXTAREA,
                        "condition" => [
                          "aventa_post_format" => "quote"
                        ],
                    ]
                );

                $page->add_control(
                    "quote_author",
                    [
                        "label" => esc_html__( "Quote author", "aventa" ),
                        "type" => \Elementor\Controls_Manager::TEXT,
                        "condition" => [
                          "aventa_post_format" => "quote"
                        ],
                    ]
                );

                $page->add_control(
                  "quote_color",
                  [
                    "label" => esc_html__( "Quote text Color", "aventa" ),
                    "type" => \Elementor\Controls_Manager::COLOR,
                    "scheme" => [
                      "type" => \Elementor\Core\Schemes\Color::get_type(),
                      "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                    ],
                    "condition" => [
                      "aventa_post_format" => "quote"
                    ],
                  ]
                );

                $page->add_control(
                  "quote_bg_color",
                  [
                    "label" => esc_html__( "Quote background Color", "aventa" ),
                    "type" => \Elementor\Controls_Manager::COLOR,
                    "scheme" => [
                      "type" => \Elementor\Core\Schemes\Color::get_type(),
                      "value" => \Elementor\Core\Schemes\Color::COLOR_1,
                    ],
                    "condition" => [
                      "aventa_post_format" => "quote"
                    ],
                  ]
                );

                
                 $page->add_control(
                    "link_url",
                    [
                        "label" => esc_html__( "Link URL", "aventa" ),
                        "type" => \Elementor\Controls_Manager::TEXT,
                        "condition" => [
                          "aventa_post_format" => "link"
                        ],
                    ]
                );

                $page->end_controls_section();
            }
            
        }

    }
}

// Top of section
if ( ! function_exists( "rad_add_custom_controls_product_settings" ) ) {

    function rad_add_custom_controls_product_settings(\Elementor\Core\Base\Document $page)
    {

        if(isset($page) && $page->get_id() > ""){
            $th_post_type = false;

            $th_post_type = get_post_type($page->get_id());
            
            if($th_post_type == "product"){

                // general settings
                $page->start_controls_section(
                    "aventa_general",
                    [
                        "label" => esc_html__( "Aventa - Product general", "aventa" ),
                        "tab" => \Elementor\Controls_Manager::TAB_SETTINGS,
                    ]
                );

                $page->add_control(
                    "extra_class",
                    [
                        "label" => esc_html__( "Extra Class Name", "aventa" ),
                        "type" => \Elementor\Controls_Manager::TEXT,
                        "placeholder" => esc_html__( "class name ex: class1 class2", "aventa" ),
                    ]
                );

                $page->add_control(
                    "social_share_inherit",
                    [
                        "label" => esc_html__( "Show social share?", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "0",
                        "options" => [
                            "0" => esc_html__( "Inherit from theme setting", "aventa" ),
                            "1" => esc_html__( "Custom for current page", "aventa" ),
                        ]
                    ]
                );                

                $page->add_control(
                    "product_social_share",
                    [
                        "label" => esc_html__( "Show social share?", "aventa" ),
                        "type" => \Elementor\Controls_Manager::SELECT,
                        "label_block" => true,
                        "default" => "1",
                        "options" => [
                            "0" => esc_html__( "Disable", "aventa" ),
                            "1" => esc_html__( "Enable", "aventa" ),
                        ],
                        "condition" => [
                            "social_share_inherit" => "1"
                        ],
                    ]
                );

                $page->end_controls_section();

                // general settings
                $page->start_controls_section(
                    "aventa_video",
                    [
                        "label" => esc_html__( "Aventa - Product Video", "aventa" ),
                        "tab" => \Elementor\Controls_Manager::TAB_SETTINGS,
                    ]
                );


                $page->add_control(
                    "video_type",
                    [
                        "label"   => esc_html__("Video type", "aventa"),
                        "type"    => \Elementor\Controls_Manager::SELECT,
                        "default" => "none",
                        "options" => [
                            "none" => esc_html__("No video", "aventa"),
                            "local_video_popup" => esc_html__("local video popup", "aventa"),
                            "embeded_video_vimeo_popup" => esc_html__("Vimeo video popup", "aventa"),
                            "embeded_video_youtube_popup" => esc_html__("Youtube video popup", "aventa")
                        ],
                    ]
                );

                $page->add_control(
                    "video_webm",
                    [
                        "type"    => \Elementor\Controls_Manager::TEXT,
                        "label"       => esc_html__(".webm extension", "aventa"),
                        "placeholder" => esc_html__(".webm video", "aventa"),
                        "condition" => [
                            "video_type" => "local_video_popup"
                        ],
                    ]
                );

                $page->add_control(
                    "video_mp4",
                    [
                        "type"    => \Elementor\Controls_Manager::TEXT,
                        "label"       => esc_html__(".mp4 extension", "aventa"),
                        "placeholder" => esc_html__(".mp4 video", "aventa"),
                        "condition" => [
                            "video_type" => "local_video_popup"
                        ],
                    ]
                );

                $page->add_control(
                    "video_ogv",
                    [
                        "type"    => \Elementor\Controls_Manager::TEXT,
                        "label"       => esc_html__(".ogv extension", "aventa"),
                        "placeholder" => esc_html__(".ogv video", "aventa"),
                        "condition" => [
                            "video_type" => "local_video_popup"
                        ],
                    ]
                );

                $page->add_control(
                    "video_vimeo_id",
                    [
                        "type"    => \Elementor\Controls_Manager::TEXT,
                        "label"       => esc_html__("Vimeo Video link", "aventa"),
                        "condition" => [
                            "video_type" => "embeded_video_vimeo_popup"
                        ],
                    ]
                );

                $page->add_control(
                    "video_youtube_id",
                    [
                        "type"    => \Elementor\Controls_Manager::TEXT,
                        "label"       => esc_html__("Youtube Video link", "aventa"),
                        "condition" => [
                            "video_type" => "embeded_video_youtube_popup"
                        ],
                    ]
                );

                $page->add_control(
                    "video_play_button_color",
                    [
                        "type"    => \Elementor\Controls_Manager::SELECT,
                        "label"   => esc_html__("Select play button style.", "aventa"),
                        "default" => "light",
                        "options" => [
                            "light" => esc_html__("Light", "aventa"),
                            "dark"  => esc_html__("Dark", "aventa"),
                        ],
                        "condition" => [
                            "video_type!" => "none"
                        ],
                    ]
                );

                $page->end_controls_section();

            }

        }
    }
}

add_action( "elementor/documents/register_controls", "Aventa\\rad_add_custom_controls_product_settings",10, 2);
add_action( "elementor/element/wp-post/document_settings/before_section_start", "Aventa\\rad_add_custom_controls_post_settings",10, 2);
add_action( "elementor/element/wp-page/document_settings/before_section_start", "Aventa\\rad_add_custom_controls_page_settings",10, 2);

