<?php
namespace Aventa;

use Elementor\Plugin as Elementor;

class Rad_Widget_Loader {

  private static $_instance = null;

  /**
   * Get an instance of this class
  */
  public static function instance() {
    if ( is_null( self::$_instance ) ) {
      self::$_instance = new self();
    }

    return self::$_instance;
  }
  
  /**
   * Calling class functions to run using Elementor hooks
  */
  public function __construct() {
    add_action( "elementor/elements/categories_registered", [ $this, "add_elementor_widget_categories" ] );
    add_action( "elementor/controls/register", [ $this, "register_controls" ] );
    add_action( "elementor/widgets/register", [ $this, "register_widgets" ] );
    add_action( "elementor/widgets/register", [ $this, "unregister_widgets" ], 15);
  }

  /**
   * Add Aventa widget categories to the Elementor
  */
  function add_elementor_widget_categories( $elements_manager ) {
    $elements_manager->add_category(
      Rad_Helpers::WIDGETS_CATEGORY,
      [ "title" => esc_html__( "Aventa", "aventa" ) ]
    );

    if ( class_exists( "WooCommerce" ) ) {
      $elements_manager->add_category(
        Rad_Helpers::WC_WIDGETS_CATEGORY,
        [ "title" => esc_html__( "Aventa - Shop", "aventa" ) ]
      );
    }
  }

  /**
   * Register custom controls
  */
  public function register_controls($controls_manager) {
    $controls_filename = [
      "icons",
      "visual-option-selector"
		];

		foreach ( $controls_filename as $control_filename ) {
			require_once( __DIR__ . "/controls/" . $control_filename . ".php" );

			$class_name = ucwords(str_replace( "-", "_", $control_filename ));

			$class_name = __NAMESPACE__ . "\\Rad_" . $class_name . "_Control";

      $class = new $class_name();

			$controls_manager->register( $class );
		}

    return $controls_manager;
  }

  /**
   * Register Aventa widgets for Elementor
  */
  public function register_widgets( $widgets_manager) {
    $widgets_filename = [
      "heading",
      "custom-heading",
      "progress-bar",
      "chart",
      "icon-block",
      "counter-block",
      "accordion-block",
      "toggle-block",
      "tab-block",
      "tour-block",
      "team-member",
      "testimonial",
      "social-icons",
      "count-down",
      "banner",
      "image-carousel",
      "gallery-carousel",
      "slideshow",
      "reveal-slideshow",
      "advance-marquee",
      "button",
      "link",
      "card-blog",
      "video"
		];

    // Aventa shop widgets
    if ( class_exists( "WooCommerce" ) ) {
      array_push( 
        $widgets_filename,
        "products",
        "product-categories",
        "single-product",
        "product-page",
        "add-to-cart",
        "cart",
        "my-account",
        "order-tracking-form"
      );
    }

    // Register newsletter widget only when MC4WP is active
    if ( class_exists("MC4WP_MailChimp") ) {
      $widgets_filename[] = "newsletter";
    }

		foreach ( $widgets_filename as $widget_filename ) {
			require_once( __DIR__ . "/widgets/" . $widget_filename . ".php" );

			$class_name = ucwords(str_replace( "-", "_", $widget_filename ));

			$class_name = __NAMESPACE__ . "\\Rad_" . $class_name . "_Widget";

			 $widgets_manager->register( new $class_name() );
		}
  }

  /**
   * Unregister incompatible or unnecessary Elementor widgets
  */
  public function unregister_widgets($widgets_manager) {
    $widgets_name = [];

		foreach ( $widgets_name as $widget_name ) {
			$widgets_manager->unregister( $widget_name );
		}
  }

}


Rad_Widget_Loader::instance();