<?php

// Initialising Shortcodes
if (class_exists("WPBakeryVisualComposerAbstract")) {

    /*-----------------------------------------------------------------------------------*/
    /*  Remove “Design options”, “Custom CSS” tabs from WPbakery in Admin dashboard
    /*-----------------------------------------------------------------------------------*/
    add_action("vc_before_init", "rad_vc_set_as_theme");
    function rad_vc_set_as_theme()
    {
        vc_set_as_theme();
    }

    /*-----------------------------------------------------------------------------------*/
    /*  Define shortcodes as VC params
    /*-----------------------------------------------------------------------------------*/
    add_action("init", "rad_init_wpbakery", 1);
    function rad_init_wpbakery()
    {
        require_once RAD_THEME_INC . "/admin/compatibility/wpbakery/init.php";
    }
    /*-----------------------------------------------------------------------------------*/
    /*  Set default folder to load VC elements
    /*-----------------------------------------------------------------------------------*/
    vc_set_shortcodes_templates_dir(RAD_THEME_DIR . "/templates/vc-elements");
}

/*-----------------------------------------------------------------------------------*/
/*  Elementor widgets init
/*-----------------------------------------------------------------------------------*/
if ( rad_is_elementor_active() ) {
    
    require_once RAD_THEME_INC . "/admin/compatibility/elementor/init.php";
    require_once RAD_THEME_INC . "/admin/compatibility/elementor/helpers.php";
    require_once RAD_THEME_INC . "/admin/compatibility/elementor/settings.php";

    function rad_elementor_editor_css() {
        require_once RAD_THEME_INC . "/admin/compatibility/elementor/editor-live-css.php";
    }

    add_action("elementor/editor/after_enqueue_styles", "rad_elementor_editor_css");
}