(function($) {
    function video_type_dependencies() {
        var $video_type = $('select[name="video_type"]'),
            $self_hosted_video_section = $('.field.video_extensions'),
            $vimeo_section = $('.field.video_vimeo_id'),
            $youtube_section = $('.field.video_youtube_id'),
            $video_webm = $('.field.video_webm'),
            $video_mp4 = $('.field.video_mp4'),
            $video_ogv = $('.field.video_ogv'),
            $play_button_style_section = $('.field.video_play_button_color');

        function changeHandler() {
            var selected = $video_type.find(':selected').val();
            if ('none' == selected) {
                $youtube_section.slideUp('fast');
                $vimeo_section.slideUp('fast');
                $self_hosted_video_section.slideUp('fast');
                $play_button_style_section.slideUp('fast');
                $video_webm.slideUp('fast');
                $video_mp4.slideUp('fast');
                $video_ogv.slideUp('fast');
            } else if ('local_video_popup' == selected) {
                $youtube_section.slideUp('fast');
                $vimeo_section.slideUp('fast');
                $self_hosted_video_section.slideDown('fast');
                $play_button_style_section.slideDown('fast');
                $video_webm.slideDown('fast');
                $video_mp4.slideDown('fast');
                $video_ogv.slideDown('fast');
            } else if ('embeded_video_vimeo_popup' == selected) { // Vimeo
                $youtube_section.slideUp('fast');
                $vimeo_section.slideDown('fast');
                $self_hosted_video_section.slideUp('fast');
                $play_button_style_section.slideDown('fast');
                $video_webm.slideUp('fast');
                $video_mp4.slideUp('fast');
                $video_ogv.slideUp('fast');
            } else // Youtube
            {
                $youtube_section.slideDown('fast');
                $vimeo_section.slideUp('fast');
                $self_hosted_video_section.slideUp('fast');
                $play_button_style_section.slideDown('fast');
                $video_webm.slideUp('fast');
                $video_mp4.slideUp('fast');
                $video_ogv.slideUp('fast');
            }
        }
        $video_type.change(changeHandler);
        changeHandler();
    }

    function product_social_share_dependencies() {
        var $product_social_share_inherit = $('input[name="social_share_inherit"]'),
            $product_social_share_display = $product_social_share_inherit.closest('.field').next('.field');

        function toggle_product_social_share_section() {
            if (Math.round($product_social_share_inherit.val()) == 0) {
                $product_social_share_display.hide();
            } else {
                $product_social_share_display.show();
            }
        }
        setTimeout(function() {
            $product_social_share_inherit.siblings('.switch').on('change', toggle_product_social_share_section);
            toggle_product_social_share_section();
        }, 500);
    }

    function ColorPicker() {
        if (!$.fn.wpColorPicker) return;
        $('#product_meta_box .colorinput').each(function() {
            $(this).wpColorPicker({
                palettes: false
            });
        });
    }
    $(document).ready(function() {
        ColorPicker();
        video_type_dependencies();
        product_social_share_dependencies();
    });
})(jQuery);