<?php
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once RAD_THEME_ADMIN . '/libs/tgm/class-tgm-plugin-activation.php';

function rad_register_required_plugins()
{
    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
        //Aventa Core
        array(
            'name'               => 'Aventa core',
            'slug'               => 'aventa-core',
            'source'             => rad_path_combine(RAD_THEME_ADMIN, '3rd-party/aventa-core.zip'),
            'required'           => true,
            'version'            => '1.6',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => 'Wordpress Importer',
            'slug'     => 'wordpress-importer',
            'required' => true,
        ),
        // woocomerce
        array(
            'name'     => 'WooCommerce',
            'slug'     => 'woocommerce',
            'required' => true,
        ),
        //Visual Composer
        array(
            'name'               => 'WPBakery Visual Composer',
            'slug'               => 'js_composer',
            'source'             => rad_path_combine(RAD_THEME_ADMIN, '3rd-party/js_composer.zip'),
            'required'           => false,
            'version'            => '6.10.0',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
        ),
        //Elementor
        array(
            'name'             => 'Elementor',
            'slug'             => 'elementor',
            'force_activation' => false,
            'required'         => false,
        ),
        // MC4WP
        array(
            'name'     => 'MC4WP: Mailchimp for WordPress',
            'slug'     => 'mailchimp-for-wp',
            'required' => true,
        ),
        //revolution Slider
        array(
            'name'     => 'revolutionSlider WP',
            'slug'     => 'revslider',
            'source'   => rad_path_combine(RAD_THEME_ADMIN, '3rd-party/revslider.zip'),
            'required' => true,
            'version'  => '6.6.8',
        ),
        //Contact Form 7
        array(
            'name'             => 'Contact Form 7',
            'slug'             => 'contact-form-7',
            'force_activation' => false,
            'required'         => true,
        ),
        //Contact Form 7
        array(
            'name'             => 'Contact Form 7 Widget For Elementor',
            'slug'             => 'ht-contactform',
            'force_activation' => false,
            'required'         => true,
        ),
        //Custom Product Tabs
        array(
            'name'             => 'Custom Product Tabs for WooCommerce',
            'slug'             => 'yikes-inc-easy-custom-woocommerce-product-tabs',
            'force_activation' => false,
            'required'         => false,
        ),
        //WooCommerce Multi-step Checkout
        array(
            'name'             => 'WooCommerce Multi-step Checkout',
            'slug'             => 'wp-multi-step-checkout',
            'force_activation' => false,
            'required'         => false,
        ),
        // Wishlist
        array(
            'name'     => 'YITH WooCommerce Wishlist',
            'slug'     => 'yith-woocommerce-wishlist',
            'required' => false,
        ),
        array(
            'name'     => 'WooCommerce Currency Switcher',
            'slug'     => 'woocommerce-currency-switcher',
            'required' => false,
        ),
        //Envato toolkit plugin
        array(
            'name'               => 'Envato Market',
            'slug'               => 'envato-market',
            'required'           => false,
            'force_activation'   => false,
            'version'            => '2.0.6',
            'force_deactivation' => false,
            'source'             => rad_path_combine(RAD_THEME_ADMIN, '3rd-party/envato-market.zip'),
        ),
        //Instagram feed
        array(
            'name'     => 'Smash Balloon Social photo Feed',
            'slug'     => 'instagram-feed',
            'required' => false,
        ),
    );

    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'domain'           => 'aventa', // Text domain - likely want to be the same as your theme.
        'default_path'     => '', // Default absolute path to pre-packaged plugins
        'parent_slug'      => 'aventa_theme_settings', // Default parent menu slug
        'parent_admin_url' => 'aventa_theme_settings', // Default parent URL slug
        'capability'       => 'manage_options', // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'menu'             => 'install-required-plugins', // Menu slug
        'has_notices'      => true, // Show admin notices or not
        'is_automatic'     => false, // Automatically activate plugins after installation or not
        'message'          => '', // Message to output right before the plugins table
        'strings'          => array(
            'page_title'                      => esc_html__('Install Required Plugins', 'aventa'),
            'menu_title'                      => esc_html__('Install Plugins', 'aventa'),
            'installing'                      => esc_html__('Installing Plugin: %s', 'aventa'), // %1$s = plugin name
            'oops'                            => esc_html__('Something went wrong with the plugin API.', 'aventa'),
            'notice_can_install_required'     => _n_noop('Aventa theme requires the following plugin: %1$s.', 'Aventa theme requires the following plugins: %1$s.', 'aventa'), // %1$s = plugin name(s)
            'notice_can_install_recommended'  => _n_noop('Aventa theme recommends the following plugin: %1$s.', 'Aventa theme recommends the following plugins: %1$s.', 'aventa'), // %1$s = plugin name(s)
            'notice_cannot_install'           => _n_noop('Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'aventa'), // %1$s = plugin name(s)
            'notice_can_activate_required'    => _n_noop('The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'aventa'), // %1$s = plugin name(s)
            'notice_can_activate_recommended' => _n_noop('The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'aventa'), // %1$s = plugin name(s)
            'notice_cannot_activate'          => _n_noop('Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'aventa'), // %1$s = plugin name(s)
            'notice_ask_to_update'            => _n_noop('The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'aventa'), // %1$s = plugin name(s)
            'notice_cannot_update'            => _n_noop('Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'aventa'), // %1$s = plugin name(s)
            'install_link'                    => _n_noop('Start installing plugin', 'Start installing the plugins', 'aventa'),
            'activate_link'                   => _n_noop('Start activating installed plugin', 'Start activating installed plugins', 'aventa'),
            'update_link'                   => _n_noop('Start updating plugin', 'Start updating plugins', 'aventa'),
            'return'                          => esc_html__('Return to required plugins installer', 'aventa'),
            'plugin_activated'                => esc_html__('Plugin activated successfully.', 'aventa'),
            'complete'                        => esc_html__('All plugins installed and activated successfully. %s', 'aventa'), // %1$s = dashboard link
            'nag_type'                        => 'updated', // Determines admin notice type - can only be 'updated' or 'error'
        ),
    );

    tgmpa($plugins, $config);
}

add_action('tgmpa_register', 'rad_register_required_plugins');
