<?php
if (post_password_required()) {
    return;
}
?>

<div id="comments">
  <div class="container">
    <div class="span8 offset2">
      <?php
      if ($comments) {

          $num_comments = get_comments_number();

          if ($num_comments != 0) {
            ?>
            <h4 class="comments-count">
            <?php
            if ($num_comments < 10) {
              echo "0" . esc_html($num_comments) . " "; //prints zero before <10 nums
            } else {
              echo esc_html($num_comments) . " ";
            }

            if ($num_comments == 1) {
              //Comments text compatibility check
              esc_html_e("comment for \"", "aventa");
              the_title();
              echo "\"";
            } else {
              esc_html_e("comments for \"", "aventa");
              the_title();
              echo "\"";
            }?>
            </h4>
          <?php
          }?>
          <ul class="comments-list">
            <?php
            wp_list_comments(
              array(
                  "avatar_size" => 64,
                  "callback"    => "rad_theme_comment",
              )
            );
          ?>
          </ul>
          <?php

          $comment_pagination = paginate_comments_links(
              array(
                  "echo"      => false,
                  "end_size"  => 0,
                  "mid_size"  => 0,
                  "next_text" => esc_html__("Newer Comments", "aventa"),
                  "prev_text" => esc_html__("Older Comments", "aventa"),
              )
          );

          if ($comment_pagination) {
              $pagination_classes = "";

              // If we're only showing the "Next" link, add a class indicating so.
              if (false === strpos($comment_pagination, "prev page-numbers")) {
                  $pagination_classes = " only-next";
              }
              ?>

              <nav class="comments-pagination pagination<?php echo "" . $pagination_classes; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- static output   ?>" aria-label="<?php esc_attr_e("Comments", "aventa");?>">
                <?php echo wp_kses_post($comment_pagination); ?>
              </nav>
            <?php
          }
      }

      if (comments_open() || pings_open()) {
          ?><div id="respond-wrap"><?php
          comment_form();
          ?></div><?php

      } elseif (is_single() && $comments) {?>
        <p class="nocomments"><?php esc_html_e("Comments are closed.", "aventa");?></p><?php
      }

      ?>
    </div>
  </div>
</div>