<?php
/**
 * Archive template
 */

get_header();

// blog Sidebar For Classic blog
$blogSidebar = "span7 sidebar-blog offset1";
$sidebar     = rad_get_option("blog-sidebar");

if ($sidebar == "no-sidebar") {
    $blogSidebar = "span12";
}

if ($sidebar != "no-sidebar" && !is_active_sidebar("main-sidebar")) {
    $blogSidebar = "span10 offset1 sidebar-blog";
}

?>
<section id="blog">
	<div class="container">
		<div id="blog-articles" class="<?php echo esc_attr($blogSidebar); ?>">
			<?php
			if (have_posts()) {
			    while (have_posts()) {
			        the_post();
			        global $post;
			        $format    = rad_get_post_format(get_the_ID());
			        $anim_attr = rad_make_anim_attributes("fade-in-bottom", 100);
			        ?>
					<article <?php post_class("clearfix elem-anim"); echo " " . $anim_attr;?> >
						<?php get_template_part("templates/core/post/post", $format);?>
					</article>
					<?php
				}
			}

			if (have_posts()) {
				rad_the_posts_navigation();
			}?>
		</div>
		<?php
		if ($sidebar == "with-sidebar" && is_active_sidebar("main-sidebar")) {?>
			<div id="blog-sidebar-wrapper" class="span3 blog-page-sidebar">
				<?php dynamic_sidebar("main-sidebar");?>
			</div>
		<?php }?>
	</div>
</section>
<?php get_footer();?>