<?php

class Rpwsdt_Front extends Rpwsdt_Main {

    public function __construct() {
        parent::__construct();
        if ($this->getSetting('enable')) {
            add_action('plugins_loaded', array($this, "initFrondEnd"), 11);
        }
    }

    public function initFrondEnd() {
        /* hook for register front css and js */
        add_filter('woocommerce_cart_shipping_method_full_label', array($this, 'displayDeliveryText'), 10, 2);
        add_action("wp_enqueue_scripts", array($this, "enqueueScripts"), 100);
        add_action("woocommerce_thankyou", array($this, "createOrder"), 100);

        /* hook for display shipping time on thankyou page */
        add_action("woocommerce_order_shipping_to_display", array($this, "showOrderShippingTime"), 10, 2);
        add_action('woocommerce_email_order_meta', array($this, "displayInEmail"), 10, 3);
    }

    public function displayInEmail($order, $sent_to_admin, $plain_text) {
        $shippingData = $this->getOrderShippingMethod($order);
        if (isset($shippingData['instance_id'])) {
            $method_id = $shippingData['instance_id'];
            $estDay = $this->getShippingSetting('estimate_time', $method_id);
            $orderShippingTime = $this->getEstimationDeliveryTime($estDay, $method_id);
            if (!empty($orderShippingTime)) {
                $shippingText = $this->getOrderDeliveryText($orderShippingTime);
                echo '<div class="address"><p><strong>' . esc_html__('Estimation shipping time:', self::$taxdomain) . '</strong>' . $shippingText . '</p></div>';
            }
        }
    }

    public function createOrder($order_id) {
        $order = wc_get_order($order_id);
        $shippingData = $this->getOrderShippingMethod($order);
        if (isset($shippingData['instance_id'])) {
            $method_id = $shippingData['instance_id'];
            $estDay = $this->getShippingSetting('estimate_time', $method_id);
            $esatimationDay = $this->getEstimationDeliveryTime($estDay, $method_id);
            $order->update_meta_data(self::$order_shipping_time_key, $esatimationDay);
            $order->save();
        }
    }

    public function displayDeliveryText($label, $method) {
        $instance_id = isset($method->instance_id) ? $method->instance_id : (int) substr($method->id, strpos($method->id, ':') + 1);
        $method_id = $instance_id ? (int) $instance_id : $method->method_id;
        $this->methodId = $method_id;
        if (!$this->getShippingSetting('enable', $method_id)) {
            return $label;
        }
        
        if ($this->getShippingSetting('estimate_time', $method_id)=="") {
            return $label;
        }
     
        $estDay = $this->getShippingSetting('estimate_time', $method_id);
        $esatimationDay = $this->getEstimationDeliveryTime($estDay, $method_id);
        if ($esatimationDay !== false) {
            return $label . $this->getEstimaedText($esatimationDay);
        }
        return $label;
    }

    public function getEstimaedText($estDay) {
        $settingText = $this->getSetting('estimate_text');
        $numberOfDay = $this->getDateDiff($estDay);
        $response = str_replace(array('{d}', '{date}'), array($numberOfDay, date_i18n($this->getSetting('date_format'), $estDay)), $settingText);
        $response = $this->pregReplaceDate($estDay, $response);
        return '<br><span class="rpwsdt_estimated_date">' . $response . '</span>';
    }

    public function getEstimationDeliveryTime($estDay, $method_id) {

        $estTime = $this->getEstTimeSetting($estDay, $method_id);
        $blockDate = $this->getBlockDates($method_id);

        $blockWeekday = $this->getBlockWeekday($method_id);

        $estDateCount = 0;
        $totalDayCount = 0;
        $currentDay = strtotime(date('Y-m-d'));
        while ($estTime > $estDateCount) {
            $estDay = strtotime('+' . $totalDayCount . ' day', $currentDay);
            $weekDay = date('w', $estDay);
            if (!in_array($estDay, $blockDate) && !in_array($weekDay, $blockWeekday)) {
                $estDateCount++;
            }
            $totalDayCount++;
        }
        return $estDay;
    }


    public function getEstTimeSetting($estTime, $method_id) {

        $endHours = $this->getShippingSetting('hours', $method_id);
        $endMinute = $this->getShippingSetting('minute', $method_id);
        if ($endHours == "") {
            return $estTime + 1;
        }

        $endDeliveryTime = strtotime(date("Y-m-d") . " " . $endHours . ":" . $endMinute . ":00");
        $currentDay = time();
        if ($currentDay > $endDeliveryTime) {
            $estTime = $estTime + 2;
        } else {
            $estTime = $estTime + 1;
        }

        return $estTime;
    }




    /**
     * Function for register  js and css
     */
    public function enqueueScripts() {
        wp_register_style('rpwsdt-style-handle', false);
        wp_enqueue_style('rpwsdt-style-handle');


        $inlineCss = '.rpwsdt_estimated_date{color:' . $this->getSetting('text_color') . ' !important;font-size:' . $this->getSetting('text_size') . 'px !important;}';
        wp_add_inline_style('rpwsdt-style-handle', $inlineCss);
        $order = wc_get_order(89);
    }

    public function getOrderShippingMethod($order) {
        $shippingItemData = array();

        foreach ($order->get_items('shipping') as $itemId => $shippingObj) {
            $shippingItemData = $shippingObj->get_data();
        }
        return $shippingItemData;
    }

}
